/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import org.numenta.nupic.Persistable;

public class Classification<T>
implements Persistable {
    private static final long serialVersionUID = 1L;
    private T[] actualValues;
    TIntObjectMap<double[]> probabilities = new TIntObjectHashMap();

    public Classification<T> copy() {
        Classification<T> retVal = new Classification<T>();
        retVal.actualValues = Arrays.copyOf(this.actualValues, this.actualValues.length);
        retVal.probabilities = new TIntObjectHashMap(this.probabilities);
        return retVal;
    }

    public T getActualValue(int bucketIndex) {
        if (this.actualValues == null || this.actualValues.length < bucketIndex + 1) {
            return null;
        }
        return this.actualValues[bucketIndex];
    }

    public T[] getActualValues() {
        return this.actualValues;
    }

    public void setActualValues(T[] values) {
        this.actualValues = values;
    }

    public int getActualValueCount() {
        return this.actualValues.length;
    }

    public double getStat(int step, int bucketIndex) {
        return ((double[])this.probabilities.get(step))[bucketIndex];
    }

    public void setStats(int step, double[] votes) {
        this.probabilities.put(step, (Object)votes);
    }

    public double[] getStats(int step) {
        return (double[])this.probabilities.get(step);
    }

    public T getMostProbableValue(int step) {
        int idx = -1;
        if (this.probabilities.get(step) == null || (idx = this.getMostProbableBucketIndex(step)) == -1) {
            return null;
        }
        return this.getActualValue(idx);
    }

    public int getMostProbableBucketIndex(int step) {
        if (this.probabilities.get(step) == null) {
            return -1;
        }
        double max = 0.0;
        int bucketIdx = -1;
        int i = 0;
        for (double d : (double[])this.probabilities.get(step)) {
            if (d > max) {
                max = d;
                bucketIdx = i;
            }
            ++i;
        }
        return bucketIdx;
    }

    public int getStepCount() {
        return this.probabilities.size();
    }

    public int getStatCount(int step) {
        return ((double[])this.probabilities.get(step)).length;
    }

    public int[] stepSet() {
        return this.probabilities.keySet().toArray();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.actualValues);
        result = 31 * result + (this.probabilities == null ? 0 : this.probabilities.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Classification other = (Classification)obj;
        if (!Arrays.equals(this.actualValues, other.actualValues)) {
            return false;
        }
        if (this.probabilities == null) {
            if (other.probabilities != null) {
                return false;
            }
        } else {
            for (int key : this.probabilities.keys()) {
                if (Arrays.equals((double[])this.probabilities.get(key), (double[])other.probabilities.get(key))) continue;
                return false;
            }
        }
        return true;
    }
}

