/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import org.numenta.nupic.Persistable;

public class MovingAverage
implements Persistable {
    private static final long serialVersionUID = 1L;
    private Calculation calc;
    private int windowSize;

    public MovingAverage(TDoubleList historicalValues, int windowSize) {
        this(historicalValues, -1.0, windowSize);
    }

    public MovingAverage(TDoubleList historicalValues, double total, int windowSize) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window size must be > 0");
        }
        this.windowSize = windowSize;
        this.calc = new Calculation();
        this.calc.historicalValues = (TDoubleList)(historicalValues == null || historicalValues.size() < 1 ? new TDoubleArrayList(windowSize) : historicalValues);
        this.calc.total = total != -1.0 ? total : this.calc.historicalValues.sum();
    }

    public static Calculation compute(TDoubleList slidingWindow, double total, double newVal, int windowSize) {
        return MovingAverage.compute(null, slidingWindow, total, newVal, windowSize);
    }

    private static Calculation compute(Calculation calc, TDoubleList slidingWindow, double total, double newVal, int windowSize) {
        if (slidingWindow == null) {
            throw new IllegalArgumentException("slidingWindow cannot be null.");
        }
        if (slidingWindow.size() == windowSize) {
            total -= slidingWindow.removeAt(0);
        }
        slidingWindow.add(newVal);
        total += newVal;
        if (calc == null) {
            return new Calculation(slidingWindow, total / (double)slidingWindow.size(), total);
        }
        return MovingAverage.copyInto(calc, slidingWindow, total / (double)slidingWindow.size(), total);
    }

    public double next(double newValue) {
        MovingAverage.compute(this.calc, this.calc.historicalValues, this.calc.total, newValue, this.windowSize);
        return this.calc.average;
    }

    public TDoubleList getSlidingWindow() {
        return this.calc.historicalValues;
    }

    public double getTotal() {
        return this.calc.total;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calc == null ? 0 : this.calc.hashCode());
        result = 31 * result + this.windowSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MovingAverage other = (MovingAverage)obj;
        if (this.calc == null ? other.calc != null : !this.calc.equals(other.calc)) {
            return false;
        }
        return this.windowSize == other.windowSize;
    }

    private static Calculation copyInto(Calculation c, TDoubleList slidingWindow, double average, double total) {
        c.historicalValues = slidingWindow;
        c.average = average;
        c.total = total;
        return c;
    }

    public static class Calculation
    implements Persistable {
        private static final long serialVersionUID = 1L;
        private double average;
        private TDoubleList historicalValues;
        private double total;

        public Calculation() {
        }

        public Calculation(TDoubleList historicalValues, double currentValue, double total) {
            this.average = currentValue;
            this.historicalValues = historicalValues;
            this.total = total;
        }

        public double getAverage() {
            return this.average;
        }

        public TDoubleList getHistoricalValues() {
            return this.historicalValues;
        }

        public double getTotal() {
            return this.total;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.average);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.historicalValues == null ? 0 : this.historicalValues.hashCode());
            temp = Double.doubleToLongBits(this.total);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Calculation other = (Calculation)obj;
            if (Double.doubleToLongBits(this.average) != Double.doubleToLongBits(other.average)) {
                return false;
            }
            if (this.historicalValues == null ? other.historicalValues != null : !this.historicalValues.equals(other.historicalValues)) {
                return false;
            }
            return Double.doubleToLongBits(this.total) == Double.doubleToLongBits(other.total);
        }
    }
}

