/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import org.joda.time.DateTime;
import org.numenta.nupic.Persistable;

public class Sample
implements Persistable {
    private static final long serialVersionUID = 1L;
    public final DateTime date;
    public final double score;
    public final double value;

    public Sample(DateTime timeStamp, double value, double score) {
        if (timeStamp == null) {
            throw new IllegalArgumentException("Sample must have a valid date");
        }
        this.date = timeStamp;
        this.value = value;
        this.score = score;
    }

    public DateTime timeStamp() {
        return this.date;
    }

    public String toString() {
        return this.timeStamp().toString() + ", value: " + this.value + ", metric: " + this.score;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sample other = (Sample)obj;
        if (this.date == null ? other.date != null : !this.date.equals((Object)other.date)) {
            return false;
        }
        if (Double.doubleToLongBits(this.score) != Double.doubleToLongBits(other.score)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

