/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.algorithms;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.numenta.nupic.ComputeCycle;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.monitor.ComputeDecorator;
import org.numenta.nupic.util.SparseObjectMatrix;

public class TemporalMemory
implements ComputeDecorator,
Serializable {
    private static final long serialVersionUID = 1L;

    public void init(Connections c) {
        SparseObjectMatrix<Column> matrix = c.getMemory() == null ? new SparseObjectMatrix<Column>(c.getColumnDimensions()) : c.getMemory();
        c.setMemory(matrix);
        int numColumns = matrix.getMaxIndex() + 1;
        c.setNumColumns(numColumns);
        int cellsPerColumn = c.getCellsPerColumn();
        Cell[] cells = new Cell[numColumns * cellsPerColumn];
        Column colZero = matrix.getObject(0);
        for (int i = 0; i < numColumns; ++i) {
            Column column = colZero == null ? new Column(cellsPerColumn, i) : matrix.getObject(i);
            for (int j = 0; j < cellsPerColumn; ++j) {
                cells[i * cellsPerColumn + j] = column.getCell(j);
            }
            if (colZero != null) continue;
            matrix.set(i, (Object)column);
        }
        c.setCells(cells);
    }

    @Override
    public ComputeCycle compute(Connections connections, int[] activeColumns, boolean learn) {
        ComputeCycle result = this.computeFn(connections, connections.getColumnSet(activeColumns), connections.getPredictiveCells(), connections.getActiveSegments(), connections.getActiveCells(), connections.getWinnerCells(), connections.getMatchingSegments(), connections.getMatchingCells(), learn);
        connections.setActiveCells(result.activeCells);
        connections.setWinnerCells(result.winnerCells);
        connections.setPredictiveCells(result.predictiveCells);
        connections.setSuccessfullyPredictedColumns(result.successfullyPredictedColumns);
        connections.setActiveSegments(result.activeSegments);
        connections.setLearningSegments(result.learningSegments);
        connections.setMatchingSegments(result.matchingSegments);
        connections.setMatchingCells(result.matchingCells);
        return result;
    }

    public ComputeCycle computeFn(Connections c, Set<Column> activeColumns, Set<Cell> prevPredictiveCells, Set<DistalDendrite> prevActiveSegments, Set<Cell> prevActiveCells, Set<Cell> prevWinnerCells, Set<DistalDendrite> prevMatchingSegments, Set<Cell> prevMatchingCells, boolean learn) {
        ComputeCycle cycle = new ComputeCycle();
        this.activateCorrectlyPredictiveCells(c, cycle, prevPredictiveCells, prevMatchingCells, activeColumns);
        this.burstColumns(c, cycle, activeColumns, cycle.successfullyPredictedColumns, prevActiveCells, prevWinnerCells);
        if (learn) {
            this.learnOnSegments(c, prevActiveSegments, cycle.learningSegments, prevActiveCells, cycle.winnerCells, prevWinnerCells, cycle.predictedInactiveCells, prevMatchingSegments);
        }
        this.computePredictiveCells(c, cycle, cycle.activeCells);
        return cycle;
    }

    public void activateCorrectlyPredictiveCells(Connections cnx, ComputeCycle c, Set<Cell> prevPredictiveCells, Set<Cell> prevMatchingCells, Set<Column> activeColumns) {
        Column column;
        for (Cell cell : prevPredictiveCells) {
            column = cell.getColumn();
            if (!activeColumns.contains(column)) continue;
            c.activeCells.add(cell);
            c.winnerCells.add(cell);
            c.successfullyPredictedColumns.add(column);
        }
        if (cnx.getPredictedSegmentDecrement() > 0.0) {
            for (Cell cell : prevMatchingCells) {
                column = cell.getColumn();
                if (activeColumns.contains(column)) continue;
                c.predictedInactiveCells.add(cell);
            }
        }
    }

    public void burstColumns(Connections c, ComputeCycle cycle, Set<Column> activeColumns, Set<Column> predictedColumns, Set<Cell> prevActiveCells, Set<Cell> prevWinnerCells) {
        activeColumns.removeAll(predictedColumns);
        for (Column column : activeColumns) {
            if (column == null || column.getCells() == null) {
                System.out.println("here");
            }
            List<Cell> cells = column.getCells();
            cycle.activeCells.addAll(cells);
            CellSearch cellSearch = this.getBestMatchingCell(c, cells, prevActiveCells);
            cycle.winnerCells.add(cellSearch.bestCell);
            DistalDendrite bestSegment = cellSearch.bestSegment;
            if (bestSegment == null && prevWinnerCells.size() > 0) {
                bestSegment = cellSearch.bestCell.createSegment(c);
            }
            if (bestSegment == null) continue;
            cycle.learningSegments.add(bestSegment);
        }
    }

    public void learnOnSegments(Connections c, Set<DistalDendrite> prevActiveSegments, Set<DistalDendrite> learningSegments, Set<Cell> prevActiveCells, Set<Cell> winnerCells, Set<Cell> prevWinnerCells, Set<Cell> predictedInactiveCells, Set<DistalDendrite> prevMatchingSegments) {
        double permanenceIncrement = c.getPermanenceIncrement();
        double permanenceDecrement = c.getPermanenceDecrement();
        HashSet<DistalDendrite> prevAndLearning = new HashSet<DistalDendrite>(prevActiveSegments);
        prevAndLearning.addAll(learningSegments);
        for (DistalDendrite dd : prevAndLearning) {
            boolean isLearningSegment = learningSegments.contains(dd);
            boolean isFromWinnerCell = winnerCells.contains(dd.getParentCell());
            Set<Synapse> activeSynapses = dd.getActiveSynapses(c, prevActiveCells);
            if (isLearningSegment || isFromWinnerCell) {
                dd.adaptSegment(c, activeSynapses, permanenceIncrement, permanenceDecrement);
            }
            int n = c.getMaxNewSynapseCount() - activeSynapses.size();
            if (!isLearningSegment || n <= 0) continue;
            Set<Cell> learnCells = dd.pickCellsToLearnOn(c, n, prevWinnerCells, c.getRandom());
            for (Cell sourceCell : learnCells) {
                dd.createSynapse(c, sourceCell, c.getInitialPermanence());
            }
        }
        if (c.getPredictedSegmentDecrement() > 0.0) {
            for (DistalDendrite segment : prevMatchingSegments) {
                boolean isPredictedInactiveCell = predictedInactiveCells.contains(segment.getParentCell());
                if (!isPredictedInactiveCell) continue;
                Set<Synapse> activeSynapses = segment.getActiveSynapses(c, prevActiveCells);
                segment.adaptSegment(c, activeSynapses, -c.getPredictedSegmentDecrement(), 0.0);
            }
        }
    }

    public void computePredictiveCells(Connections c, ComputeCycle cycle, Set<Cell> activeCells) {
        TObjectIntHashMap numActiveConnectedSynapsesForSegment = new TObjectIntHashMap();
        TObjectIntHashMap numActiveSynapsesForSegment = new TObjectIntHashMap();
        double connectedPermanence = c.getConnectedPermanence();
        for (Cell cell : activeCells) {
            for (Synapse syn : c.getReceptorSynapses(cell)) {
                DistalDendrite segment = (DistalDendrite)syn.getSegment();
                double permanence = syn.getPermanence();
                if (permanence >= connectedPermanence) {
                    numActiveConnectedSynapsesForSegment.adjustOrPutValue((Object)segment, 1, 1);
                    if (numActiveConnectedSynapsesForSegment.get((Object)segment) >= c.getActivationThreshold()) {
                        cycle.activeSegments.add(segment);
                        cycle.predictiveCells.add(segment.getParentCell());
                    }
                }
                if (!(permanence > 0.0) || !(c.getPredictedSegmentDecrement() > 0.0)) continue;
                numActiveSynapsesForSegment.adjustOrPutValue((Object)segment, 1, 1);
                if (numActiveSynapsesForSegment.get((Object)segment) < c.getMinThreshold()) continue;
                cycle.matchingSegments.add(segment);
                cycle.matchingCells.add(segment.getParentCell());
            }
        }
    }

    @Override
    public void reset(Connections connections) {
        connections.getActiveCells().clear();
        connections.getPredictiveCells().clear();
        connections.getActiveSegments().clear();
        connections.getWinnerCells().clear();
        connections.getMatchingCells().clear();
        connections.getMatchingSegments().clear();
    }

    public CellSearch getBestMatchingCell(Connections c, List<Cell> columnCells, Set<Cell> activeCells) {
        int maxSynapses = 0;
        Cell bestCell = null;
        DistalDendrite bestSegment = null;
        for (Cell cell : columnCells) {
            SegmentSearch bestMatchResult = this.getBestMatchingSegment(c, cell, activeCells);
            if (bestMatchResult.bestSegment == null || bestMatchResult.numActiveSynapses <= maxSynapses) continue;
            maxSynapses = bestMatchResult.numActiveSynapses;
            bestCell = cell;
            bestSegment = bestMatchResult.bestSegment;
        }
        if (bestCell == null) {
            bestCell = this.getLeastUsedCell(c, columnCells);
        }
        return new CellSearch(bestCell, bestSegment);
    }

    public SegmentSearch getBestMatchingSegment(Connections c, Cell columnCell, Set<Cell> activeCells) {
        int maxSynapses = c.getMinThreshold();
        DistalDendrite bestSegment = null;
        int bestNumActiveSynapses = 0;
        int numActiveSynapses = 0;
        for (DistalDendrite segment : c.getSegments(columnCell)) {
            numActiveSynapses = 0;
            for (Synapse synapse : c.getSynapses(segment)) {
                if (!activeCells.contains(synapse.getPresynapticCell()) || !(synapse.getPermanence() > 0.0)) continue;
                ++numActiveSynapses;
            }
            if (numActiveSynapses < maxSynapses) continue;
            maxSynapses = numActiveSynapses;
            bestSegment = segment;
            bestNumActiveSynapses = numActiveSynapses;
        }
        return new SegmentSearch(bestSegment, bestNumActiveSynapses);
    }

    public Cell getLeastUsedCell(Connections c, List<Cell> columnCells) {
        LinkedHashSet<Cell> leastUsedCells = new LinkedHashSet<Cell>();
        int minNumSegments = Integer.MAX_VALUE;
        for (Cell cell : columnCells) {
            int numSegments = c.getSegments(cell).size();
            if (numSegments < minNumSegments) {
                minNumSegments = numSegments;
                leastUsedCells.clear();
            }
            if (numSegments != minNumSegments) continue;
            leastUsedCells.add(cell);
        }
        int randomIdx = c.getRandom().nextInt(leastUsedCells.size());
        ArrayList l = new ArrayList(leastUsedCells);
        Collections.sort(l);
        return (Cell)l.get(randomIdx);
    }

    public class SegmentSearch {
        public DistalDendrite bestSegment;
        public int numActiveSynapses;

        public SegmentSearch(DistalDendrite bestSegment, int numActiveSynapses) {
            this.bestSegment = bestSegment;
            this.numActiveSynapses = numActiveSynapses;
        }
    }

    public class CellSearch {
        public Cell bestCell;
        public DistalDendrite bestSegment;

        public CellSearch() {
        }

        public CellSearch(Cell bestCell, DistalDendrite bestSegment) {
            this.bestCell = bestCell;
            this.bestSegment = bestSegment;
        }
    }
}

