/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.datagen;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.numenta.nupic.datagen.PatternMachine;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Tuple;

public class SequenceMachine {
    private PatternMachine patternMachine;
    public static final Set<Integer> NONE = new HashSet<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "None";
        }
    };

    public SequenceMachine(PatternMachine pMachine) {
        this.patternMachine = pMachine;
    }

    public List<Integer> generateNumbers(int numSequences, int sequenceLength, Tuple sharedRange) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        TIntArrayList sharedNumbers = null;
        int sharedStart = 0;
        int sharedEnd = 0;
        if (sharedRange != null && sharedRange.size() == 2) {
            sharedEnd = (Integer)sharedRange.get(1);
            sharedStart = (Integer)sharedRange.get(0);
            int sharedLength = sharedEnd - sharedStart;
            sharedNumbers = new TIntArrayList(ArrayUtils.xrange(numSequences * sequenceLength, numSequences * sequenceLength + sharedLength, 1));
        }
        for (int i = 0; i < numSequences; ++i) {
            int start = i * sequenceLength;
            int[] newNumbers = ArrayUtils.xrange(start, start + sequenceLength, 1);
            ArrayUtils.shuffle(newNumbers);
            if (sharedRange != null) {
                ArrayUtils.replace(sharedStart, sharedEnd, newNumbers, sharedNumbers.toArray());
            }
            numbers.addAll(Arrays.asList(ArrayUtils.toBoxed(newNumbers)));
            numbers.add(-1);
        }
        return numbers;
    }

    public List<Set<Integer>> generateFromNumbers(List<Integer> numbers) {
        ArrayList<Set<Integer>> sequence = new ArrayList<Set<Integer>>();
        for (Integer i : numbers) {
            if (i == -1) {
                sequence.add(NONE);
                continue;
            }
            LinkedHashSet<Integer> pattern = this.patternMachine.get(i);
            sequence.add(pattern);
        }
        return sequence;
    }

    public List<Set<Integer>> addSpatialNoise(List<Set<Integer>> sequence, double amount) {
        ArrayList<Set<Integer>> newSequence = new ArrayList<Set<Integer>>();
        for (Set<Integer> pattern : sequence) {
            if (!pattern.equals(NONE)) {
                pattern = this.patternMachine.addNoise(pattern, amount);
            }
            newSequence.add(pattern);
        }
        return newSequence;
    }

    public String prettyPrintSequence(List<Set<Integer>> sequence, int verbosity) {
        String text = "";
        for (int i = 0; i < sequence.size(); ++i) {
            Set<Integer> pattern = sequence.get(i);
            if (pattern == NONE) {
                text = text + "<reset>";
                if (i >= sequence.size() - 1) continue;
                text = text + "\n";
                continue;
            }
            text = text + this.patternMachine.prettyPrintPattern(pattern, verbosity);
        }
        return text;
    }
}

