/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Synapse;

public class Cell
implements Comparable<Cell>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int index;
    final Integer boxedIndex;
    private final Column column;
    private final int hashcode;

    public Cell(Column column, int colSeq) {
        this.column = column;
        this.index = column.getIndex() * column.getNumCellsPerColumn() + colSeq;
        this.boxedIndex = new Integer(this.index);
        this.hashcode = this.hashCode();
    }

    public int getIndex() {
        return this.index;
    }

    public Column getColumn() {
        return this.column;
    }

    public void addReceptorSynapse(Connections c, Synapse s) {
        c.getReceptorSynapses(this).add(s);
    }

    public void removeReceptorSynapse(Connections c, Synapse s) {
        c.getReceptorSynapses(this).remove(s);
        c.decrementSynapses();
    }

    public Set<Synapse> getReceptorSynapses(Connections c) {
        return c.getReceptorSynapses(this);
    }

    public DistalDendrite createSegment(Connections c) {
        DistalDendrite dd = new DistalDendrite(this, c.incrementSegments());
        c.getSegments(this).add(dd);
        return dd;
    }

    public List<DistalDendrite> getSegments(Connections c) {
        return c.getSegments(this);
    }

    public String toString() {
        return String.valueOf(this.index);
    }

    @Override
    public int compareTo(Cell arg0) {
        return this.boxedIndex.compareTo(arg0.boxedIndex);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            return result;
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cell other = (Cell)obj;
        return this.index == other.index;
    }
}

