/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.numenta.nupic.Connections;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.Segment;
import org.numenta.nupic.model.Synapse;

public class DistalDendrite
extends Segment
implements Persistable {
    private static final long serialVersionUID = 1L;
    private static final double EPSILON = 1.0E-7;
    private Cell cell;

    public DistalDendrite(Cell cell, int index) {
        super(index);
        this.cell = cell;
        this.index = index;
    }

    public Cell getParentCell() {
        return this.cell;
    }

    public Synapse createSynapse(Connections c, Cell sourceCell, double permanence) {
        Pool pool = new Pool(1);
        Synapse s = super.createSynapse(c, c.getSynapses(this), sourceCell, pool, c.incrementSynapses(), sourceCell.getIndex());
        pool.setPermanence(c, s, permanence);
        return s;
    }

    public List<Synapse> getAllSynapses(Connections c) {
        return c.getSynapses(this);
    }

    public Set<Synapse> getActiveSynapses(Connections c, Set<Cell> activeCells) {
        LinkedHashSet<Synapse> synapses = new LinkedHashSet<Synapse>();
        for (Synapse synapse : c.getSynapses(this)) {
            if (!activeCells.contains(synapse.getPresynapticCell())) continue;
            synapses.add(synapse);
        }
        return synapses;
    }

    public void adaptSegment(Connections c, Set<Synapse> activeSynapses, double permanenceIncrement, double permanenceDecrement) {
        ArrayList<Synapse> synapsesToDestroy = null;
        for (Synapse synapse : c.getSynapses(this)) {
            double permanence = synapse.getPermanence();
            permanence = activeSynapses.contains(synapse) ? (permanence += permanenceIncrement) : (permanence -= permanenceDecrement);
            double d = permanence < 0.0 ? 0.0 : (permanence = permanence > 1.0 ? 1.0 : permanence);
            if (Math.abs(permanence) < 1.0E-7) {
                if (synapsesToDestroy == null) {
                    synapsesToDestroy = new ArrayList<Synapse>();
                }
                synapsesToDestroy.add(synapse);
                continue;
            }
            synapse.setPermanence(c, permanence);
        }
        if (synapsesToDestroy != null) {
            for (Synapse s : synapsesToDestroy) {
                s.destroy(c);
            }
        }
    }

    public Set<Cell> pickCellsToLearnOn(Connections c, int numPickCells, Set<Cell> prevWinners, Random random) {
        LinkedHashSet<Cell> candidates = new LinkedHashSet<Cell>(prevWinners);
        for (Synapse synapse : c.getSynapses(this)) {
            Cell sourceCell = synapse.getPresynapticCell();
            if (!candidates.contains(sourceCell)) continue;
            candidates.remove(sourceCell);
        }
        numPickCells = Math.min(numPickCells, candidates.size());
        ArrayList<Cell> cands = new ArrayList<Cell>(candidates);
        Collections.sort(cands);
        LinkedHashSet<Cell> cells = new LinkedHashSet<Cell>();
        for (int x = 0; x < numPickCells; ++x) {
            int i = random.nextInt(cands.size());
            cells.add((Cell)cands.remove(i));
        }
        return cells;
    }

    public String toString() {
        return String.valueOf(this.index);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cell == null ? 0 : this.cell.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistalDendrite other = (DistalDendrite)obj;
        return !(this.cell == null ? other.cell != null : !this.cell.equals(other.cell));
    }
}

