/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.model;

import java.io.Serializable;
import java.util.List;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.Synapse;

public abstract class Segment
implements Comparable<Segment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int index;
    protected Integer boxedIndex;

    public Segment(int index) {
        this.index = index;
        this.boxedIndex = new Integer(index);
    }

    public int getIndex() {
        return this.index;
    }

    public Synapse createSynapse(Connections c, List<Synapse> syns, Cell sourceCell, Pool pool, int index, int inputIndex) {
        Synapse s = new Synapse(c, sourceCell, this, pool, index, inputIndex);
        syns.add(s);
        return s;
    }

    @Override
    public int compareTo(Segment arg0) {
        return this.boxedIndex.compareTo(arg0.boxedIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Segment other = (Segment)obj;
        return this.index == other.index;
    }
}

