/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.monitor.mixin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.numenta.nupic.monitor.mixin.CountsTrace;
import org.numenta.nupic.monitor.mixin.MonitorMixinBase;
import org.numenta.nupic.monitor.mixin.Trace;

public class IndicesTrace
extends Trace<LinkedHashSet<Integer>> {
    public IndicesTrace(MonitorMixinBase monitor, String title) {
        super(monitor, title);
    }

    public CountsTrace makeCountsTrace() {
        CountsTrace trace = new CountsTrace(this.monitor, String.format("# %s", this.title));
        trace.items = this.items.stream().map(l -> l.size()).collect(Collectors.toList());
        return trace;
    }

    public CountsTrace makeCumCountsTrace() {
        CountsTrace trace = new CountsTrace(this.monitor, String.format("# (cumulative) %s", this.title));
        CountsTrace countsTrace = this.makeCountsTrace();
        int[] accum = new int[]{0};
        trace.items = countsTrace.items.stream().map(i -> {
            accum[0] = accum[0] + i;
            return accum[0];
        }).collect(Collectors.toList());
        return trace;
    }

    public String prettyPrintDatum(Collection<Integer> c) {
        ArrayList<Integer> l = null;
        l = new ArrayList<Integer>(c);
        Collections.sort(l);
        return ((Object)l).toString().replace("[", "").replace("]", "").trim();
    }
}

