/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.monitor.mixin;

import com.bethecoder.table.AsciiTableInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.numenta.nupic.ComputeCycle;
import org.numenta.nupic.Connections;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.monitor.ComputeDecorator;
import org.numenta.nupic.monitor.mixin.BoolsTrace;
import org.numenta.nupic.monitor.mixin.CountsTrace;
import org.numenta.nupic.monitor.mixin.IndicesTrace;
import org.numenta.nupic.monitor.mixin.Metric;
import org.numenta.nupic.monitor.mixin.MonitorMixinBase;
import org.numenta.nupic.monitor.mixin.StringsTrace;
import org.numenta.nupic.monitor.mixin.Trace;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.Tuple;

public interface TemporalMemoryMonitorMixin
extends MonitorMixinBase {
    public ComputeDecorator getMonitor();

    public boolean resetActive();

    public void setResetActive(boolean var1);

    public boolean transitionTracesStale();

    public void setTransitionTracesStale(boolean var1);

    default public IndicesTrace mmGetTraceActiveColumns() {
        return (IndicesTrace)this.getTraceMap().get("activeColumns");
    }

    default public IndicesTrace mmGetTracePredictiveCells() {
        return (IndicesTrace)this.getTraceMap().get("predictiveCells");
    }

    default public CountsTrace mmGetTraceNumSegments() {
        return (CountsTrace)this.getTraceMap().get("numSegments");
    }

    default public CountsTrace mmGetTraceNumSynapses() {
        return (CountsTrace)this.getTraceMap().get("numSynapses");
    }

    default public StringsTrace mmGetTraceSequenceLabels() {
        return (StringsTrace)this.getTraceMap().get("sequenceLabels");
    }

    default public BoolsTrace mmGetTraceResets() {
        return (BoolsTrace)this.getTraceMap().get("resets");
    }

    default public IndicesTrace mmGetTracePredictedActiveCells() {
        this.mmComputeTransitionTraces();
        return (IndicesTrace)this.getTraceMap().get("predictedActiveCells");
    }

    default public IndicesTrace mmGetTracePredictedInactiveCells() {
        this.mmComputeTransitionTraces();
        return (IndicesTrace)this.getTraceMap().get("predictedInactiveCells");
    }

    default public IndicesTrace mmGetTracePredictedActiveColumns() {
        this.mmComputeTransitionTraces();
        return (IndicesTrace)this.getTraceMap().get("predictedActiveColumns");
    }

    default public IndicesTrace mmGetTracePredictedInactiveColumns() {
        this.mmComputeTransitionTraces();
        return (IndicesTrace)this.getTraceMap().get("predictedInactiveColumns");
    }

    default public IndicesTrace mmGetTraceUnpredictedActiveColumns() {
        this.mmComputeTransitionTraces();
        return (IndicesTrace)this.getTraceMap().get("unpredictedActiveColumns");
    }

    default public Metric mmGetMetricFromTrace(Trace<Number> trace) {
        return Metric.createFromTrace(trace, this.mmGetTraceResets());
    }

    default public Metric mmGetMetricFromTrace(IndicesTrace trace) {
        List data = null;
        BoolsTrace excludeResets = this.mmGetTraceResets();
        if (excludeResets != null) {
            int[] i = new int[]{0};
            data = trace.items.stream().filter(t -> {
                int n = i[0];
                i[0] = n + 1;
                return (Boolean)excludeResets.items.get(n) == false;
            }).collect(Collectors.toList());
        }
        trace.items = data;
        CountsTrace iTrace = trace.makeCountsTrace();
        return Metric.createFromTrace(iTrace, this.mmGetTraceResets());
    }

    default public Metric mmGetMetricSequencesPredictedActiveCellsPerColumn() {
        this.mmComputeTransitionTraces();
        ArrayList<Integer> numCellsPerColumn = new ArrayList<Integer>();
        for (Map.Entry<String, ?> m : this.getDataMap().get("predictedActiveCellsForSequence").entrySet()) {
            numCellsPerColumn.add(((Set)m.getValue()).size());
        }
        return new Metric(this, "# predicted => active cells per column for each sequence", numCellsPerColumn);
    }

    default public Metric mmGetMetricSequencesPredictedActiveCellsShared() {
        this.mmComputeTransitionTraces();
        HashMap<Integer, Integer> numSequencesForCell = new HashMap<Integer, Integer>();
        for (Map.Entry<String, ?> m : this.getDataMap().get("predictedActiveCellsForSequence").entrySet()) {
            for (Integer cell : (Set)m.getValue()) {
                if (numSequencesForCell.get(cell) == null) {
                    numSequencesForCell.put(cell, 0);
                    continue;
                }
                numSequencesForCell.put(cell, (Integer)numSequencesForCell.get(cell) + 1);
            }
        }
        return new Metric(this, "# sequences each predicted => active cells appears in", new ArrayList(numSequencesForCell.values()));
    }

    default public String mmPrettyPrintConnections() {
        StringBuilder text = new StringBuilder();
        text.append("Segments: (format => (#) [(source cell=permanence ...),       ...]\n").append("------------------------------------\n");
        Connections cnx = this.getConnections();
        List<Integer> columns = Arrays.asList(ArrayUtils.toBoxed(ArrayUtils.range(0, cnx.getNumColumns())));
        for (Integer column : columns) {
            int[] cells;
            for (int cell : cells = cnx.getColumn(column).getCells().stream().map(c -> c.getIndex()).mapToInt(i -> i).toArray()) {
                HashMap<Integer, String> segmentDict = new HashMap<Integer, String>();
                for (DistalDendrite dd : cnx.getSegments(cnx.getCell(cell))) {
                    ArrayList<Tuple> synapseList = new ArrayList<Tuple>();
                    for (Synapse s : cnx.getSynapses(dd)) {
                        Tuple synapseData = new Tuple(s.getInputIndex(), s.getPermanence());
                        synapseList.add(synapseData);
                    }
                    Stream tupes = synapseList.stream().sorted((t1, t2) -> ((Integer)t1.get(0)).compareTo((Integer)t2.get(0)));
                    List synapseStringList = tupes.map(t -> String.format("%3d=%.2f", t.get(0), t.get(1))).collect(Collectors.toList());
                    segmentDict.put(dd.getIndex(), String.format("(%s)", synapseStringList.stream().collect(Collectors.joining(" "))));
                }
                text.append(String.format("Column %3d / Cell %3d:\t(%d) %s\n", column, cell, segmentDict.values().size(), String.format("[%s]", segmentDict.values().stream().collect(Collectors.joining(",       ")))));
            }
            if (column >= columns.size() - 1) continue;
            text.append("\n");
        }
        text.append("------------------------------------\n");
        return text.toString();
    }

    default public String mmPrettyPrintSequenceCellRepresentations(String sortBy) {
        this.mmComputeTransitionTraces();
        String[] header = new String[]{"Pattern", "Column", "predicted=>active cells"};
        int sortIndex = -1;
        int idx = -1;
        for (String colHeader : header) {
            ++idx;
            if (!colHeader.equals(sortBy)) continue;
            sortIndex = idx;
            break;
        }
        if (sortIndex == -1) {
            throw new IllegalArgumentException("No header named \"" + sortBy + "\" to sort by.");
        }
        String[][] data = new String[this.getDataMap().get("predictedActiveCellsForSequence").values().size()][];
        int i = 0;
        for (Map.Entry<String, ?> m : this.getDataMap().get("predictedActiveCellsForSequence").entrySet()) {
            Map<Integer, List<Integer>> cellsForColumn = ((Set)m.getValue()).stream().collect(Collectors.groupingBy(cell -> this.getConnections().getCell((int)cell).getColumn().getIndex()));
            for (Integer column : cellsForColumn.keySet()) {
                data[i] = new String[]{m.getKey(), column.toString(), cellsForColumn.get(column).toString().replace("[", "").replace("]", "")};
                ++i;
            }
        }
        int finalIndex = sortIndex;
        Arrays.stream(data).sorted((sa1, sa2) -> sa1[finalIndex].compareTo(sa2[finalIndex]));
        String retVal = AsciiTableInstance.get().getTable(header, data, 0);
        return retVal;
    }

    default public void mmComputeTransitionTraces() {
        if (!this.transitionTracesStale()) {
            return;
        }
        Map<String, ?> predActCells = null;
        predActCells = this.getDataMap().get("predictedActiveCellsForSequence");
        if (predActCells == null) {
            predActCells = new HashMap();
            this.getDataMap().put("predictedActiveCellsForSequence", predActCells);
        }
        this.getTraceMap().put("predictedActiveCells", new IndicesTrace(this, "predicted => active cells (correct)"));
        this.getTraceMap().put("predictedInactiveCells", new IndicesTrace(this, "predicted => inactive cells (extra)"));
        this.getTraceMap().put("predictedActiveColumns", new IndicesTrace(this, "predicted => active columns (correct)"));
        this.getTraceMap().put("predictedInactiveColumns", new IndicesTrace(this, "predicted => inactive columns (extra)"));
        this.getTraceMap().put("unpredictedActiveColumns", new IndicesTrace(this, "unpredicted => active columns (bursting)"));
        IndicesTrace predictedCellsTrace = (IndicesTrace)this.getTraceMap().get("predictedCells");
        int i = 0;
        LinkedHashSet<Integer> predictedActiveColumns = null;
        for (Set activeColumns : this.mmGetTraceActiveColumns().items) {
            LinkedHashSet<Integer> predictedActiveCells = new LinkedHashSet<Integer>();
            LinkedHashSet<Integer> predictedInactiveCells = new LinkedHashSet<Integer>();
            predictedActiveColumns = new LinkedHashSet<Integer>();
            LinkedHashSet<Integer> predictedInactiveColumns = new LinkedHashSet<Integer>();
            for (Integer predictedCell : (LinkedHashSet)predictedCellsTrace.items.get(i)) {
                Integer predictedColumn = this.getConnections().getCell(predictedCell).getColumn().getIndex();
                if (activeColumns.contains(predictedColumn)) {
                    predictedActiveCells.add(predictedCell);
                    predictedActiveColumns.add(predictedColumn);
                    String sequenceLabel = (String)this.mmGetTraceSequenceLabels().items.get(i);
                    if (sequenceLabel == null || sequenceLabel.isEmpty()) continue;
                    LinkedHashSet<Integer> sequencePredictedCells = null;
                    sequencePredictedCells = (LinkedHashSet<Integer>)predActCells.get(sequenceLabel);
                    if (sequencePredictedCells == null) {
                        sequencePredictedCells = new LinkedHashSet<Integer>();
                        predActCells.put(sequenceLabel, sequencePredictedCells);
                    }
                    sequencePredictedCells.add(predictedCell);
                    continue;
                }
                predictedInactiveCells.add(predictedCell);
                predictedInactiveColumns.add(predictedColumn);
            }
            LinkedHashSet unpredictedActiveColumns = new LinkedHashSet(activeColumns);
            unpredictedActiveColumns.removeAll(predictedActiveColumns);
            ((IndicesTrace)this.getTraceMap().get((Object)"predictedActiveCells")).items.add(predictedActiveCells);
            ((IndicesTrace)this.getTraceMap().get((Object)"predictedInactiveCells")).items.add(predictedInactiveCells);
            ((IndicesTrace)this.getTraceMap().get((Object)"predictedActiveColumns")).items.add(predictedActiveColumns);
            ((IndicesTrace)this.getTraceMap().get((Object)"predictedInactiveColumns")).items.add(predictedInactiveColumns);
            ((IndicesTrace)this.getTraceMap().get((Object)"unpredictedActiveColumns")).items.add(unpredictedActiveColumns);
            ++i;
        }
        this.setTransitionTracesStale(false);
    }

    default public ComputeCycle compute(Connections cnx, int[] activeColumns, String sequenceLabel, boolean learn) {
        ((IndicesTrace)this.getTraceMap().get((Object)"predictedCells")).items.add(new LinkedHashSet<Integer>(Connections.asCellIndexes(cnx.getPredictiveCells())));
        ComputeCycle cycle = this.getMonitor().compute(cnx, activeColumns, learn);
        ((IndicesTrace)this.getTraceMap().get((Object)"predictiveCells")).items.add(new LinkedHashSet<Integer>(Connections.asCellIndexes(cnx.getPredictiveCells())));
        ((IndicesTrace)this.getTraceMap().get((Object)"activeCells")).items.add(new LinkedHashSet<Integer>(Connections.asCellIndexes(cnx.getActiveCells())));
        ((IndicesTrace)this.getTraceMap().get((Object)"activeColumns")).items.add(Arrays.stream(activeColumns).boxed().collect(Collectors.toCollection(LinkedHashSet::new)));
        ((CountsTrace)this.getTraceMap().get((Object)"numSegments")).items.add(cnx.getSegmentCount());
        ((CountsTrace)this.getTraceMap().get((Object)"numSynapses")).items.add(cnx.getSynapseCount());
        ((StringsTrace)this.getTraceMap().get((Object)"sequenceLabels")).items.add(sequenceLabel);
        ((BoolsTrace)this.getTraceMap().get((Object)"resets")).items.add(this.resetActive());
        this.setResetActive(false);
        this.setTransitionTracesStale(true);
        return cycle;
    }

    default public void resetSequences(Connections c) {
        this.getMonitor().reset(c);
        this.setResetActive(true);
    }

    @Override
    default public <T extends Trace<?>> List<T> mmGetDefaultTraces(int verbosity) {
        ArrayList<Trace> traces = new ArrayList<Trace>();
        traces.add(this.mmGetTraceActiveColumns());
        traces.add(this.mmGetTracePredictedActiveColumns());
        traces.add(this.mmGetTracePredictedInactiveColumns());
        traces.add(this.mmGetTraceUnpredictedActiveColumns());
        traces.add(this.mmGetTracePredictedActiveCells());
        traces.add(this.mmGetTracePredictedInactiveCells());
        ArrayList<CountsTrace> tracesToAdd = new ArrayList<CountsTrace>();
        if (verbosity == 1) {
            for (Trace t : traces) {
                tracesToAdd.add(((IndicesTrace)t).makeCountsTrace());
            }
            traces.clear();
            traces.addAll(tracesToAdd);
        }
        traces.add(this.mmGetTraceNumSegments());
        traces.add(this.mmGetTraceNumSynapses());
        traces.add(this.mmGetTraceSequenceLabels());
        return traces;
    }

    @Override
    default public List<Metric> mmGetDefaultMetrics(int verbosity) {
        int i;
        BoolsTrace resetsTrace = this.mmGetTraceResets();
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        List utilTraces = this.mmGetDefaultTraces(verbosity);
        for (i = 0; i < utilTraces.size() - 3; ++i) {
            metrics.add(Metric.createFromTrace((Trace)utilTraces.get(i), resetsTrace));
        }
        for (i = utilTraces.size() - 3; i < utilTraces.size() - 1; ++i) {
            metrics.add(Metric.createFromTrace((Trace)utilTraces.get(i), null));
        }
        metrics.add(this.mmGetMetricSequencesPredictedActiveCellsPerColumn());
        metrics.add(this.mmGetMetricSequencesPredictedActiveCellsShared());
        return metrics;
    }

    @Override
    default public void mmClearHistory() {
        this.getTraceMap().clear();
        this.getDataMap().clear();
        this.getTraceMap().put("predictedCells", new IndicesTrace(this, "predicted cells"));
        this.getTraceMap().put("activeColumns", new IndicesTrace(this, "active columns"));
        this.getTraceMap().put("activeCells", new IndicesTrace(this, "active cells"));
        this.getTraceMap().put("predictiveCells", new IndicesTrace(this, "predictive cells"));
        this.getTraceMap().put("numSegments", new CountsTrace(this, "# segments"));
        this.getTraceMap().put("numSynapses", new CountsTrace(this, "# synapses"));
        this.getTraceMap().put("sequenceLabels", new StringsTrace(this, "sequence labels"));
        this.getTraceMap().put("resets", new BoolsTrace(this, "resets"));
        this.setTransitionTracesStale(true);
    }
}

