/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.numenta.nupic.ComputeCycle;
import org.numenta.nupic.algorithms.Classification;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.util.ArrayUtils;
import org.numenta.nupic.util.NamedTuple;

public class ManualInput
implements Inference {
    private static final long serialVersionUID = 1L;
    private int recordNum;
    private Map<String, NamedTuple> classifierInput;
    NamedTuple classifiers;
    private Object layerInput;
    private int[] sdr;
    private int[] encoding;
    private int[] feedForwardActiveColumns;
    private int[] feedForwardSparseActives;
    private Set<Cell> previousPredictiveCells;
    private Set<Cell> predictiveCells;
    private Set<Cell> activeCells;
    private Map<String, Classification<Object>> classification;
    private double anomalyScore;
    private Object customObject;
    ComputeCycle computeCycle;

    @Override
    public <T> T postDeSerialize(T manualInput) {
        ManualInput mi = (ManualInput)manualInput;
        ManualInput retVal = new ManualInput();
        retVal.activeCells = mi.activeCells;
        retVal.anomalyScore = mi.anomalyScore;
        retVal.classification = mi.classification;
        retVal.classifierInput = mi.classifierInput;
        retVal.classifiers = mi.classifiers;
        retVal.customObject = mi.customObject;
        retVal.encoding = mi.encoding;
        retVal.feedForwardActiveColumns = mi.feedForwardActiveColumns;
        retVal.feedForwardSparseActives = mi.feedForwardSparseActives;
        retVal.layerInput = mi.layerInput;
        retVal.predictiveCells = mi.predictiveCells;
        retVal.previousPredictiveCells = mi.previousPredictiveCells;
        retVal.sdr = mi.sdr;
        return (T)retVal;
    }

    public ManualInput recordNum(int num) {
        this.recordNum = num;
        return this;
    }

    @Override
    public int getRecordNum() {
        return this.recordNum;
    }

    public ManualInput computeCycle(ComputeCycle computeCycle) {
        this.computeCycle = computeCycle;
        return this;
    }

    @Override
    public ComputeCycle getComputeCycle() {
        return this.computeCycle;
    }

    @Override
    public Object getCustomObject() {
        return this.customObject;
    }

    public ManualInput customObject(Object o) {
        this.customObject = o;
        return this;
    }

    @Override
    public Map<String, NamedTuple> getClassifierInput() {
        if (this.classifierInput == null) {
            this.classifierInput = new HashMap<String, NamedTuple>();
        }
        return this.classifierInput;
    }

    ManualInput classifierInput(Map<String, NamedTuple> classifierInput) {
        this.classifierInput = classifierInput;
        return this;
    }

    public ManualInput classifiers(NamedTuple tuple) {
        this.classifiers = tuple;
        return this;
    }

    @Override
    public NamedTuple getClassifiers() {
        return this.classifiers;
    }

    @Override
    public Object getLayerInput() {
        return this.layerInput;
    }

    ManualInput layerInput(Object inputValue) {
        this.layerInput = inputValue;
        return this;
    }

    @Override
    public int[] getSDR() {
        return this.sdr;
    }

    ManualInput sdr(int[] sdr) {
        this.sdr = sdr;
        return this;
    }

    @Override
    public int[] getEncoding() {
        return this.encoding;
    }

    ManualInput encoding(int[] sdr) {
        this.encoding = sdr;
        return this;
    }

    ManualInput copy() {
        ManualInput retVal = new ManualInput();
        retVal.classifierInput = new HashMap<String, NamedTuple>(this.classifierInput);
        retVal.classifiers = new NamedTuple(this.classifiers.keys(), this.classifiers.values().toArray());
        retVal.layerInput = this.layerInput;
        retVal.sdr = Arrays.copyOf(this.sdr, this.sdr.length);
        retVal.encoding = Arrays.copyOf(this.encoding, this.encoding.length);
        retVal.feedForwardActiveColumns = Arrays.copyOf(this.feedForwardActiveColumns, this.feedForwardActiveColumns.length);
        retVal.feedForwardSparseActives = Arrays.copyOf(this.feedForwardSparseActives, this.feedForwardSparseActives.length);
        retVal.previousPredictiveCells = new LinkedHashSet<Cell>(this.previousPredictiveCells);
        retVal.predictiveCells = new LinkedHashSet<Cell>(this.predictiveCells);
        retVal.classification = new HashMap<String, Classification<Object>>(this.classification);
        retVal.anomalyScore = this.anomalyScore;
        retVal.customObject = this.customObject;
        retVal.computeCycle = this.computeCycle;
        retVal.activeCells = new LinkedHashSet<Cell>(this.activeCells);
        return retVal;
    }

    @Override
    public Classification<Object> getClassification(String fieldName) {
        return this.classification.get(fieldName);
    }

    ManualInput storeClassification(String fieldName, Classification<Object> classification) {
        if (this.classification == null) {
            this.classification = new HashMap<String, Classification<Object>>();
        }
        this.classification.put(fieldName, classification);
        return this;
    }

    @Override
    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    ManualInput anomalyScore(double d) {
        this.anomalyScore = d;
        return this;
    }

    @Override
    public int[] getFeedForwardActiveColumns() {
        return this.feedForwardActiveColumns;
    }

    public ManualInput feedForwardActiveColumns(int[] cols) {
        this.feedForwardActiveColumns = cols;
        return this;
    }

    @Override
    public Set<Cell> getActiveCells() {
        return this.activeCells;
    }

    public ManualInput activeCells(Set<Cell> cells) {
        this.activeCells = cells;
        return this;
    }

    @Override
    public int[] getFeedForwardSparseActives() {
        if (this.feedForwardSparseActives == null && this.feedForwardActiveColumns != null) {
            this.feedForwardSparseActives = ArrayUtils.where(this.feedForwardActiveColumns, ArrayUtils.WHERE_1);
        }
        return this.feedForwardSparseActives;
    }

    public ManualInput feedForwardSparseActives(int[] cols) {
        this.feedForwardSparseActives = cols;
        return this;
    }

    @Override
    public Set<Cell> getPreviousPredictiveCells() {
        return this.previousPredictiveCells;
    }

    public ManualInput previousPredictiveCells(Set<Cell> cells) {
        this.previousPredictiveCells = cells;
        return this;
    }

    @Override
    public Set<Cell> getPredictiveCells() {
        return this.predictiveCells;
    }

    public ManualInput predictiveCells(Set<Cell> cells) {
        this.previousPredictiveCells = this.predictiveCells;
        this.predictiveCells = cells;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activeCells == null ? 0 : this.activeCells.hashCode());
        long temp = Double.doubleToLongBits(this.anomalyScore);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.classification == null ? 0 : this.classification.hashCode());
        result = 31 * result + (this.classifierInput == null ? 0 : this.classifierInput.hashCode());
        result = 31 * result + (this.computeCycle == null ? 0 : this.computeCycle.hashCode());
        result = 31 * result + Arrays.hashCode(this.encoding);
        result = 31 * result + Arrays.hashCode(this.feedForwardActiveColumns);
        result = 31 * result + Arrays.hashCode(this.feedForwardSparseActives);
        result = 31 * result + (this.predictiveCells == null ? 0 : this.predictiveCells.hashCode());
        result = 31 * result + (this.previousPredictiveCells == null ? 0 : this.previousPredictiveCells.hashCode());
        result = 31 * result + this.recordNum;
        result = 31 * result + Arrays.hashCode(this.sdr);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Inference.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ManualInput other = (ManualInput)obj;
        if (this.activeCells == null ? other.activeCells != null : !this.activeCells.equals(other.activeCells)) {
            return false;
        }
        if (Double.doubleToLongBits(this.anomalyScore) != Double.doubleToLongBits(other.anomalyScore)) {
            return false;
        }
        if (this.classification == null ? other.classification != null : !this.classification.equals(other.classification)) {
            return false;
        }
        if (this.classifierInput == null ? other.classifierInput != null : !this.classifierInput.equals(other.classifierInput)) {
            return false;
        }
        if (this.computeCycle == null ? other.computeCycle != null : !this.computeCycle.equals(other.computeCycle)) {
            return false;
        }
        if (!Arrays.equals(this.encoding, other.encoding)) {
            return false;
        }
        if (!Arrays.equals(this.feedForwardActiveColumns, other.feedForwardActiveColumns)) {
            return false;
        }
        if (!Arrays.equals(this.feedForwardSparseActives, other.feedForwardSparseActives)) {
            return false;
        }
        if (this.predictiveCells == null ? other.predictiveCells != null : !this.predictiveCells.equals(other.predictiveCells)) {
            return false;
        }
        if (this.previousPredictiveCells == null ? other.previousPredictiveCells != null : !this.previousPredictiveCells.equals(other.previousPredictiveCells)) {
            return false;
        }
        if (this.recordNum != other.recordNum) {
            return false;
        }
        return Arrays.equals(this.sdr, other.sdr);
    }
}

