/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import org.numenta.nupic.ComputeCycle;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.algorithms.Anomaly;
import org.numenta.nupic.algorithms.PASpatialPooler;
import org.numenta.nupic.algorithms.SpatialPooler;
import org.numenta.nupic.algorithms.TemporalMemory;
import org.numenta.nupic.encoders.MultiEncoder;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.network.Layer;
import org.numenta.nupic.network.ManualInput;
import org.numenta.nupic.network.Network;

public class PALayer<T>
extends Layer<T> {
    private static final long serialVersionUID = 1L;
    double paDepolarize = 1.0;
    int verbosity = 0;

    public PALayer(Network n) {
        super(n);
    }

    public PALayer(Network n, Parameters p) {
        super(n, p);
    }

    public PALayer(String name, Network n, Parameters p) {
        super(name, n, p);
    }

    public PALayer(Parameters params, MultiEncoder e, SpatialPooler sp, TemporalMemory tm, Boolean autoCreateClassifiers, Anomaly a) {
        super(params, e, sp, tm, autoCreateClassifiers, a);
    }

    public double getPADepolarize() {
        return this.paDepolarize;
    }

    public void setPADepolarize(double pa) {
        this.paDepolarize = pa;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public Network getParentNetwork() {
        return this.parentNetwork;
    }

    @Override
    protected int[] spatialInput(int[] input) {
        if (input == null) {
            LOGGER.info("Layer ".concat(this.getName()).concat(" received null input"));
        } else {
            if (input.length < 1) {
                LOGGER.info("Layer ".concat(this.getName()).concat(" received zero length bit vector"));
                return input;
            }
            if (input.length > this.connections.getNumInputs()) {
                if (this.verbosity > 0) {
                    System.out.println(input);
                }
                throw new IllegalArgumentException(String.format("Input size %d > SP's NumInputs %d", input.length, this.connections.getNumInputs()));
            }
        }
        this.spatialPooler.compute(this.connections, input, this.feedForwardActiveColumns, this.sensor == null || this.sensor.getMetaInfo().isLearn(), this.isLearn);
        return this.feedForwardActiveColumns;
    }

    @Override
    protected int[] temporalInput(int[] input, ManualInput mi) {
        int[] sdr = super.temporalInput(input, mi);
        ComputeCycle cc = mi.computeCycle;
        if (this.spatialPooler != null && this.spatialPooler instanceof PASpatialPooler) {
            int boosted = 0;
            double[] polarization = new double[this.connections.getNumColumns()];
            for (Cell cell : cc.predictiveCells) {
                Column column = cell.getColumn();
                if (polarization[column.getIndex()] == 0.0) {
                    ++boosted;
                }
                int n = column.getIndex();
                polarization[n] = polarization[n] + this.paDepolarize;
                if (this.verbosity < 2) continue;
                System.out.println(String.format("[%d] = %d", column.getIndex(), (int)this.paDepolarize));
            }
            if (this.verbosity >= 1) {
                System.out.println(String.format("boosted %d/%d columns", boosted, this.connections.getNumColumns()));
            }
            this.connections.setPAOverlaps(polarization);
        }
        return sdr;
    }
}

