/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.network.CheckPointOp;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.network.PersistenceAPI;
import org.numenta.nupic.serialize.SerialConfig;
import org.numenta.nupic.serialize.SerializerCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persistence {
    private static PersistenceAPI access;

    public static PersistenceAPI get() {
        return Persistence.get(new SerialConfig());
    }

    public static PersistenceAPI get(SerialConfig config) {
        if (access == null) {
            access = new PersistenceAccess(config);
        }
        return access;
    }

    static class PersistenceAccess
    implements PersistenceAPI {
        private static final long serialVersionUID = 1L;
        protected static final Logger LOGGER = LoggerFactory.getLogger(PersistenceAPI.class);
        public static DateTimeFormatter CHECKPOINT_TIMESTAMP_FORMAT = DateTimeFormat.forPattern((String)"YYYY-MM-dd_HH-mm-ss.SSS");
        private DateTimeFormatter checkPointFormatter = CHECKPOINT_TIMESTAMP_FORMAT;
        private SerialConfig serialConfig;
        private static AtomicReference<byte[]> lastBytes = new AtomicReference<Object>(null);
        private static AtomicReference<String> lastCheckPointFileName = new AtomicReference<Object>(null);
        private SerializerCore defaultSerializer = new SerializerCore(new Class[0]);
        private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        private Lock writeMonitor = this.rwl.writeLock();
        private Lock readMonitor = this.rwl.readLock();

        public PersistenceAccess(SerialConfig config) {
            this.serialConfig = config == null ? new SerialConfig() : config;
            this.checkPointFormatter = DateTimeFormat.forPattern((String)config.getCheckPointFormatString());
        }

        @Override
        public void setConfig(SerialConfig config) {
            this.serialConfig = config;
            this.checkPointFormatter = DateTimeFormat.forPattern((String)config.getCheckPointFormatString());
        }

        @Override
        public SerialConfig getConfig() {
            return this.serialConfig;
        }

        @Override
        public SerializerCore serializer() {
            if (this.defaultSerializer == null) {
                this.defaultSerializer = new SerializerCore(SerialConfig.DEFAULT_REGISTERED_TYPES);
            }
            return this.defaultSerializer;
        }

        @Override
        public <R extends Persistable> R read() {
            LOGGER.debug("PersistenceAccess reify() [serial config file name=" + this.serialConfig.getFileName() + "] called ...");
            return this.read(this.serialConfig.getFileName());
        }

        @Override
        public <R extends Persistable> R read(String fileName) {
            byte[] bytes;
            LOGGER.debug("PersistenceAccess reify(" + fileName + ") called ...");
            try {
                bytes = this.readFile(fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return this.read(bytes);
        }

        @Override
        public <R extends Persistable> R read(byte[] serializedBytes) {
            LOGGER.debug("PersistenceAccess reify(byte[]) called ...");
            Object r = this.serializer().deSerialize(serializedBytes);
            return (R)((Persistable)r.postDeSerialize());
        }

        @Override
        public <T extends Persistable, R> R write(T instance) {
            LOGGER.debug("PersistenceAccess persist(T) called ...");
            instance.preSerialize();
            byte[] bytes = this.serializer().serialize(instance);
            try {
                this.writeFile(this.serialConfig, bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return (R)bytes;
        }

        @Override
        public <T extends Persistable, R> R write(T instance, String fileName) {
            LOGGER.debug("PersistenceAccess persist(T, " + fileName + ") called ...");
            instance.preSerialize();
            byte[] bytes = this.serializer().serialize(instance);
            try {
                this.writeFile(fileName, bytes, this.serialConfig.getOpenOptions());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return (R)bytes;
        }

        @Override
        public Network load() {
            byte[] bytes;
            LOGGER.debug("PersistenceAccess load() called ...");
            String defaultFileName = this.serialConfig.getFileName();
            try {
                bytes = this.readFile(defaultFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            Network network = (Network)this.serializer().deSerialize(bytes);
            return network.postDeSerialize();
        }

        @Override
        public Network load(String fileName) throws IOException {
            LOGGER.debug("PersistenceAccess load(" + fileName + ") called ...");
            byte[] bytes = this.readFile(fileName);
            Network network = (Network)this.serializer().deSerialize(bytes);
            return network;
        }

        @Override
        public void store(Network network) {
            this.storeAndGet(network);
        }

        @Override
        public <R> R storeAndGet(Network network) {
            network.preSerialize();
            byte[] bytes = this.defaultSerializer.serialize(network);
            try {
                this.writeFile(this.serialConfig, bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return (R)bytes;
        }

        @Override
        public CheckPointOp<byte[]> checkPointer(Network network) {
            network.setCheckPointFunction(this.getCheckPointFunction(network));
            return network.getCheckPointOperator();
        }

        <T extends Persistable, R> Function<T, R> getCheckPointFunction(Network network) {
            return t -> {
                t.preSerialize();
                String oldCheckPointFileName = lastCheckPointFileName.getAndSet(this.serialConfig.getAbsoluteSerialDir() + File.separator + this.serialConfig.getCheckPointFileName() + this.checkPointFormatter.print((ReadableInstant)new DateTime()));
                byte[] bytes = this.defaultSerializer.serialize(network);
                try {
                    this.writeFile(lastCheckPointFileName.get(), bytes, this.serialConfig.getCheckPointOpenOptions());
                }
                catch (IOException io) {
                    throw new RuntimeException(io);
                }
                if (this.serialConfig.isOneCheckPointOnly() && oldCheckPointFileName != null) {
                    try {
                        Files.deleteIfExists(new File(oldCheckPointFileName).toPath());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return bytes;
            };
        }

        @Override
        public byte[] getLastCheckPoint() {
            return lastBytes.get();
        }

        @Override
        public String getLastCheckPointFileName() {
            return lastCheckPointFileName.get();
        }

        @Override
        public List<String> listCheckPointFiles() {
            List<String> chkPntFiles = null;
            try {
                this.readMonitor.lock();
                String path = System.getProperty("user.home") + File.separator + this.serialConfig.getFileDir();
                File customDir = new File(path);
                DateTimeFormatter f = this.checkPointFormatter;
                chkPntFiles = Arrays.stream(customDir.list((d, n) -> n.indexOf(this.serialConfig.getCheckPointFileName()) != -1)).sorted((o1, o2) -> {
                    try {
                        String n1 = o1.substring(this.serialConfig.getCheckPointFileName().length());
                        String n2 = o2.substring(this.serialConfig.getCheckPointFileName().length());
                        return f.parseDateTime(n1).compareTo((ReadableInstant)f.parseDateTime(n2));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.readMonitor.unlock();
            }
            return chkPntFiles;
        }

        @Override
        public String getPreviousCheckPoint(String checkPointFileName) {
            DateTimeFormatter f = this.checkPointFormatter;
            String defaultNamePortion = this.serialConfig.getCheckPointFileName();
            if (checkPointFileName.indexOf(defaultNamePortion) != -1) {
                checkPointFileName = checkPointFileName.substring(defaultNamePortion.length());
            }
            String cpfn = checkPointFileName;
            String[] chkPntFiles = (String[])this.listCheckPointFiles().stream().map(n -> n.substring(defaultNamePortion.length())).filter(n -> f.parseDateTime(n).isBefore((ReadableInstant)f.parseDateTime(cpfn))).toArray(String[]::new);
            if (chkPntFiles != null && chkPntFiles.length > 0) {
                return defaultNamePortion.concat(chkPntFiles[chkPntFiles.length - 1]);
            }
            return null;
        }

        @Override
        public String currentPath() {
            return System.getProperty("user.home") + File.separator + this.serialConfig.getFileDir() + File.separator + this.serialConfig.getFileName();
        }

        File ensurePathExists(SerialConfig config) throws IOException {
            return this.ensurePathExists(config, config.getFileName());
        }

        File ensurePathExists(SerialConfig config, String fileName) throws IOException {
            File serializedFile = null;
            try {
                this.writeMonitor.lock();
                String path = System.getProperty("user.home") + File.separator + this.serialConfig.getFileDir();
                File customDir = new File(path);
                customDir.mkdirs();
                serializedFile = new File(fileName.indexOf(customDir.getAbsolutePath()) != -1 ? fileName : customDir.getAbsolutePath() + File.separator + fileName);
                if (!serializedFile.exists()) {
                    serializedFile.createNewFile();
                }
            }
            catch (Exception io) {
                throw io;
            }
            finally {
                this.writeMonitor.unlock();
            }
            return serializedFile;
        }

        File testFileExists(String fileName) throws IOException, FileNotFoundException {
            try {
                this.readMonitor.lock();
                String path = System.getProperty("user.home") + File.separator + this.serialConfig.getFileDir();
                File customDir = new File(path);
                customDir.mkdirs();
                File serializedFile = new File(fileName.indexOf(customDir.getAbsolutePath()) != -1 ? fileName : customDir.getAbsolutePath() + File.separator + fileName);
                if (!serializedFile.exists()) {
                    throw new FileNotFoundException("File \"" + fileName + "\" was not found.");
                }
                File file = serializedFile;
                return file;
            }
            catch (IOException io) {
                throw io;
            }
            finally {
                this.readMonitor.unlock();
            }
        }

        void writeFile(SerialConfig config, byte[] bytes) throws IOException {
            this.writeFile(config.getFileName(), bytes, config.getOpenOptions());
        }

        void writeFile(String fileName, byte[] bytes, StandardOpenOption ... options) throws IOException {
            try {
                Path path = this.ensurePathExists(this.serialConfig, fileName).toPath();
                Files.write(path, bytes, (OpenOption[])options);
            }
            catch (Exception e) {
                lastBytes.set(null);
                throw e;
            }
            lastBytes.set(bytes);
        }

        byte[] readFile(String filePath) throws IOException {
            Path path = this.testFileExists(filePath).toPath();
            return this.readFile(path);
        }

        byte[] readFile(Path path) throws IOException {
            byte[] bytes = null;
            bytes = Files.readAllBytes(path);
            return bytes;
        }
    }
}

