/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.network.Network;
import org.numenta.nupic.network.sensor.Publisher;
import rx.subjects.PublishSubject;

public class PublisherSupplier
implements Persistable,
Supplier<Publisher> {
    private static final long serialVersionUID = 1L;
    private Network network;
    private List<String> headers = new ArrayList<String>();
    private volatile transient Publisher suppliedInstance;

    private PublisherSupplier(Network network) {
        this.network = network;
    }

    @Override
    public Publisher get() {
        if (this.suppliedInstance == null) {
            Publisher.Builder<PublishSubject<String>> builder = Publisher.builder(this.network == null ? null : p -> this.network.setPublisher((Publisher)p));
            this.headers.stream().forEach(line -> builder.addHeader((String)line));
            this.suppliedInstance = builder.build();
            this.suppliedInstance.setNetwork(this.network);
        }
        return this.suppliedInstance;
    }

    public void clearSuppliedInstance() {
        this.suppliedInstance = null;
    }

    public void setNetwork(Network n) {
        this.network = n;
        this.suppliedInstance.setNetwork(n);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Network network;
        private List<String> headers = new ArrayList<String>();

        private Builder() {
        }

        public Builder addHeader(String headerLine) {
            this.headers.add(headerLine);
            return this;
        }

        public PublisherSupplier build() {
            PublisherSupplier retVal = new PublisherSupplier(this.network);
            retVal.headers = new ArrayList<String>(this.headers);
            return retVal;
        }
    }
}

