/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.network.sensor.SensorFlags;
import org.numenta.nupic.network.sensor.ValueList;
import org.numenta.nupic.util.Tuple;

public class Header
implements ValueList,
Serializable {
    private static final long serialVersionUID = 1L;
    private ValueList rawTupleList;
    private List<String> fieldNames;
    private List<FieldMetaType> fieldMeta;
    private List<SensorFlags> sensorFlags;
    private boolean isChanged;
    private boolean isLearn = true;
    private int[] resetIndexes;
    private int[] seqIndexes;
    private int[] tsIndexes;
    private int[] learnIndexes;
    private int[] categoryIndexes;
    private List<String> sequenceCache;

    public Header(ValueList input) {
        if (input.size() != 3) {
            throw new IllegalArgumentException("Input did not have 3 rows");
        }
        this.rawTupleList = input;
        this.fieldNames = input.getRow(0).all().stream().map(o -> o.toString()).collect(Collectors.toList());
        this.fieldMeta = input.getRow(1).all().stream().map(FieldMetaType::fromString).collect(Collectors.toList());
        this.sensorFlags = input.getRow(2).all().stream().map(SensorFlags::fromString).collect(Collectors.toList());
        this.initIndexes();
    }

    @Override
    public Tuple getRow(int index) {
        return this.rawTupleList.getRow(index);
    }

    @Override
    public int size() {
        return this.rawTupleList.size();
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<FieldMetaType> getFieldTypes() {
        return this.fieldMeta;
    }

    public List<SensorFlags> getFlags() {
        return this.sensorFlags;
    }

    public boolean isReset() {
        return this.isChanged;
    }

    public boolean isLearn() {
        return this.isLearn;
    }

    void process(String[] input) {
        this.isChanged = false;
        if (this.resetIndexes.length > 0) {
            for (int i : this.resetIndexes) {
                if (Integer.parseInt(input[i].trim()) == 1) {
                    this.isChanged = true;
                    break;
                }
                this.isChanged = false;
            }
        }
        if (this.learnIndexes.length > 0) {
            for (int i : this.learnIndexes) {
                if (Integer.parseInt(input[i].trim()) == 1) {
                    this.isLearn = true;
                    break;
                }
                this.isLearn = false;
            }
        }
        if (this.seqIndexes.length > 0) {
            boolean sequenceChanged = false;
            if (this.sequenceCache.isEmpty()) {
                for (int i : this.seqIndexes) {
                    this.sequenceCache.add(input[i]);
                }
            } else {
                int idx = 0;
                for (int i : this.seqIndexes) {
                    if (this.sequenceCache.get(idx).equals(input[i])) continue;
                    this.sequenceCache.set(idx, input[i]);
                    sequenceChanged = true;
                }
            }
            this.isChanged |= sequenceChanged;
        }
    }

    private void initIndexes() {
        int idx = 0;
        ArrayList<Integer> tList = new ArrayList<Integer>();
        ArrayList<Integer> rList = new ArrayList<Integer>();
        ArrayList<Integer> cList = new ArrayList<Integer>();
        ArrayList<Integer> sList = new ArrayList<Integer>();
        ArrayList<Integer> lList = new ArrayList<Integer>();
        for (SensorFlags sf : this.sensorFlags) {
            switch (sf) {
                case T: {
                    tList.add(idx);
                    break;
                }
                case R: {
                    rList.add(idx);
                    break;
                }
                case C: {
                    cList.add(idx);
                    break;
                }
                case S: {
                    sList.add(idx);
                    break;
                }
                case L: {
                    lList.add(idx);
                    break;
                }
            }
            ++idx;
        }
        this.resetIndexes = rList.stream().mapToInt(i -> i + 1).toArray();
        this.seqIndexes = sList.stream().mapToInt(i -> i + 1).toArray();
        this.categoryIndexes = cList.stream().mapToInt(i -> i + 1).toArray();
        this.tsIndexes = tList.stream().mapToInt(i -> i + 1).toArray();
        this.learnIndexes = lList.stream().mapToInt(i -> i + 1).toArray();
        if (this.seqIndexes.length > 0) {
            this.sequenceCache = new ArrayList<String>();
        }
    }
}

