/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.network.sensor;

import java.util.function.Consumer;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.network.Network;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;

public class Publisher
implements Persistable {
    private static final long serialVersionUID = 1L;
    private static final int HEADER_SIZE = 3;
    private transient ReplaySubject<String> subject;
    private Network parentNetwork;

    public static Builder<PublishSubject<String>> builder() {
        return new Builder<PublishSubject<String>>();
    }

    public static Builder<PublishSubject<String>> builder(Consumer<Publisher> c) {
        return new Builder<PublishSubject<String>>(c);
    }

    public void setNetwork(Network n) {
        this.parentNetwork = n;
    }

    public Network getNetwork() {
        return this.parentNetwork;
    }

    public void onNext(String input) {
        this.subject.onNext((Object)input);
    }

    public void onComplete() {
        this.subject.onCompleted();
    }

    public void onError(Throwable e) {
        this.subject.onError(e);
    }

    public Subscription subscribe(Observer<String> observer) {
        return this.subject.subscribe(observer);
    }

    public Observable<String> observable() {
        return this.subject;
    }

    public static class Builder<T> {
        private ReplaySubject<String> subject;
        private Consumer<Publisher> notifier;
        String[] lines = new String[3];
        int cursor = 0;

        public Builder() {
            this(null);
        }

        public Builder(Consumer<Publisher> c) {
            this.notifier = c;
        }

        public Builder<PublishSubject<String>> addHeader(String s) {
            this.lines[this.cursor] = s;
            ++this.cursor;
            return this;
        }

        public Publisher build() {
            this.subject = ReplaySubject.createWithSize((int)3);
            for (int i = 0; i < 3; ++i) {
                if (this.lines[i] == null) {
                    throw new IllegalStateException("Header not properly formed (must contain 3 lines) see Header.java");
                }
                this.subject.onNext((Object)this.lines[i]);
            }
            Publisher p = new Publisher();
            p.subject = this.subject;
            if (this.notifier != null) {
                this.notifier.accept(p);
            }
            return p;
        }
    }
}

