/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.serialize;

import java.io.File;
import java.io.Serializable;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import org.numenta.nupic.ComputeCycle;
import org.numenta.nupic.FieldMetaType;
import org.numenta.nupic.Parameters;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.algorithms.BitHistory;
import org.numenta.nupic.algorithms.Classification;
import org.numenta.nupic.model.Cell;
import org.numenta.nupic.model.Column;
import org.numenta.nupic.model.DistalDendrite;
import org.numenta.nupic.model.Pool;
import org.numenta.nupic.model.ProximalDendrite;
import org.numenta.nupic.model.Segment;
import org.numenta.nupic.model.Synapse;
import org.numenta.nupic.network.Inference;
import org.numenta.nupic.network.Layer;
import org.numenta.nupic.network.ManualInput;
import org.numenta.nupic.network.Region;
import org.numenta.nupic.util.NamedTuple;
import org.numenta.nupic.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SerialConfig.class);
    public static final Class<? extends Persistable>[] DEFAULT_REGISTERED_TYPES = new Class[]{Region.class, Layer.class, Cell.class, Column.class, Synapse.class, ProximalDendrite.class, DistalDendrite.class, Segment.class, Inference.class, ManualInput.class, BitHistory.class, Tuple.class, NamedTuple.class, Parameters.class, ComputeCycle.class, Classification.class, FieldMetaType.class, Pool.class, Persistable.class};
    public static final String CHECKPOINT_FORMAT_STRING = "YYYY-MM-dd_HH-mm-ss.SSS";
    public static final StandardOpenOption[] PRODUCTION_OPTIONS = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    public static final StandardOpenOption[] CHECKPOINT_OPTIONS = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    public static final String SERIAL_DIR = "HTMNetwork";
    public static final String SERIAL_TEST_DIR = "HTMNetworkTest";
    private static final String SERIAL_FILE = "Network.ser";
    private static final String CHECKPOINT_FILE = "Network_Checkpoint_";
    private String fileName;
    private String fileDir;
    private List<Class<? extends Persistable>> registry;
    private StandardOpenOption[] options = PRODUCTION_OPTIONS;
    private StandardOpenOption[] checkPointOptions = CHECKPOINT_OPTIONS;
    private String checkPointFileName = "Network_Checkpoint_";
    private String checkPointFormatString = "YYYY-MM-dd_HH-mm-ss.SSS";
    private boolean oneCheckPointOnly;

    public SerialConfig() {
        this(null);
    }

    public SerialConfig(String fileName) {
        this(fileName, null);
    }

    public SerialConfig(String fileName, String fileDir) {
        this(fileName, fileDir, null);
    }

    public SerialConfig(String fileName, String fileDir, List<Class<? extends Persistable>> registeredTypes) {
        this(fileName, fileDir, registeredTypes, PRODUCTION_OPTIONS);
    }

    public SerialConfig(String fileName, String fileDir, List<Class<? extends Persistable>> registeredTypes, StandardOpenOption ... openOptions) {
        this.fileName = fileName == null ? SERIAL_FILE : fileName;
        String string = this.fileDir = fileDir == null ? SERIAL_DIR : fileDir;
        if (registeredTypes == null) {
            LOGGER.debug("List of registered serialize class types was null. Using the default...");
        }
        List<Class<? extends Persistable>> list = this.registry = registeredTypes == null ? Arrays.asList(DEFAULT_REGISTERED_TYPES) : registeredTypes;
        if (openOptions == null) {
            LOGGER.debug("The OpenOptions were null. Using the default...");
        }
        this.options = openOptions == null ? PRODUCTION_OPTIONS : openOptions;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public String getAbsoluteSerialDir() {
        return System.getProperty("user.home") + File.separator + this.fileDir;
    }

    public String getCheckPointFileName() {
        return this.checkPointFileName;
    }

    public void setCheckPointFileName(String name) {
        this.checkPointFileName = name;
    }

    public String getCheckPointFormatString() {
        return this.checkPointFormatString;
    }

    public void setCheckPointTimeFormatString(String formatString) {
        if (formatString == null || formatString.isEmpty()) {
            throw new NullPointerException("Cannot use a null or empty format string.");
        }
        this.checkPointFormatString = formatString;
    }

    public List<Class<? extends Persistable>> getRegistry() {
        return this.registry;
    }

    public StandardOpenOption[] getOpenOptions() {
        return this.options;
    }

    public StandardOpenOption[] getCheckPointOpenOptions() {
        return this.checkPointOptions;
    }

    public void setCheckPointOpenOptions(StandardOpenOption[] options) {
        this.checkPointOptions = options;
    }

    public void setOneCheckPointOnly(boolean b) {
        this.oneCheckPointOnly = b;
    }

    public boolean isOneCheckPointOnly() {
        return this.oneCheckPointOnly;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.registry == null ? 0 : this.registry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerialConfig other = (SerialConfig)obj;
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        return !(this.registry == null ? other.registry != null : !this.registry.equals(other.registry));
    }
}

