/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.serialize.HTMObjectInput;
import org.numenta.nupic.serialize.HTMObjectOutput;
import org.nustaq.serialization.FSTConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerCore
implements Persistable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SerializerCore.class);
    private Class<?>[] classes;
    private transient FSTConfiguration fastSerialConfig = FSTConfiguration.createDefaultConfiguration();

    public SerializerCore(Class<?> ... classes) {
        this.classes = classes;
        this.initFST();
    }

    private void initFST() {
        this.fastSerialConfig = FSTConfiguration.createDefaultConfiguration();
        if (this.classes != null) {
            this.fastSerialConfig.registerClass((Class[])this.classes);
        }
    }

    public void registerClass(Class ... c) {
        this.fastSerialConfig.registerClass(c);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initFST();
    }

    public HTMObjectInput getObjectInput(InputStream is) throws IOException {
        return new HTMObjectInput(is);
    }

    public <T extends Persistable> HTMObjectOutput getObjectOutput(OutputStream os) {
        return new HTMObjectOutput(os);
    }

    public <T extends Persistable> byte[] serialize(T instance) {
        byte[] bytes = null;
        try {
            bytes = this.fastSerialConfig.asByteArray(instance);
        }
        catch (Exception e) {
            bytes = null;
            throw new RuntimeException(e);
        }
        return bytes;
    }

    public <T extends Persistable> T deSerialize(byte[] bytes) {
        Persistable retVal = (Persistable)this.fastSerialConfig.asObject(bytes);
        return (T)((Persistable)retVal.postDeSerialize());
    }

    FSTConfiguration getSerialScheme() {
        return this.fastSerialConfig;
    }
}

