/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.util.FlatMatrix;

public abstract class AbstractFlatMatrix<T>
implements FlatMatrix<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int[] dimensions;
    protected int[] dimensionMultiples;
    protected boolean isColumnMajor;
    protected int numDimensions;

    public AbstractFlatMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public AbstractFlatMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        this.dimensions = dimensions;
        this.numDimensions = dimensions.length;
        this.dimensionMultiples = this.initDimensionMultiples(useColumnMajorOrdering ? AbstractFlatMatrix.reverse(dimensions) : dimensions);
        this.isColumnMajor = useColumnMajorOrdering;
    }

    @Override
    public int computeIndex(int[] indexes) {
        return this.computeIndex(indexes, true);
    }

    @Override
    public int computeIndex(int[] coordinates, boolean doCheck) {
        if (doCheck) {
            this.checkDims(coordinates);
        }
        int[] localMults = this.isColumnMajor ? AbstractFlatMatrix.reverse(this.dimensionMultiples) : this.dimensionMultiples;
        int base = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            base += localMults[i] * coordinates[i];
        }
        return base;
    }

    protected void checkDims(int[] index) {
        if (index.length != this.numDimensions) {
            throw new IllegalArgumentException("Specified coordinates exceed the configured array dimensions input dimensions: " + index.length + " > number of configured dimensions: " + this.numDimensions);
        }
        for (int i = 0; i < index.length - 1; ++i) {
            if (index[i] < this.dimensions[i]) continue;
            throw new IllegalArgumentException("Specified coordinates exceed the configured array dimensions " + AbstractFlatMatrix.print1DArray(index) + " > " + AbstractFlatMatrix.print1DArray(this.dimensions));
        }
    }

    @Override
    public int[] computeCoordinates(int index) {
        int[] returnVal = new int[this.getNumDimensions()];
        int base = index;
        for (int i = 0; i < this.dimensionMultiples.length; ++i) {
            int quotient = base / this.dimensionMultiples[i];
            base %= this.dimensionMultiples[i];
            returnVal[i] = quotient;
        }
        return this.isColumnMajor ? AbstractFlatMatrix.reverse(returnVal) : returnVal;
    }

    protected int[] initDimensionMultiples(int[] dimensions) {
        int holder = 1;
        int len = dimensions.length;
        int[] dimensionMultiples = new int[this.getNumDimensions()];
        for (int i = 0; i < len; ++i) {
            dimensionMultiples[len - 1 - i] = holder *= i == 0 ? 1 : dimensions[len - i];
        }
        return dimensionMultiples;
    }

    protected int[] copyInnerArray(int[] array) {
        if (array.length == 1) {
            return array;
        }
        int[] retVal = new int[array.length - 1];
        System.arraycopy(array, 1, retVal, 0, array.length - 1);
        return retVal;
    }

    public static int[] reverse(int[] input) {
        int[] retVal = new int[input.length];
        int i = input.length - 1;
        int j = 0;
        while (i >= 0) {
            retVal[j] = input[i];
            --i;
            ++j;
        }
        return retVal;
    }

    public static String print1DArray(Object aObject) {
        if (aObject.getClass().isArray()) {
            if (aObject instanceof Object[]) {
                return Arrays.toString((Object[])aObject);
            }
            int length = Array.getLength(aObject);
            Object[] objArr = new Object[length];
            for (int i = 0; i < length; ++i) {
                objArr[i] = Array.get(aObject, i);
            }
            return Arrays.toString(objArr);
        }
        return "[]";
    }

    @Override
    public abstract T get(int var1);

    @Override
    public abstract AbstractFlatMatrix<T> set(int var1, T var2);

    @Override
    public T get(int ... indexes) {
        return this.get(this.computeIndex(indexes));
    }

    @Override
    public AbstractFlatMatrix<T> set(int[] indexes, T value) {
        this.set(this.computeIndex(indexes), (Object)value);
        return this;
    }

    public int getSize() {
        return Arrays.stream(this.dimensions).reduce((n, i) -> n * i).getAsInt();
    }

    @Override
    public int getMaxIndex() {
        return this.getDimensions()[0] * Math.max(1, this.getDimensionMultiples()[0]) - 1;
    }

    @Override
    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int[] dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public int getNumDimensions() {
        return this.dimensions.length;
    }

    @Override
    public int[] getDimensionMultiples() {
        return this.dimensionMultiples;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.dimensionMultiples);
        result = 31 * result + Arrays.hashCode(this.dimensions);
        result = 31 * result + (this.isColumnMajor ? 1231 : 1237);
        result = 31 * result + this.numDimensions;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFlatMatrix other = (AbstractFlatMatrix)obj;
        if (!Arrays.equals(this.dimensionMultiples, other.dimensionMultiples)) {
            return false;
        }
        if (!Arrays.equals(this.dimensions, other.dimensions)) {
            return false;
        }
        if (this.isColumnMajor != other.isColumnMajor) {
            return false;
        }
        return this.numDimensions == other.numDimensions;
    }
}

