/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.util.AbstractSparseMatrix;

public abstract class AbstractSparseBinaryMatrix
extends AbstractSparseMatrix
implements Persistable {
    private static final long serialVersionUID = 1L;
    private int[] trueCounts;

    public AbstractSparseBinaryMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public AbstractSparseBinaryMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
        this.trueCounts = new int[dimensions[0]];
    }

    public abstract Object getSlice(int ... var1);

    protected void sliceError(int ... coordinates) {
        throw new IllegalArgumentException("This method only returns the array holding the specified index: " + Arrays.toString(coordinates));
    }

    protected int[] getSliceIndexes(int[] coordinates) {
        int[] dimensions = this.getDimensions();
        if (coordinates.length >= dimensions.length) {
            this.sliceError(coordinates);
        }
        int sliceDimensionsLength = dimensions.length - coordinates.length;
        int[] sliceDimensions = (int[])Array.newInstance(Integer.TYPE, sliceDimensionsLength);
        for (int i2 = coordinates.length; i2 < dimensions.length; ++i2) {
            sliceDimensions[i2 - coordinates.length] = dimensions[i2];
        }
        int[] elementCoordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
        int sliceSize = Arrays.stream(sliceDimensions).reduce((n, i) -> n * i).getAsInt();
        int[] slice = new int[sliceSize];
        if (coordinates.length + 1 == dimensions.length) {
            for (int i3 = 0; i3 < dimensions[coordinates.length]; ++i3) {
                elementCoordinates[coordinates.length] = i3;
                Array.set(slice, i3, this.computeIndex(elementCoordinates));
            }
        } else {
            for (int i4 = 0; i4 < dimensions[sliceDimensionsLength]; ++i4) {
                elementCoordinates[coordinates.length] = i4;
                int[] indexes = this.getSliceIndexes(elementCoordinates);
                System.arraycopy(indexes, 0, slice, i4 * indexes.length, indexes.length);
            }
        }
        return slice;
    }

    public abstract void rightVecSumAtNZ(int[] var1, int[] var2);

    public abstract void rightVecSumAtNZ(int[] var1, int[] var2, double var3);

    public AbstractSparseBinaryMatrix set(int index, int value) {
        int[] coordinates = this.computeCoordinates(index);
        return this.set(value, coordinates);
    }

    public abstract AbstractSparseBinaryMatrix set(int var1, int ... var2);

    public AbstractSparseBinaryMatrix set(int[] indexes, int[] values) {
        for (int i = 0; i < indexes.length; ++i) {
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    @Override
    public Integer get(int ... coordinates) {
        return this.get(this.computeIndex(coordinates));
    }

    @Override
    public abstract Integer get(int var1);

    public abstract AbstractSparseBinaryMatrix setForTest(int var1, int var2);

    public AbstractSparseBinaryMatrix set(int[] indexes, int[] values, boolean isTest) {
        for (int i = 0; i < indexes.length; ++i) {
            if (isTest) {
                this.setForTest(indexes[i], values[i]);
                continue;
            }
            this.set(indexes[i], values[i]);
        }
        return this;
    }

    public int getTrueCount(int index) {
        return this.trueCounts[index];
    }

    public void setTrueCount(int index, int count) {
        this.trueCounts[index] = count;
    }

    public int[] getTrueCounts() {
        return this.trueCounts;
    }

    public void clearStatistics(int row) {
        this.trueCounts[row] = 0;
        for (int index : this.getSliceIndexes(new int[]{row})) {
            this.set(index, 0);
        }
    }

    @Override
    public int getIntValue(int ... coordinates) {
        return this.get(this.computeIndex(coordinates));
    }

    @Override
    public int getIntValue(int index) {
        return this.get(index);
    }

    @Override
    public int[] getSparseIndices() {
        TIntArrayList indexes = new TIntArrayList();
        for (int i = 0; i <= this.getMaxIndex(); ++i) {
            if (this.get(i) <= 0) continue;
            indexes.add(i);
        }
        return indexes.toArray();
    }

    public AbstractSparseBinaryMatrix or(AbstractSparseBinaryMatrix inputMatrix) {
        int[] mask = inputMatrix.getSparseIndices();
        int[] ones = new int[mask.length];
        Arrays.fill(ones, 1);
        return this.set(mask, ones);
    }

    public AbstractSparseBinaryMatrix or(TIntCollection onBitIndexes) {
        int[] ones = new int[onBitIndexes.size()];
        Arrays.fill(ones, 1);
        return this.set(onBitIndexes.toArray(), ones);
    }

    public AbstractSparseBinaryMatrix or(int[] onBitIndexes) {
        int[] ones = new int[onBitIndexes.length];
        Arrays.fill(ones, 1);
        return this.set(onBitIndexes, ones);
    }

    protected TIntSet getSparseSet() {
        return new TIntHashSet(this.getSparseIndices());
    }

    public boolean all(AbstractSparseBinaryMatrix matrix) {
        return this.getSparseSet().containsAll(matrix.getSparseIndices());
    }

    public boolean all(TIntCollection onBits) {
        return this.getSparseSet().containsAll(onBits);
    }

    public boolean all(int[] onBits) {
        return this.getSparseSet().containsAll(onBits);
    }

    public boolean any(AbstractSparseBinaryMatrix matrix) {
        TIntSet keySet = this.getSparseSet();
        for (int i : matrix.getSparseIndices()) {
            if (!keySet.contains(i)) continue;
            return true;
        }
        return false;
    }

    public boolean any(TIntList onBits) {
        TIntSet keySet = this.getSparseSet();
        TIntIterator i = onBits.iterator();
        while (i.hasNext()) {
            if (!keySet.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public boolean any(int[] onBits) {
        TIntSet keySet = this.getSparseSet();
        for (int i : onBits) {
            if (!keySet.contains(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.trueCounts);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSparseBinaryMatrix other = (AbstractSparseBinaryMatrix)obj;
        return Arrays.equals(this.trueCounts, other.trueCounts);
    }
}

