/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TDoubleIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.numenta.nupic.util.Condition;
import org.numenta.nupic.util.Tuple;

public class ArrayUtils {
    private static int[] EMPTY_ARRAY = new int[0];
    public static Condition<Integer> WHERE_1 = new Condition.Adapter<Integer>(){

        @Override
        public boolean eval(int i) {
            return i == 1;
        }
    };
    public static Condition<Double> GREATER_THAN_0 = new Condition.Adapter<Double>(){

        @Override
        public boolean eval(double i) {
            return i > 0.0;
        }
    };
    public static Condition<Integer> INT_GREATER_THAN_0 = new Condition.Adapter<Integer>(){

        @Override
        public boolean eval(int i) {
            return i > 0;
        }
    };
    public static Condition<Integer> GREATER_OR_EQUAL_0 = new Condition.Adapter<Integer>(){

        @Override
        public boolean eval(int n) {
            return n >= 0;
        }
    };

    public static int product(int[] dims) {
        int retVal = 1;
        for (int i = 0; i < dims.length; ++i) {
            retVal *= dims[i];
        }
        return retVal;
    }

    public static <F, S> Object[] interleave(F first, S second) {
        int flen = Array.getLength(first);
        int slen = Array.getLength(second);
        Object[] retVal = new Object[flen + slen];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < flen || j < slen) {
            if (i < flen) {
                retVal[k++] = Array.get(first, i++);
            }
            if (j >= slen) continue;
            retVal[k++] = Array.get(second, j++);
        }
        return retVal;
    }

    public static double[] diff(double[] d) {
        double[] retVal = new double[d.length - 1];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = d[i + 1] - d[i];
        }
        return retVal;
    }

    public static boolean contains(int[] match, List<int[]> container) {
        int len = container.size();
        for (int i = 0; i < len; ++i) {
            if (!Arrays.equals(match, container.get(i))) continue;
            return true;
        }
        return false;
    }

    public static double[] concat(double[] first, double[] second) {
        double[] retVal = Arrays.copyOf(first, first.length + second.length);
        int i = first.length;
        int j = 0;
        while (i < retVal.length) {
            retVal[i] = second[j];
            ++i;
            ++j;
        }
        return retVal;
    }

    public static int maxIndex(int[] shape) {
        return shape[0] * Math.max(1, ArrayUtils.initDimensionMultiples(shape)[0]) - 1;
    }

    public static int[] toCoordinates(int index, int[] shape, boolean isColumnMajor) {
        int[] dimensionMultiples = ArrayUtils.initDimensionMultiples(shape);
        int[] returnVal = new int[shape.length];
        int base = index;
        for (int i = 0; i < dimensionMultiples.length; ++i) {
            int quotient = base / dimensionMultiples[i];
            base %= dimensionMultiples[i];
            returnVal[i] = quotient;
        }
        return isColumnMajor ? ArrayUtils.reverse(returnVal) : returnVal;
    }

    public static int fromCoordinate(int[] coordinates, int[] shape) {
        int[] localMults = ArrayUtils.initDimensionMultiples(shape);
        int base = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            base += localMults[i] * coordinates[i];
        }
        return base;
    }

    public static int fromCoordinate(int[] coordinates) {
        int[] localMults = ArrayUtils.initDimensionMultiples(coordinates);
        int base = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            base += localMults[i] * coordinates[i];
        }
        return base;
    }

    public static int[] initDimensionMultiples(int[] shape) {
        int holder = 1;
        int len = shape.length;
        int[] dimensionMultiples = new int[shape.length];
        for (int i = 0; i < len; ++i) {
            dimensionMultiples[len - 1 - i] = holder *= i == 0 ? 1 : shape[len - i];
        }
        return dimensionMultiples;
    }

    public static int[][] rotateRight(int[][] array) {
        int r = array.length;
        if (r == 0) {
            return new int[0][0];
        }
        int c = array[0].length;
        int[][] result = new int[c][r];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                result[j][r - 1 - i] = array[i][j];
            }
        }
        return result;
    }

    public static int[][] rotateLeft(int[][] array) {
        int r = array.length;
        if (r == 0) {
            return new int[0][0];
        }
        int c = array[0].length;
        int[][] result = new int[c][r];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                result[c - 1 - j][i] = array[i][j];
            }
        }
        return result;
    }

    public static int[][] ravel(int[] array, int n) throws IllegalArgumentException {
        if (array.length % n != 0) {
            throw new IllegalArgumentException(array.length + " is not evenly divisible by " + n);
        }
        int length = array.length;
        int[][] result = new int[length / n][n];
        for (int i = 0; i < length; ++i) {
            result[i / n][i % n] = array[i];
        }
        return result;
    }

    public static int[] unravel(int[][] array) {
        int r = array.length;
        if (r == 0) {
            return new int[0];
        }
        int c = array[0].length;
        int[] result = new int[r * c];
        int index = 0;
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                result[index] = array[i][j];
                ++index;
            }
        }
        return result;
    }

    public static int[][] reshape(int[][] array, int n) throws IllegalArgumentException {
        int r = array.length;
        if (r == 0) {
            return new int[0][0];
        }
        if (array.length * array[0].length % n != 0) {
            int size = array.length * array[0].length;
            throw new IllegalArgumentException(size + " is not evenly divisible by " + n);
        }
        int c = array[0].length;
        int[][] result = new int[r * c / n][n];
        int ii = 0;
        int jj = 0;
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                result[ii][jj] = array[i][j];
                if (++jj != n) continue;
                jj = 0;
                ++ii;
            }
        }
        return result;
    }

    public static int[] shape(Object inputArray) {
        int nr = 1 + inputArray.getClass().getName().lastIndexOf(91);
        Object oa = inputArray;
        int[] l = new int[nr];
        for (int i = 0; i < nr; ++i) {
            l[i] = Array.getLength(oa);
            int len = l[i];
            if (0 >= len) continue;
            oa = Array.get(oa, 0);
        }
        return l;
    }

    public static int[] argsort(int[] in) {
        return ArrayUtils.argsort(in, -1, -1);
    }

    public static int[] argsort(int[] in, int start, int end) {
        if (start == -1 || end == -1) {
            return IntStream.of(in).sorted().map(i -> Arrays.stream(in).boxed().collect(Collectors.toList()).indexOf(i)).toArray();
        }
        return IntStream.of(in).sorted().map(i -> Arrays.stream(in).boxed().collect(Collectors.toList()).indexOf(i)).skip(start).limit(end).toArray();
    }

    public static double[] to1D(double[][] A) {
        double[] B = new double[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                B[index++] = A[i][j];
            }
        }
        return B;
    }

    public static int[] to1D(int[][] A) {
        int[] B = new int[A.length * A[0].length];
        int index = 0;
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[0].length; ++j) {
                B[index++] = A[i][j];
            }
        }
        return B;
    }

    public static String bitsToString(int[] arr) {
        char[] s = new char[arr.length + 1];
        Arrays.fill(s, '.');
        s[0] = 99;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != 1) continue;
            s[i + 1] = 42;
        }
        return new String(s);
    }

    public static List<Tuple> zip(List<?> arg1, List<?> arg2) {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        int len = Math.min(arg1.size(), arg2.size());
        for (int i = 0; i < len; ++i) {
            tuples.add(new Tuple(arg1.get(i), arg2.get(i)));
        }
        return tuples;
    }

    public static List<Tuple> zip(Object[] ... args) {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            tuples.add(new Tuple(args[i]));
        }
        return tuples;
    }

    public static int[] toIntArray(double[] doubs) {
        int[] retVal = new int[doubs.length];
        for (int i = 0; i < doubs.length; ++i) {
            retVal[i] = (int)doubs[i];
        }
        return retVal;
    }

    public static double[] toDoubleArray(int[] ints) {
        double[] retVal = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            retVal[i] = ints[i];
        }
        return retVal;
    }

    public static int modulo(int a, int b) {
        boolean isMinus;
        if (b == 0) {
            throw new IllegalArgumentException("Division by Zero!");
        }
        if (a > 0 && b > 0 && b > a) {
            return a;
        }
        boolean bl = isMinus = Math.abs(b - (a - b)) < Math.abs(b - (a + b));
        if (isMinus) {
            while (a >= b) {
                a -= b;
            }
        } else {
            if (a % b == 0) {
                return 0;
            }
            while (a + b < b) {
                a += b;
            }
        }
        return a;
    }

    public static int[] modulo(int[] a, int b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = ArrayUtils.modulo(a[i], b);
        }
        return a;
    }

    public static double[] maximum(double[] doubs, double maxValue) {
        double[] retVal = new double[doubs.length];
        for (int i = 0; i < doubs.length; ++i) {
            retVal[i] = Math.max(doubs[i], maxValue);
        }
        return retVal;
    }

    public static int[] maxBetween(int[] arr1, int[] arr2) {
        int[] retVal = new int[arr1.length];
        for (int i = 0; i < arr1.length; ++i) {
            retVal[i] = Math.max(arr1[i], arr2[i]);
        }
        return retVal;
    }

    public static int[] minBetween(int[] arr1, int[] arr2) {
        int[] retVal = new int[arr1.length];
        for (int i = 0; i < arr1.length; ++i) {
            retVal[i] = Math.min(arr1[i], arr2[i]);
        }
        return retVal;
    }

    public static int[] retainLogicalAnd(int[] values, Condition<?>[] conditions) {
        TIntArrayList l = new TIntArrayList();
        for (int i = 0; i < values.length; ++i) {
            boolean result = true;
            for (int j = 0; j < conditions.length && result; result &= conditions[j].eval(values[i]), ++j) {
            }
            if (!result) continue;
            l.add(values[i]);
        }
        return l.toArray();
    }

    public static double[] retainLogicalAnd(double[] values, Condition<?>[] conditions) {
        TDoubleArrayList l = new TDoubleArrayList();
        for (int i = 0; i < values.length; ++i) {
            boolean result = true;
            for (int j = 0; j < conditions.length && result; result &= conditions[j].eval(values[i]), ++j) {
            }
            if (!result) continue;
            l.add(values[i]);
        }
        return l.toArray();
    }

    public static double[] divide(double[] dividend, double[] divisor, double dividendAdjustment, double divisorAdjustment) {
        if (dividend.length != divisor.length) {
            throw new IllegalArgumentException("The dividend array and the divisor array must be the same length");
        }
        double[] quotient = new double[dividend.length];
        double denom = 1.0;
        for (int i = 0; i < dividend.length; ++i) {
            denom = divisor[i] + divisorAdjustment;
            quotient[i] = (dividend[i] + dividendAdjustment) / (denom == 0.0 ? 1.0 : denom);
        }
        return quotient;
    }

    public static double[] divide(int[] dividend, int[] divisor) {
        if (dividend.length != divisor.length) {
            throw new IllegalArgumentException("The dividend array and the divisor array must be the same length");
        }
        double[] quotient = new double[dividend.length];
        double denom = 1.0;
        for (int i = 0; i < dividend.length; ++i) {
            denom = divisor[i];
            quotient[i] = (double)dividend[i] / (denom == 0.0 ? 1.0 : denom);
        }
        return quotient;
    }

    public static double[] divide(double[] dividend, double divisor) {
        double[] quotient = new double[dividend.length];
        double denom = 1.0;
        for (int i = 0; i < dividend.length; ++i) {
            denom = divisor;
            quotient[i] = dividend[i] / (denom == 0.0 ? 1.0 : denom);
        }
        return quotient;
    }

    public static double[] roundDivide(double[] dividend, double[] divisor, int scale) {
        if (dividend.length != divisor.length) {
            throw new IllegalArgumentException("The dividend array and the divisor array must be the same length");
        }
        double[] quotient = new double[dividend.length];
        for (int i = 0; i < dividend.length; ++i) {
            quotient[i] = dividend[i] / (divisor[i] == 0.0 ? 1.0 : divisor[i]);
            quotient[i] = new BigDecimal(quotient[i]).round(new MathContext(scale, RoundingMode.HALF_UP)).doubleValue();
        }
        return quotient;
    }

    public static double[] multiply(double[] multiplicand, double[] factor, double multiplicandAdjustment, double factorAdjustment) {
        if (multiplicand.length != factor.length) {
            throw new IllegalArgumentException("The multiplicand array and the factor array must be the same length");
        }
        double[] product = new double[multiplicand.length];
        for (int i = 0; i < multiplicand.length; ++i) {
            product[i] = (multiplicand[i] + multiplicandAdjustment) * (factor[i] + factorAdjustment);
        }
        return product;
    }

    public static double[] multiply(double[] multiplicand, int[] factor) {
        if (multiplicand.length != factor.length) {
            throw new IllegalArgumentException("The multiplicand array and the factor array must be the same length");
        }
        double[] product = new double[multiplicand.length];
        for (int i = 0; i < multiplicand.length; ++i) {
            product[i] = multiplicand[i] * (double)factor[i];
        }
        return product;
    }

    public static int[] multiply(int[] array, int d) {
        int[] product = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            product[i] = array[i] * d;
        }
        return product;
    }

    public static double[] multiply(double[] array, double d) {
        double[] product = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            product[i] = array[i] * d;
        }
        return product;
    }

    public static int[] subtract(int[] minuend, int[] subtrahend) {
        int[] retVal = new int[minuend.length];
        for (int i = 0; i < minuend.length; ++i) {
            retVal[i] = minuend[i] - subtrahend[i];
        }
        return retVal;
    }

    public static List<Integer> subtract(List<Integer> subtrahend, List<Integer> minuend) {
        ArrayList<Integer> sList = new ArrayList<Integer>(minuend);
        sList.removeAll(subtrahend);
        return new ArrayList<Integer>(sList);
    }

    public static double average(int[] arr) {
        int sum = 0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return (double)sum / (double)arr.length;
    }

    public static double average(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum / (double)arr.length;
    }

    public static double variance(double[] arr, double mean) {
        double accum = 0.0;
        double dev = 0.0;
        double accum2 = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            dev = arr[i] - mean;
            accum += dev * dev;
            accum2 += dev;
        }
        double var = (accum - accum2 * accum2 / (double)arr.length) / (double)arr.length;
        return var;
    }

    public static double variance(double[] arr) {
        return ArrayUtils.variance(arr, ArrayUtils.average(arr));
    }

    public static int[] add(int[] arr, int amount) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + amount;
        }
        return arr;
    }

    public static int[] i_add(int[] arr, int[] amount) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] + amount[i];
        }
        return arr;
    }

    public static double[] d_add(double[] arr, double[] amount) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] + amount[i];
        }
        return arr;
    }

    public static double[] d_add(double[] arr, double amount) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + amount;
        }
        return arr;
    }

    public static int sum(int[] array) {
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static int[] in1d(int[] ar1, int[] ar2) {
        if (ar1 == null || ar2 == null) {
            return EMPTY_ARRAY;
        }
        TIntHashSet retVal = new TIntHashSet(ar2);
        retVal.retainAll(ar1);
        return retVal.toArray();
    }

    public static double sum(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static int[] sparseBinaryOr(int[] arg1, int[] arg2) {
        TIntArrayList t = new TIntArrayList(arg1);
        t.addAll(arg2);
        return ArrayUtils.unique(t.toArray());
    }

    public static String print1DArray(Object aObject) {
        if (aObject.getClass().isArray()) {
            if (aObject instanceof Object[]) {
                return Arrays.toString((Object[])aObject);
            }
            int length = Array.getLength(aObject);
            Object[] objArr = new Object[length];
            for (int i = 0; i < length; ++i) {
                objArr[i] = Array.get(aObject, i);
            }
            return Arrays.toString(objArr);
        }
        return "[]";
    }

    public static double positiveRemainder(double n, double divisor) {
        if (n >= 0.0) {
            return n % divisor;
        }
        double val = divisor + n % divisor;
        return val == divisor ? 0.0 : val;
    }

    public static int[] range(int lowerBounds, int upperBounds) {
        TIntArrayList ints = new TIntArrayList();
        for (int i = lowerBounds; i < upperBounds; ++i) {
            ints.add(i);
        }
        return ints.toArray();
    }

    public static double[] arange(double lowerBounds, double upperBounds, double interval) {
        TDoubleArrayList doubs = new TDoubleArrayList();
        for (double i = lowerBounds; i < upperBounds; i += interval) {
            doubs.add(i);
        }
        return doubs.toArray();
    }

    public static int[] xrange(int lowerBounds, int upperBounds, int interval) {
        TIntArrayList ints = new TIntArrayList();
        for (int i = lowerBounds; i < upperBounds; i += interval) {
            ints.add(i);
        }
        return ints.toArray();
    }

    public static int[] shuffle(int[] array) {
        Random random = new Random(42L);
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            if (index == i) continue;
            int n = index;
            array[n] = array[n] ^ array[i];
            int n2 = i;
            array[n2] = array[n2] ^ array[index];
            int n3 = index;
            array[n3] = array[n3] ^ array[i];
        }
        return array;
    }

    public static int[] replace(int start, int end, int[] orig, int[] replacement) {
        int i = start;
        int j = 0;
        while (i < end) {
            orig[i] = replacement[j];
            ++i;
            ++j;
        }
        return orig;
    }

    public static int[] subst(int[] source, int[] substitutes, int[] substInds) {
        List l = Arrays.stream(substInds).boxed().collect(Collectors.toList());
        return IntStream.range(0, source.length).map(i -> l.indexOf(i) == -1 ? source[i] : substitutes[i]).toArray();
    }

    public static int[] unique(int[] nums) {
        TIntHashSet set = new TIntHashSet(nums);
        int[] result = set.toArray();
        Arrays.sort(result);
        return result;
    }

    public static List<int[]> dimensionsToCoordinateList(List<int[]> dimensions) {
        return CoordinateAssembler.assemble(dimensions);
    }

    public static void setIndexesTo(double[] values, int[] indexes, double setTo) {
        for (int i = 0; i < indexes.length; ++i) {
            values[indexes[i]] = setTo;
        }
    }

    public static void setIndexesTo(int[] values, int[] indexes, int setTo) {
        for (int i = 0; i < indexes.length; ++i) {
            values[indexes[i]] = setTo;
        }
    }

    public static void setRangeTo(int[] values, int start, int stop, int setTo) {
        stop = stop < 0 ? values.length + stop : stop;
        for (int i = start; i < stop; ++i) {
            values[i] = setTo;
        }
    }

    public static int[] sample(int sampleSize, TIntArrayList choices, Random random) {
        TIntHashSet temp = new TIntHashSet();
        int upperBound = choices.size();
        for (int i = 0; i < sampleSize; ++i) {
            int randomIdx = random.nextInt(upperBound);
            while (temp.contains(choices.get(randomIdx))) {
                randomIdx = random.nextInt(upperBound);
            }
            temp.add(choices.get(randomIdx));
        }
        TIntArrayList al = new TIntArrayList((TIntCollection)temp);
        al.sort();
        return al.toArray();
    }

    public static double[] sample(int sampleSize, Random random) {
        double[] sample = new double[sampleSize];
        for (int i = 0; i < sampleSize; ++i) {
            sample[i] = random.nextDouble();
        }
        return sample;
    }

    public static double[] clip(double[] values, double min, double max) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.min(1.0, Math.max(0.0, values[i]));
        }
        return values;
    }

    public static int[] clip(int[] values, int[] min, int[] max) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.max(min[i], Math.min(max[i], values[i]));
        }
        return values;
    }

    public static int[] clip(int[] values, int[] max, int adj) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.max(0, Math.min(max[i] + adj, values[i]));
        }
        return values;
    }

    public static int valueGreaterCount(double compare, double[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > compare)) continue;
            ++count;
        }
        return count;
    }

    public static int valueGreaterCountAtIndex(double compare, double[] array, int[] indexes) {
        int count = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!(array[indexes[i]] > compare)) continue;
            ++count;
        }
        return count;
    }

    public static int[] nGreatest(double[] array, int n) {
        int i;
        TDoubleIntHashMap places = new TDoubleIntHashMap();
        for (int j = 1; j < array.length; ++j) {
            double key = array[j];
            for (i = j - 1; i >= 0 && array[i] < key; --i) {
                array[i + 1] = array[i];
            }
            array[i + 1] = key;
            places.put(key, j);
        }
        int[] retVal = new int[n];
        for (i = 0; i < n; ++i) {
            retVal[i] = places.get(array[i]);
        }
        return retVal;
    }

    public static void raiseValuesBy(double amount, double[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] + amount;
        }
    }

    public static void raiseValuesBy(double amount, double[] values, int[] indexesToRaise) {
        for (int i = 0; i < indexesToRaise.length; ++i) {
            int n = indexesToRaise[i];
            values[n] = values[n] + amount;
        }
    }

    public static void raiseValuesBy(double[] amounts, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            values[n] = values[n] + amounts[i];
        }
    }

    public static void raiseValuesBy(int amount, int[] indexes, int[] values) {
        for (int i = 0; i < indexes.length; ++i) {
            int n = indexes[i];
            values[n] = values[n] + amount;
        }
    }

    public static <T> int[] where(double[] values, Condition<T> c) {
        TIntArrayList retVal = new TIntArrayList();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (!c.eval(values[i])) continue;
            retVal.add(i);
        }
        return retVal.toArray();
    }

    public static <T> int[] where(int[] values, Condition<T> c) {
        TIntArrayList retVal = new TIntArrayList();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (!c.eval(values[i])) continue;
            retVal.add(i);
        }
        return retVal.toArray();
    }

    public static boolean isSparse(int[] ia) {
        if (ia == null || ia.length < 3) {
            return false;
        }
        int end = ia[ia.length - 1];
        int i = ia.length - 1;
        int j = 0;
        while (i >= 0) {
            if (ia[i] > 1) {
                return true;
            }
            if (j > 0 && ia[i] == end) {
                return false;
            }
            --i;
            ++j;
        }
        return false;
    }

    public static int[] asDense(int[] in, int size) {
        int[] retVal = new int[size];
        Arrays.stream(in).forEach(i -> {
            retVal[i] = 1;
        });
        return retVal;
    }

    public static <T> int[] where(List<T> values, Condition<T> c) {
        TIntArrayList retVal = new TIntArrayList();
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            if (!c.eval(values.get(i))) continue;
            retVal.add(i);
        }
        return retVal.toArray();
    }

    public static <T> int[] where(T[] values, Condition<T> c) {
        TIntArrayList retVal = new TIntArrayList();
        for (int i = 0; i < values.length; ++i) {
            if (!c.eval(values[i])) continue;
            retVal.add(i);
        }
        return retVal.toArray();
    }

    public static void lessThanOrEqualXThanSetToY(double[] array, double x, double y) {
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] <= x)) continue;
            array[i] = y;
        }
    }

    public static void lessThanXThanSetToY(double[] array, double x, double y) {
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < x)) continue;
            array[i] = y;
        }
    }

    public static void lessThanXThanSetToY(int[] array, int x, int y) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= x) continue;
            array[i] = y;
        }
    }

    public static void greaterThanOrEqualXThanSetToY(double[] array, double x, double y) {
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] >= x)) continue;
            array[i] = y;
        }
    }

    public static void greaterThanXThanSetToY(double[] array, double x, double y) {
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > x)) continue;
            array[i] = y;
        }
    }

    public static void greaterThanXThanSetToY(int[] array, int x, int y) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= x) continue;
            array[i] = y;
        }
    }

    public static int argmax(int[] array) {
        int index = -1;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
            index = i;
        }
        return index;
    }

    public static Integer[] toBoxed(int[] ints) {
        return IntStream.of(ints).boxed().collect(Collectors.toList()).toArray(new Integer[ints.length]);
    }

    public static Double[] toBoxed(double[] doubles) {
        return DoubleStream.of(doubles).boxed().collect(Collectors.toList()).toArray(new Double[doubles.length]);
    }

    public static byte[] toBytes(boolean[] input) {
        byte[] toReturn = new byte[input.length / 8];
        for (int entry = 0; entry < toReturn.length; ++entry) {
            for (int bit = 0; bit < 8; ++bit) {
                if (!input[entry * 8 + bit]) continue;
                int n = entry;
                toReturn[n] = (byte)(toReturn[n] | 128 >> bit);
            }
        }
        return toReturn;
    }

    public static int[] toPrimitive(Integer[] ints) {
        int[] retVal = new int[ints.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = ints[i];
        }
        return retVal;
    }

    public static double[] toPrimitive(Double[] doubs) {
        double[] retVal = new double[doubs.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = doubs[i];
        }
        return retVal;
    }

    public static int argmax(double[] array) {
        int index = -1;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
            index = i;
        }
        return index;
    }

    public static int max(int[] array) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static double max(double[] array) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    public static double[] sub(double[] source, int[] indexes) {
        double[] retVal = new double[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            retVal[i] = source[indexes[i]];
        }
        return retVal;
    }

    public static int[] sub(int[] source, int[] indexes) {
        int[] retVal = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            retVal[i] = source[indexes[i]];
        }
        return retVal;
    }

    public static int[][] sub(int[][] source, int[] indexes) {
        int[][] retVal = new int[indexes.length][];
        for (int i = 0; i < indexes.length; ++i) {
            retVal[i] = source[indexes[i]];
        }
        return retVal;
    }

    public static int min(int[] array) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    public static double min(double[] array) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static int[] reverse(int[] d) {
        int[] ret = new int[d.length];
        int i = 0;
        for (int j = d.length - 1; j >= 0; --j) {
            ret[i] = d[j];
            ++i;
        }
        return ret;
    }

    public static double[] reverse(double[] d) {
        double[] ret = new double[d.length];
        int i = 0;
        for (int j = d.length - 1; j >= 0; --j) {
            ret[i] = d[j];
            ++i;
        }
        return ret;
    }

    public static int[] or(int[] arg1, int[] arg2) {
        int[] retVal = new int[Math.max(arg1.length, arg2.length)];
        for (int i = 0; i < arg1.length; ++i) {
            retVal[i] = arg1[i] > 0 || arg2[i] > 0 ? 1 : 0;
        }
        return retVal;
    }

    public static int[] and(int[] arg1, int[] arg2) {
        int[] retVal = new int[Math.max(arg1.length, arg2.length)];
        for (int i = 0; i < arg1.length; ++i) {
            retVal[i] = arg1[i] > 0 && arg2[i] > 0 ? 1 : 0;
        }
        return retVal;
    }

    public static int[] tail(int[] original) {
        return Arrays.copyOfRange(original, 1, original.length);
    }

    public static void setValue(Object array, int value, int ... indexes) {
        if (indexes.length == 1) {
            ((int[])array)[indexes[0]] = value;
        } else {
            ArrayUtils.setValue(Array.get(array, indexes[0]), value, ArrayUtils.tail(indexes));
        }
    }

    public static Object getValue(Object array, int ... indexes) {
        Object slice = array;
        for (int i = 0; i < indexes.length; ++i) {
            slice = Array.get(slice, indexes[i]);
        }
        return slice;
    }

    public static void fillArray(Object array, int value) {
        if (array instanceof int[]) {
            Arrays.fill((int[])array, value);
        } else {
            for (Object agr : (Object[])array) {
                ArrayUtils.fillArray(agr, value);
            }
        }
    }

    public static int aggregateArray(Object array) {
        int sum = 0;
        if (array instanceof Integer) {
            return (Integer)array;
        }
        if (array instanceof int[]) {
            int[] set;
            for (int element : set = (int[])array) {
                sum += element;
            }
            return sum;
        }
        for (Object agr : (Object[])array) {
            sum += ArrayUtils.aggregateArray(agr);
        }
        return sum;
    }

    public static String intArrayToString(Object array) {
        StringBuilder result = new StringBuilder();
        if (array instanceof Object[]) {
            result.append(Arrays.deepToString((Object[])array));
        } else {
            result.append(Arrays.toString((int[])array));
        }
        return result.toString();
    }

    public static <T> boolean all(int[] values, Condition<T> condition) {
        for (int element : values) {
            if (condition.eval(element)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    @SafeVarargs
    public static int[] concatAll(int[] first, int[] ... rest) {
        int totalLength = first.length;
        for (int[] array : rest) {
            totalLength += array.length;
        }
        int[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (int[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    private static class CoordinateAssembler {
        private final int[] position;
        private final List<int[]> dimensions;
        final List<int[]> result = new ArrayList<int[]>();

        public static List<int[]> assemble(List<int[]> dimensions) {
            CoordinateAssembler assembler = new CoordinateAssembler(dimensions);
            assembler.process(dimensions.size());
            return assembler.result;
        }

        private CoordinateAssembler(List<int[]> dimensions) {
            this.dimensions = dimensions;
            this.position = new int[dimensions.size()];
        }

        private void process(int level) {
            if (level == 0) {
                int[] coordinates = new int[this.position.length];
                System.arraycopy(this.position, 0, coordinates, 0, this.position.length);
                this.result.add(coordinates);
            } else {
                int index = this.dimensions.size() - level;
                int[] currentDimension = this.dimensions.get(index);
                for (int i = 0; i < currentDimension.length; ++i) {
                    this.position[index] = currentDimension[i];
                    this.process(level - 1);
                }
            }
        }
    }
}

