/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.util.Arrays;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.util.AbstractFlatMatrix;

public class FlatArrayMatrix<T>
extends AbstractFlatMatrix<T>
implements Persistable {
    private static final long serialVersionUID = 1L;
    private T[] data = new Object[this.getSize()];

    public FlatArrayMatrix(int[] dimensions) {
        this(dimensions, false);
    }

    public FlatArrayMatrix(int[] dimensions, boolean useColumnMajorOrdering) {
        super(dimensions, useColumnMajorOrdering);
    }

    @Override
    public T get(int index) {
        return this.data[index];
    }

    @Override
    public FlatArrayMatrix<T> set(int index, T value) {
        this.data[index] = value;
        return this;
    }

    public void fill(T value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlatArrayMatrix other = (FlatArrayMatrix)obj;
        return Arrays.equals(this.data, other.data);
    }
}

