/*
 * Decompiled with CFR 0.152.
 */
package org.numenta.nupic.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.numenta.nupic.Persistable;
import org.numenta.nupic.util.Tuple;

public class NamedTuple
extends Tuple {
    private static final long serialVersionUID = 1L;
    Bucket[] entries;
    String[] keys;
    int hash;
    int thisHashcode;
    private static final String[] EMPTY_KEYS = new String[0];

    public NamedTuple(String[] keys, Object ... objects) {
        super(NamedTuple.interleave(keys, objects));
        int i;
        if (keys.length != objects.length) {
            throw new IllegalArgumentException("Keys and values must be same length.");
        }
        this.keys = keys;
        this.entries = new Bucket[keys.length * 2];
        for (i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new Bucket(i);
        }
        for (i = 0; i < keys.length; ++i) {
            this.addEntry(keys[i], objects[i]);
        }
        this.thisHashcode = this.hashCode();
    }

    public String[] keys() {
        if (this.keys == null || this.keys.length < 1) {
            return EMPTY_KEYS;
        }
        return Arrays.copyOf(this.keys, this.keys.length);
    }

    public Collection<Object> values() {
        ArrayList<Object> retVal = new ArrayList<Object>();
        for (int i = 1; i < this.all().size(); i += 2) {
            retVal.add(this.all().get(i));
        }
        return retVal;
    }

    public Object get(String key) {
        if (key == null) {
            return null;
        }
        int hash = this.hashIndex(key);
        Entry e = this.entries[hash].find(key, hash);
        return e == null ? null : e.value;
    }

    public boolean hasKey(String key) {
        int hash = this.hashIndex(key);
        Entry e = this.entries[hash].find(key, hash);
        return e != null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.entries.length; ++i) {
            sb.append(this.entries[i].toString());
        }
        return sb.toString();
    }

    private void addEntry(String key, Object value) {
        int hash = this.hashIndex(key);
        Entry e = this.entries[hash].find(key, hash);
        if (e != null && e.key.equals(key)) {
            throw new IllegalStateException("Duplicates Not Allowed - Key: " + key + ", reinserted.");
        }
        Entry entry = new Entry(key, value, hash);
        this.entries[hash].add(entry);
    }

    private int hashIndex(String key) {
        return Math.abs(key.hashCode()) % this.entries.length;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            int result = super.hashCode();
            this.hash = result = 31 * result + Arrays.hashCode(this.entries);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NamedTuple other = (NamedTuple)obj;
        return this.thisHashcode == other.thisHashcode;
    }

    static <F, S> Object[] interleave(F first, S second) {
        int flen = Array.getLength(first);
        int slen = Array.getLength(second);
        Object[] retVal = new Object[flen + slen];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < flen || j < slen) {
            if (i < flen) {
                retVal[k++] = Array.get(first, i++);
            }
            if (j >= slen) continue;
            retVal[k++] = Array.get(second, j++);
        }
        return retVal;
    }

    private final class Bucket
    implements Persistable {
        private static final long serialVersionUID = 1L;
        Entry last;
        int idx;

        public Bucket(int idx) {
            this.idx = idx;
        }

        private void add(Entry e) {
            if (this.last == null) {
                this.last = e;
            } else {
                e.prev = this.last;
                this.last = e;
            }
        }

        private Entry find(String key, int hash) {
            if (this.last == null) {
                return null;
            }
            Entry found = this.last;
            while (found.prev != null && !found.key.equals(key)) {
                found = found.prev;
                if (!found.key.equals(key)) continue;
                return found;
            }
            return found.key.equals(key) ? found : null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Bucket: ").append(this.idx).append("\n");
            Entry l = this.last;
            while (l != null) {
                sb.append("\t").append(l.toString()).append("\n");
                l = l.prev;
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.idx;
            result = 31 * result + (this.last == null ? 0 : this.last.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Bucket other = (Bucket)obj;
            if (this.idx != other.idx) {
                return false;
            }
            return !(this.last == null ? other.last != null : !this.last.equals(other.last));
        }
    }

    private final class Entry
    implements Persistable {
        private static final long serialVersionUID = 1L;
        String key;
        Object value;
        int hash;
        Entry prev;

        public Entry(String key, Object value, int hash) {
            this.key = key;
            this.value = value;
            this.hash = NamedTuple.this.hashIndex(key);
        }

        public String toString() {
            return "key=" + this.key + ", value=" + this.value + ", hash=" + this.hash;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hash;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.hash != other.hash) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

