/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.number.IsCloseTo;
import org.junit.Assert;
import org.junit.Test;
import org.openscience.cdk.renderer.generators.standard.AtomSymbol;
import org.openscience.cdk.renderer.generators.standard.ConvexHull;
import org.openscience.cdk.renderer.generators.standard.TextOutline;

public class AtomSymbolTest {
    private final Font font = new Font("Verdana", 0, 12);

    @Test
    public void alignToCenter() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        this.assertCloseTo(outline.getCenter(), symbol.alignTo(AtomSymbol.SymbolAlignment.Center).getAlignmentCenter(), 0.01);
    }

    @Test
    public void alignToLeft() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        this.assertCloseTo(outline.getFirstGlyphCenter(), symbol.alignTo(AtomSymbol.SymbolAlignment.Left).getAlignmentCenter(), 0.01);
    }

    @Test
    public void alignToRight() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        this.assertCloseTo(outline.getLastGlyphCenter(), symbol.alignTo(AtomSymbol.SymbolAlignment.Right).getAlignmentCenter(), 0.01);
    }

    @Test
    public void testGetOutlines() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        Rectangle outlineBounds = outline.getOutline().getBounds();
        Rectangle symbolBounds = ((Shape)symbol.getOutlines().get(0)).getBounds();
        Assert.assertThat((Object)outlineBounds.getX(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getX(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getY(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getY(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getMaxX(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getMaxY(), (double)0.01));
    }

    @Test
    public void testGetOutlinesWithAdjunct() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        TextOutline adjunct = new TextOutline("H", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Arrays.asList(adjunct));
        Rectangle outlineBounds = adjunct.getOutline().getBounds();
        Rectangle symbolBounds = ((Shape)symbol.getOutlines().get(1)).getBounds();
        Assert.assertThat((Object)outlineBounds.getX(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getX(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getY(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getY(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getMaxX(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getMaxY(), (double)0.01));
    }

    @Test
    public void testGetConvexHull() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        ConvexHull outlineHull = ConvexHull.ofShape((Shape)outline.getOutline());
        ConvexHull symbolHull = symbol.getConvexHull();
        Rectangle2D outlineBounds = outlineHull.outline().getBounds2D();
        Rectangle2D symbolBounds = symbolHull.outline().getBounds2D();
        Assert.assertThat((Object)outlineBounds.getX(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getX(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getY(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getY(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getMaxX(), (double)0.01));
        Assert.assertThat((Object)outlineBounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)symbolBounds.getMaxY(), (double)0.01));
    }

    @Test
    public void testResize() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        AtomSymbol transformed = symbol.resize(2.0, 2.0);
        Rectangle2D orgBounds = outline.getBounds();
        Rectangle2D newBounds = ((Shape)transformed.getOutlines().get(0)).getBounds2D();
        Assert.assertThat((Object)newBounds.getX(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getX() - orgBounds.getWidth() / 2.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getY(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getY() - orgBounds.getHeight() / 2.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getMaxX() + orgBounds.getWidth() / 2.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getMaxY() + orgBounds.getHeight() / 2.0), (double)0.01));
    }

    @Test
    public void testCenter() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        AtomSymbol transformed = symbol.center(2.0, 2.0);
        Rectangle2D oBounds = outline.getBounds();
        Rectangle2D newBounds = ((Shape)transformed.getOutlines().get(0)).getBounds2D();
        double dx = 2.0 - oBounds.getCenterX();
        double dy = 2.0 - oBounds.getCenterY();
        Assert.assertThat((Object)newBounds.getX(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getMinX() + dx), (double)0.01));
        Assert.assertThat((Object)newBounds.getY(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getMinY() + dy), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getMaxX() + dx), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getMaxY() + dy), (double)0.01));
    }

    @Test
    public void testTranslate() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Collections.emptyList());
        AtomSymbol transformed = symbol.translate(4.0, 2.0);
        Rectangle2D orgBounds = ((Shape)symbol.getOutlines().get(0)).getBounds2D();
        Rectangle2D newBounds = ((Shape)transformed.getOutlines().get(0)).getBounds2D();
        Assert.assertThat((Object)newBounds.getX(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getX() + 4.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getY(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getY() + 2.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getMaxX() + 4.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getMaxY() + 2.0), (double)0.01));
    }

    @Test
    public void testTranslateAdjunct() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        TextOutline adjunct = new TextOutline("H", this.font);
        AtomSymbol symbol = new AtomSymbol(outline, Arrays.asList(adjunct));
        AtomSymbol transformed = symbol.translate(4.0, 2.0);
        Rectangle2D orgBounds = ((Shape)symbol.getOutlines().get(0)).getBounds2D();
        Rectangle2D newBounds = ((Shape)transformed.getOutlines().get(0)).getBounds2D();
        Assert.assertThat((Object)newBounds.getX(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getX() + 4.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getY(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getY() + 2.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getMaxX() + 4.0), (double)0.01));
        Assert.assertThat((Object)newBounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)(orgBounds.getMaxY() + 2.0), (double)0.01));
    }

    void assertCloseTo(Point2D actual, Point2D expected, double epsilon) {
        Assert.assertThat((Object)actual.getX(), (Matcher)IsCloseTo.closeTo((double)expected.getX(), (double)epsilon));
        Assert.assertThat((Object)actual.getY(), (Matcher)IsCloseTo.closeTo((double)expected.getY(), (double)epsilon));
    }
}

