/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.standard.AtomSymbol;
import org.openscience.cdk.renderer.generators.standard.HydrogenPosition;
import org.openscience.cdk.renderer.generators.standard.StandardAtomGenerator;
import org.openscience.cdk.renderer.generators.standard.StandardGenerator;
import org.openscience.cdk.renderer.generators.standard.TextOutline;

public class StandardAtomGeneratorTest {
    private final Font font = new Font("Verdana", 0, 12);
    private final TextOutline element = new TextOutline("N", this.font);
    private final TextOutline hydrogen = new TextOutline("H", this.font);
    private final StandardAtomGenerator atomGenerator = new StandardAtomGenerator(this.font);

    @Test
    public void positionHydrogenAbove() {
        TextOutline positioned = this.atomGenerator.positionHydrogenLabel(HydrogenPosition.Above, this.element, this.hydrogen);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D hydrogenBounds = positioned.getBounds();
        Assert.assertThat((Object)elementBounds.getMinY(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(hydrogenBounds.getMaxY())));
        Assert.assertThat((Object)elementBounds.getMinX(), (Matcher)Matchers.closeTo((double)hydrogenBounds.getMinX(), (double)0.01));
    }

    @Test
    public void positionHydrogenBelow() {
        TextOutline positioned = this.atomGenerator.positionHydrogenLabel(HydrogenPosition.Below, this.element, this.hydrogen);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D hydrogenBounds = positioned.getBounds();
        Assert.assertThat((Object)elementBounds.getMinY(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(hydrogenBounds.getMaxY())));
        Assert.assertThat((Object)elementBounds.getMinX(), (Matcher)Matchers.closeTo((double)hydrogenBounds.getMinX(), (double)0.01));
    }

    @Test
    public void positionHydrogenToLeft() {
        TextOutline positioned = this.atomGenerator.positionHydrogenLabel(HydrogenPosition.Left, this.element, this.hydrogen);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D hydrogenBounds = positioned.getBounds();
        Assert.assertThat((Object)elementBounds.getMaxX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(hydrogenBounds.getMinX())));
        Assert.assertThat((Object)elementBounds.getMaxY(), (Matcher)Matchers.closeTo((double)hydrogenBounds.getMaxY(), (double)0.01));
    }

    @Test
    public void positionHydrogenToRight() {
        TextOutline positioned = this.atomGenerator.positionHydrogenLabel(HydrogenPosition.Right, this.element, this.hydrogen);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D hydrogenBounds = positioned.getBounds();
        Assert.assertThat((Object)elementBounds.getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(hydrogenBounds.getMinX())));
        Assert.assertThat((Object)elementBounds.getMaxY(), (Matcher)Matchers.closeTo((double)hydrogenBounds.getMaxY(), (double)0.01));
    }

    @Test
    public void positionHydrogenCount() {
        TextOutline hydrogenCount = new TextOutline("2", this.font);
        TextOutline positioned = this.atomGenerator.positionSubscript(this.hydrogen, hydrogenCount);
        Rectangle2D hydrogenBounds = this.hydrogen.getBounds();
        Rectangle2D hydrogenCountBounds = positioned.getBounds();
        Assert.assertThat((Object)hydrogenCountBounds.getMinX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(hydrogenBounds.getMinX())));
        Assert.assertThat((Object)hydrogenCountBounds.getCenterY(), (Matcher)Matchers.closeTo((double)hydrogenBounds.getMaxY(), (double)0.01));
    }

    @Test
    public void positionMassLabel() {
        TextOutline mass = new TextOutline("15", this.font);
        TextOutline positioned = this.atomGenerator.positionMassLabel(mass, this.element);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D massBounds = positioned.getBounds();
        Assert.assertThat((Object)massBounds.getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(elementBounds.getMinX())));
        Assert.assertThat((Object)massBounds.getCenterY(), (Matcher)Matchers.closeTo((double)elementBounds.getMinY(), (double)0.01));
    }

    @Test
    public void positionOfChargeWhenHydrogensAreRight() {
        TextOutline charge = new TextOutline("+", this.font);
        TextOutline localHydrogen = this.hydrogen.translate(10.0, 10.0);
        TextOutline positioned = this.atomGenerator.positionChargeLabel(1, HydrogenPosition.Right, charge, this.element, localHydrogen);
        Rectangle2D hydrogenBounds = localHydrogen.getBounds();
        Rectangle2D chargeBounds = positioned.getBounds();
        Assert.assertThat((Object)chargeBounds.getMinX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(hydrogenBounds.getMinX())));
        Assert.assertThat((Object)chargeBounds.getCenterY(), (Matcher)Matchers.closeTo((double)hydrogenBounds.getMinY(), (double)0.01));
    }

    @Test
    public void positionOfChargeWhenNoHydrogensAreRight() {
        TextOutline charge = new TextOutline("+", this.font);
        TextOutline localHydrogen = this.hydrogen.translate(10.0, 10.0);
        TextOutline positioned = this.atomGenerator.positionChargeLabel(0, HydrogenPosition.Right, charge, this.element, localHydrogen);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D chargeBounds = positioned.getBounds();
        Assert.assertThat((Object)chargeBounds.getMinX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(elementBounds.getMinX())));
        Assert.assertThat((Object)chargeBounds.getCenterY(), (Matcher)Matchers.closeTo((double)elementBounds.getMinY(), (double)0.01));
    }

    @Test
    public void positionOfChargeWhenHydrogensAreLeft() {
        TextOutline charge = new TextOutline("+", this.font);
        TextOutline localHydrogen = this.hydrogen.translate(10.0, 10.0);
        TextOutline positioned = this.atomGenerator.positionChargeLabel(1, HydrogenPosition.Left, charge, this.element, localHydrogen);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D chargeBounds = positioned.getBounds();
        Assert.assertThat((Object)chargeBounds.getMinX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(elementBounds.getMinX())));
        Assert.assertThat((Object)chargeBounds.getCenterY(), (Matcher)Matchers.closeTo((double)elementBounds.getMinY(), (double)0.01));
    }

    @Test
    public void positionOfChargeWhenHydrogensAreBelow() {
        TextOutline charge = new TextOutline("+", this.font);
        TextOutline positioned = this.atomGenerator.positionChargeLabel(1, HydrogenPosition.Below, charge, this.element, this.hydrogen.translate(0.0, 5.0));
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D chargeBounds = positioned.getBounds();
        Assert.assertThat((Object)chargeBounds.getMinX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(elementBounds.getMinX())));
        Assert.assertThat((Object)chargeBounds.getCenterY(), (Matcher)Matchers.closeTo((double)elementBounds.getMinY(), (double)0.01));
    }

    @Test
    public void positionOfChargeWhenTwoHydrogensAreAbove() {
        TextOutline charge = new TextOutline("+", this.font);
        TextOutline localHydrogen = this.hydrogen.translate(10.0, 10.0);
        TextOutline positioned = this.atomGenerator.positionChargeLabel(2, HydrogenPosition.Above, charge, this.element, localHydrogen);
        Rectangle2D hydrogenBounds = localHydrogen.getBounds();
        Rectangle2D chargeBounds = positioned.getBounds();
        Assert.assertThat((Object)chargeBounds.getMinX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(hydrogenBounds.getMinX())));
        Assert.assertThat((Object)chargeBounds.getCenterY(), (Matcher)Matchers.closeTo((double)hydrogenBounds.getMinY(), (double)0.01));
    }

    @Test
    public void positionOfChargeWhenOneHydrogenIsAbove() {
        TextOutline charge = new TextOutline("+", this.font);
        TextOutline localHydrogen = this.hydrogen.translate(10.0, 10.0);
        TextOutline positioned = this.atomGenerator.positionChargeLabel(1, HydrogenPosition.Above, charge, this.element, localHydrogen);
        Rectangle2D elementBounds = this.element.getBounds();
        Rectangle2D chargeBounds = positioned.getBounds();
        Assert.assertThat((Object)chargeBounds.getMinX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(elementBounds.getMinX())));
        Assert.assertThat((Object)chargeBounds.getCenterY(), (Matcher)Matchers.closeTo((double)elementBounds.getMinY(), (double)0.01));
    }

    @Test
    public void generateWithNoAdjuncts() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 0, -1, 0, 0, HydrogenPosition.Right);
        Assert.assertThat((Object)symbol.getOutlines().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void generateWithHydrogenAdjunct() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 1, -1, 0, 0, HydrogenPosition.Right);
        Assert.assertThat((Object)symbol.getOutlines().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void generateWithHydrogenAndCountAdjunct() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 2, -1, 0, 0, HydrogenPosition.Right);
        Assert.assertThat((Object)symbol.getOutlines().size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void generateWithMassAdjunct() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 0, 15, 0, 0, HydrogenPosition.Right);
        Assert.assertThat((Object)symbol.getOutlines().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void generateWithChargeAdjunct() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 0, -1, 1, 0, HydrogenPosition.Right);
        Assert.assertThat((Object)symbol.getOutlines().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void generateWithRadicalAdjunct() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 0, -1, 0, 1, HydrogenPosition.Right);
        Assert.assertThat((Object)symbol.getOutlines().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void hydrogenDodgesMassLabel() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 1, 15, 0, 0, HydrogenPosition.Left);
        List outlines = symbol.getOutlines();
        Assert.assertThat((Object)outlines.size(), (Matcher)CoreMatchers.is((Object)3));
        Shape hydrogenShape = (Shape)outlines.get(1);
        Shape massShape = (Shape)outlines.get(2);
        Assert.assertThat((Object)hydrogenShape.getBounds2D().getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(massShape.getBounds2D().getMinX())));
    }

    @Test
    public void hydrogenAndHydrogenCountDodgesMassLabel() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 2, 15, 0, 0, HydrogenPosition.Left);
        List outlines = symbol.getOutlines();
        Assert.assertThat((Object)outlines.size(), (Matcher)CoreMatchers.is((Object)4));
        Shape hydrogenShape = (Shape)outlines.get(1);
        Shape hydrogenCountShape = (Shape)outlines.get(2);
        Shape massShape = (Shape)outlines.get(3);
        Assert.assertThat((Object)hydrogenShape.getBounds2D().getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(massShape.getBounds2D().getMinX())));
        Assert.assertThat((Object)hydrogenCountShape.getBounds2D().getMaxX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(massShape.getBounds2D().getMinX())));
        Assert.assertThat((Object)hydrogenCountShape.getBounds2D().getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(massShape.getBounds2D().getMaxX())));
        Assert.assertThat((Object)hydrogenShape.getBounds2D().getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(hydrogenCountShape.getBounds2D().getMinX())));
    }

    @Test
    public void hydrogenCountDodgesElement() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 2, -1, 0, 0, HydrogenPosition.Left);
        List outlines = symbol.getOutlines();
        Assert.assertThat((Object)outlines.size(), (Matcher)CoreMatchers.is((Object)3));
        Shape elementShape = (Shape)outlines.get(0);
        Shape hydrogenShape = (Shape)outlines.get(1);
        Shape hydrogenCountShape = (Shape)outlines.get(2);
        Assert.assertThat((Object)hydrogenCountShape.getBounds2D().getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(elementShape.getBounds2D().getMinX())));
        Assert.assertThat((Object)hydrogenShape.getBounds2D().getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(hydrogenCountShape.getBounds2D().getMinX())));
    }

    @Test
    public void hydrogenDoesNotNeedToDodge() {
        AtomSymbol symbol = this.atomGenerator.generatePeriodicSymbol(7, 1, -1, 0, 0, HydrogenPosition.Left);
        List outlines = symbol.getOutlines();
        Assert.assertThat((Object)outlines.size(), (Matcher)CoreMatchers.is((Object)2));
        Shape elementShape = (Shape)outlines.get(0);
        Shape hydrogenShape = (Shape)outlines.get(1);
        Assert.assertThat((Object)hydrogenShape.getBounds2D().getMaxX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(elementShape.getBounds2D().getMinX())));
    }

    @Test
    public void anion() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)-1, (int)0), (Matcher)CoreMatchers.is((Object)"\u2212"));
    }

    @Test
    public void cation() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)1, (int)0), (Matcher)CoreMatchers.is((Object)"+"));
    }

    @Test
    public void dianion() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)-2, (int)0), (Matcher)CoreMatchers.is((Object)"2\u2212"));
    }

    @Test
    public void dication() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)2, (int)0), (Matcher)CoreMatchers.is((Object)"2+"));
    }

    @Test
    public void radical() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)0, (int)1), (Matcher)CoreMatchers.is((Object)"\u2022"));
    }

    @Test
    public void diradical() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)0, (int)2), (Matcher)CoreMatchers.is((Object)"2\u2022"));
    }

    @Test
    public void diradicalCation() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)1, (int)2), (Matcher)CoreMatchers.is((Object)"(2\u2022)+"));
    }

    @Test
    public void radicalAndAnion() throws Exception {
        Assert.assertThat((Object)StandardAtomGenerator.chargeAdjunctText((int)-1, (int)1), (Matcher)CoreMatchers.is((Object)"(\u2022)\u2212"));
    }

    @Test
    public void accessNullPseudoLabel() throws Exception {
        IPseudoAtom atom = (IPseudoAtom)Mockito.mock(IPseudoAtom.class);
        Mockito.when((Object)atom.getLabel()).thenReturn(null);
        Assert.assertThat((Object)StandardAtomGenerator.accessPseudoLabel((IPseudoAtom)atom, (String)"*"), (Matcher)CoreMatchers.is((Object)"*"));
    }

    @Test
    public void accessEmptyPseudoLabel() throws Exception {
        IPseudoAtom atom = (IPseudoAtom)Mockito.mock(IPseudoAtom.class);
        Mockito.when((Object)atom.getLabel()).thenReturn((Object)"");
        Assert.assertThat((Object)StandardAtomGenerator.accessPseudoLabel((IPseudoAtom)atom, (String)"*"), (Matcher)CoreMatchers.is((Object)"*"));
    }

    @Test
    public void accessRgroupPseudoLabel() throws Exception {
        IPseudoAtom atom = (IPseudoAtom)Mockito.mock(IPseudoAtom.class);
        Mockito.when((Object)atom.getLabel()).thenReturn((Object)"R1");
        Assert.assertThat((Object)StandardAtomGenerator.accessPseudoLabel((IPseudoAtom)atom, (String)"*"), (Matcher)CoreMatchers.is((Object)"R1"));
    }

    @Test
    public void numberedRgroupSymbol() {
        AtomSymbol atomSymbol = this.atomGenerator.generatePseudoSymbol("R1", HydrogenPosition.Right);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void RgroupSymbol2A() {
        AtomSymbol atomSymbol = this.atomGenerator.generatePseudoSymbol("R2a", HydrogenPosition.Right);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void RgroupSymbolY() {
        AtomSymbol atomSymbol = this.atomGenerator.generatePseudoSymbol("Y1a2", HydrogenPosition.Right);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void RgroupSymbolPrime() {
        AtomSymbol atomSymbol = this.atomGenerator.generatePseudoSymbol("R'", HydrogenPosition.Right);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void RgroupSymbolNumberedPrime() {
        AtomSymbol atomSymbol = this.atomGenerator.generatePseudoSymbol("R2'", HydrogenPosition.Right);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void pseudoSymbol() {
        AtomSymbol atomSymbol = this.atomGenerator.generatePseudoSymbol("Protein", HydrogenPosition.Right);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void generatesRgroupPseudoAtom() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IPseudoAtom atom = (IPseudoAtom)Mockito.mock(IPseudoAtom.class);
        Mockito.when((Object)atom.getLabel()).thenReturn((Object)"R1");
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, (IAtom)atom, HydrogenPosition.Left, new RendererModel());
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void generatesCarbon12() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)6);
        Mockito.when((Object)atom.getMassNumber()).thenReturn((Object)12);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn((Object)0);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn((Object)0);
        RendererModel model = new RendererModel();
        model.registerParameters((IGenerator)new StandardGenerator(new Font("SansSerif", 0, 12)));
        model.set(StandardGenerator.OmitMajorIsotopes.class, (Object)true);
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, model);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void generatesCarbon13() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)6);
        Mockito.when((Object)atom.getMassNumber()).thenReturn((Object)13);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn((Object)0);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn((Object)0);
        RendererModel model = new RendererModel();
        model.registerParameters((IGenerator)new StandardGenerator(new Font("SansSerif", 0, 12)));
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, model);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void nullMassNumber() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)6);
        Mockito.when((Object)atom.getMassNumber()).thenReturn(null);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn((Object)0);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn((Object)0);
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, new RendererModel());
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void nullHydrogenCount() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)6);
        Mockito.when((Object)atom.getMassNumber()).thenReturn((Object)12);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn(null);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn((Object)0);
        RendererModel model = new RendererModel();
        model.registerParameters((IGenerator)new StandardGenerator(new Font("SansSerif", 0, 12)));
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, model);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void nullFormatCharge() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)6);
        Mockito.when((Object)atom.getMassNumber()).thenReturn((Object)12);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn((Object)0);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn(null);
        RendererModel model = new RendererModel();
        model.registerParameters((IGenerator)new StandardGenerator(new Font("SansSerif", 0, 12)));
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, model);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void nullAtomicNumber() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn(null);
        Mockito.when((Object)atom.getSymbol()).thenReturn((Object)"C");
        Mockito.when((Object)atom.getMassNumber()).thenReturn((Object)12);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn((Object)0);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn((Object)0);
        RendererModel model = new RendererModel();
        model.registerParameters((IGenerator)new StandardGenerator(new Font("SansSerif", 0, 12)));
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, model);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)atomSymbol.elementOutline().text(), (Matcher)CoreMatchers.is((Object)"C"));
    }

    @Test
    public void nullAtomicNumberAndSymbol() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn(null);
        Mockito.when((Object)atom.getSymbol()).thenReturn(null);
        Mockito.when((Object)atom.getMassNumber()).thenReturn((Object)0);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn((Object)0);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn((Object)0);
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, new RendererModel());
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)atomSymbol.elementOutline().text(), (Matcher)CoreMatchers.is((Object)"*"));
    }

    @Test
    public void unpairedElectronsAreAccessed() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)6);
        Mockito.when((Object)atom.getMassNumber()).thenReturn((Object)12);
        Mockito.when((Object)atom.getImplicitHydrogenCount()).thenReturn((Object)0);
        Mockito.when((Object)atom.getFormalCharge()).thenReturn((Object)0);
        Mockito.when((Object)container.getConnectedSingleElectronsCount(atom)).thenReturn((Object)1);
        RendererModel model = new RendererModel();
        model.registerParameters((IGenerator)new StandardGenerator(new Font("SansSerif", 0, 12)));
        AtomSymbol atomSymbol = this.atomGenerator.generateSymbol(container, atom, HydrogenPosition.Left, model);
        List shapes = atomSymbol.getOutlines();
        Assert.assertThat((Object)shapes.size(), (Matcher)CoreMatchers.is((Object)3));
        ((IAtomContainer)Mockito.verify((Object)container)).getConnectedSingleElectronsCount(atom);
    }
}

