/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.generators.standard.HydrogenPosition;

public class HydrogenPositionTest {
    @Test
    public void cardinalDirectionForNorthIsBelow() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(0.0, 1.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Below));
    }

    @Test
    public void cardinalDirectionForNorthEastIsLeft() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(1.0, 1.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void cardinalDirectionForEastIsLeft() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(1.0, 0.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void cardinalDirectionForSouthEastIsLeft() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(1.0, -1.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void cardinalDirectionForSouthIsAbove() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(0.0, -1.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Above));
    }

    @Test
    public void cardinalDirectionForSouthWestIsRight() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(-1.0, -1.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void cardinalDirectionForWestIsRight() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(-1.0, 0.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void cardinalDirectionForNorthWestIsRight() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.usingCardinalDirection((Vector2d)new Vector2d(-1.0, 0.0)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void hydrogensAppearBeforeOxygen() throws Exception {
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)8);
        MatcherAssert.assertThat((Object)HydrogenPosition.usingDefaultPlacement((IAtom)atom), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void hydrogensAppearBeforeSulfur() throws Exception {
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)16);
        MatcherAssert.assertThat((Object)HydrogenPosition.usingDefaultPlacement((IAtom)atom), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void hydrogensAppearAfterNitrogen() throws Exception {
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)7);
        MatcherAssert.assertThat((Object)HydrogenPosition.usingDefaultPlacement((IAtom)atom), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void hydrogensAppearAfterCarbon() throws Exception {
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)6);
        MatcherAssert.assertThat((Object)HydrogenPosition.usingDefaultPlacement((IAtom)atom), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void hydrogensAppearAfterWhenBondIsFromLeft() throws Exception {
        IAtom atom1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom atom2 = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom1.getPoint2d()).thenReturn((Object)new Point2d(0.0, 0.0));
        Mockito.when((Object)atom2.getPoint2d()).thenReturn((Object)new Point2d(-1.0, 0.0));
        MatcherAssert.assertThat((Object)HydrogenPosition.position((IAtom)atom1, Arrays.asList(atom2)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void hydrogensAppearBeforeWhenBondIsFromRight() throws Exception {
        IAtom atom1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom atom2 = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom1.getPoint2d()).thenReturn((Object)new Point2d(0.0, 0.0));
        Mockito.when((Object)atom2.getPoint2d()).thenReturn((Object)new Point2d(1.0, 0.0));
        MatcherAssert.assertThat((Object)HydrogenPosition.position((IAtom)atom1, Arrays.asList(atom2)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void usingCardinalDirection() throws Exception {
        IAtom atom1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom atom2 = (IAtom)Mockito.mock(IAtom.class);
        IAtom atom3 = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom1.getPoint2d()).thenReturn((Object)new Point2d(0.0, 0.0));
        Mockito.when((Object)atom2.getPoint2d()).thenReturn((Object)new Point2d(1.0, 1.0));
        Mockito.when((Object)atom3.getPoint2d()).thenReturn((Object)new Point2d(1.0, -1.0));
        MatcherAssert.assertThat((Object)HydrogenPosition.position((IAtom)atom1, Arrays.asList(atom2, atom3)), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void useDefaultPlacementWithNoBonds() throws Exception {
        IAtom atom = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom.getAtomicNumber()).thenReturn((Object)8);
        MatcherAssert.assertThat((Object)HydrogenPosition.position((IAtom)atom, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void values() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.values(), (Matcher)CoreMatchers.is((Object)new HydrogenPosition[]{HydrogenPosition.Right, HydrogenPosition.Left, HydrogenPosition.Above, HydrogenPosition.Below}));
    }

    @Test
    public void valueOf() throws Exception {
        MatcherAssert.assertThat((Object)HydrogenPosition.valueOf((String)"Above"), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Above));
    }

    @Test
    public void angularExtentRight() throws Exception {
        double theta = Math.toRadians(60.0);
        List<Vector2d> vectors = Arrays.asList(new Vector2d(-1.0, 0.0), new Vector2d(Math.cos(theta), Math.sin(theta)), new Vector2d(Math.cos(-theta), Math.sin(-theta)));
        MatcherAssert.assertThat((Object)HydrogenPosition.usingAngularExtent(vectors), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void angularExtentLeft() throws Exception {
        double theta = Math.toRadians(120.0);
        List<Vector2d> vectors = Arrays.asList(new Vector2d(1.0, 0.0), new Vector2d(Math.cos(theta), Math.sin(theta)), new Vector2d(Math.cos(-theta), Math.sin(-theta)));
        MatcherAssert.assertThat((Object)HydrogenPosition.usingAngularExtent(vectors), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Left));
    }

    @Test
    public void angularExtentBelow() throws Exception {
        double theta1 = Math.toRadians(210.0);
        double theta2 = Math.toRadians(330.0);
        List<Vector2d> vectors = Arrays.asList(new Vector2d(0.0, 1.0), new Vector2d(Math.cos(theta1), Math.sin(theta1)), new Vector2d(Math.cos(theta2), Math.sin(theta2)));
        MatcherAssert.assertThat((Object)HydrogenPosition.usingAngularExtent(vectors), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Below));
    }

    @Test
    public void angularExtentAbove() throws Exception {
        double theta1 = Math.toRadians(30.0);
        double theta2 = Math.toRadians(150.0);
        List<Vector2d> vectors = Arrays.asList(new Vector2d(0.0, -1.0), new Vector2d(Math.cos(theta1), Math.sin(theta1)), new Vector2d(Math.cos(theta2), Math.sin(theta2)));
        MatcherAssert.assertThat((Object)HydrogenPosition.usingAngularExtent(vectors), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Above));
    }

    @Test
    public void symmetric() throws Exception {
        List<Vector2d> vectors = Arrays.asList(new Vector2d(1.0, 1.0), new Vector2d(1.0, -1.0), new Vector2d(-1.0, 1.0), new Vector2d(-1.0, -1.0));
        MatcherAssert.assertThat((Object)HydrogenPosition.usingAngularExtent(vectors), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Right));
    }

    @Test
    public void largestExtent() throws Exception {
        List<Vector2d> vectors = Arrays.asList(new Vector2d(Math.cos(Math.toRadians(30.0)), Math.sin(Math.toRadians(30.0))), new Vector2d(Math.cos(Math.toRadians(-30.0)), Math.sin(Math.toRadians(-30.0))), new Vector2d(Math.cos(Math.toRadians(150.0)), Math.sin(Math.toRadians(150.0))), new Vector2d(Math.cos(Math.toRadians(-150.0)), Math.sin(Math.toRadians(-150.0))));
        MatcherAssert.assertThat((Object)HydrogenPosition.usingAngularExtent(vectors), (Matcher)CoreMatchers.is((Object)HydrogenPosition.Above));
    }
}

