/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Color;
import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.SymbolVisibility;
import org.openscience.cdk.renderer.generators.standard.SelectionVisibility;
import org.openscience.cdk.silent.Atom;

public class SelectionVisibilityTest {
    @Test
    public void noHighlightOrGlow() {
        AtomContainer methyl = new AtomContainer();
        methyl.addAtom(SelectionVisibilityTest.atomAt("C", new Point2d(0.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, 1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, -1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(1.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(-1.0, 0.0)));
        methyl.addBond(0, 1, IBond.Order.SINGLE);
        methyl.addBond(0, 2, IBond.Order.SINGLE);
        methyl.addBond(0, 3, IBond.Order.SINGLE);
        methyl.addBond(0, 4, IBond.Order.SINGLE);
        SymbolVisibility visibility = SelectionVisibility.all((SymbolVisibility)SymbolVisibility.iupacRecommendations());
        Assert.assertFalse((boolean)visibility.visible(methyl.getAtom(0), methyl.getConnectedBondsList(methyl.getAtom(0)), new RendererModel()));
    }

    @Test
    public void withHighlight() {
        AtomContainer methyl = new AtomContainer();
        methyl.addAtom(SelectionVisibilityTest.atomAt("C", new Point2d(0.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, 1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, -1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(1.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(-1.0, 0.0)));
        methyl.getAtom(0).setProperty((Object)"stdgen.highlight.color", (Object)Color.RED);
        methyl.addBond(0, 1, IBond.Order.SINGLE);
        methyl.addBond(0, 2, IBond.Order.SINGLE);
        methyl.addBond(0, 3, IBond.Order.SINGLE);
        methyl.addBond(0, 4, IBond.Order.SINGLE);
        SymbolVisibility visibility = SelectionVisibility.all((SymbolVisibility)SymbolVisibility.iupacRecommendations());
        Assert.assertTrue((boolean)visibility.visible(methyl.getAtom(0), methyl.getConnectedBondsList(methyl.getAtom(0)), new RendererModel()));
    }

    @Test
    public void isolated() {
        AtomContainer methyl = new AtomContainer();
        methyl.addAtom(SelectionVisibilityTest.atomAt("C", new Point2d(0.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, 1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, -1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(1.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(-1.0, 0.0)));
        methyl.addBond(0, 1, IBond.Order.SINGLE);
        methyl.addBond(0, 2, IBond.Order.SINGLE);
        methyl.addBond(0, 3, IBond.Order.SINGLE);
        methyl.addBond(0, 4, IBond.Order.SINGLE);
        methyl.getAtom(0).setProperty((Object)"stdgen.highlight.color", (Object)Color.RED);
        SymbolVisibility visibility = SelectionVisibility.disconnected((SymbolVisibility)SymbolVisibility.iupacRecommendations());
        Assert.assertTrue((boolean)visibility.visible(methyl.getAtom(0), methyl.getConnectedBondsList(methyl.getAtom(0)), new RendererModel()));
    }

    @Test
    public void unIsolated() {
        AtomContainer methyl = new AtomContainer();
        methyl.addAtom(SelectionVisibilityTest.atomAt("C", new Point2d(0.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, 1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(0.0, -1.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(1.0, 0.0)));
        methyl.addAtom(SelectionVisibilityTest.atomAt("H", new Point2d(-1.0, 0.0)));
        methyl.addBond(0, 1, IBond.Order.SINGLE);
        methyl.addBond(0, 2, IBond.Order.SINGLE);
        methyl.addBond(0, 3, IBond.Order.SINGLE);
        methyl.addBond(0, 4, IBond.Order.SINGLE);
        methyl.getAtom(0).setProperty((Object)"stdgen.highlight.color", (Object)Color.RED);
        methyl.getBond(0).setProperty((Object)"stdgen.highlight.color", (Object)Color.RED);
        SymbolVisibility visibility = SelectionVisibility.disconnected((SymbolVisibility)SymbolVisibility.iupacRecommendations());
        Assert.assertFalse((boolean)visibility.visible(methyl.getAtom(0), methyl.getConnectedBondsList(methyl.getAtom(0)), new RendererModel()));
    }

    @Test
    public void highlightIsSelected() {
        IChemObject chemObject = (IChemObject)Mockito.mock(IChemObject.class);
        Mockito.when((Object)chemObject.getProperty((Object)"stdgen.highlight.color")).thenReturn((Object)Color.RED);
        Assert.assertTrue((boolean)SelectionVisibility.isSelected((IChemObject)chemObject, (RendererModel)new RendererModel()));
    }

    static IAtom atomAt(String symb, Point2d p) {
        Atom atom = new Atom(symb);
        atom.setPoint2d(p);
        return atom;
    }
}

