/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.util.Map;
import javax.vecmath.Point2d;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.generators.standard.StandardBondGenerator;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.templates.TestMoleculeFactory;

public class StandardBondGeneratorTest {
    @Test
    public void adenineRingPreference() throws Exception {
        IAtomContainer adenine = TestMoleculeFactory.makeAdenine();
        Map ringMap = StandardBondGenerator.ringPreferenceMap((IAtomContainer)adenine);
        int nSize5 = 0;
        int nSize6 = 0;
        for (IBond bond : adenine.bonds()) {
            IAtomContainer ring = (IAtomContainer)ringMap.get(bond);
            if (ring == null) continue;
            int size = ring.getAtomCount();
            if (size == 5) {
                ++nSize5;
            }
            if (size != 6) continue;
            ++nSize6;
        }
        MatcherAssert.assertThat((Object)nSize5, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)nSize6, (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void metalRingPreference() throws Exception {
        SmilesParser smipar = new SmilesParser(SilentChemObjectBuilder.getInstance());
        IAtomContainer mol = smipar.parseSmiles("C1[Fe]C=CC2=C1C=CN2");
        for (IAtom atom : mol.atoms()) {
            atom.setPoint2d(new Point2d(0.0, 0.0));
        }
        Map ringMap = StandardBondGenerator.ringPreferenceMap((IAtomContainer)mol);
        int nSize5 = 0;
        int nSize6 = 0;
        for (IBond bond : mol.bonds()) {
            IAtomContainer ring = (IAtomContainer)ringMap.get(bond);
            if (ring == null) continue;
            int size = ring.getAtomCount();
            if (size == 5) {
                ++nSize5;
            }
            if (size != 6) continue;
            ++nSize6;
        }
        MatcherAssert.assertThat((Object)nSize5, (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)nSize6, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void ringSizePriority() {
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)6), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)5), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)7), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)4), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)3), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidRingSize() {
        StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)2);
    }

    @Test
    public void macroCycle() {
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)8), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)10), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.sizePreference((int)20), (Matcher)CoreMatchers.is((Object)20));
    }

    @Test
    public void benzeneDoubleBondCount() {
        MatcherAssert.assertThat((Object)StandardBondGenerator.RingBondOffsetComparator.nDoubleBonds((IAtomContainer)TestMoleculeFactory.makeBenzene()), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void benzeneElementCount() {
        int[] freq = StandardBondGenerator.RingBondOffsetComparator.countLightElements((IAtomContainer)TestMoleculeFactory.makeBenzene());
        MatcherAssert.assertThat((Object)freq[6], (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void highAtomicNoElementCount() {
        IAtomContainer container = TestMoleculeFactory.makeBenzene();
        container.getAtom(0).setAtomicNumber(Integer.valueOf(34));
        container.getAtom(0).setSymbol("Se");
        int[] freq = StandardBondGenerator.RingBondOffsetComparator.countLightElements((IAtomContainer)container);
        MatcherAssert.assertThat((Object)freq[6], (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void adenineElementCount() {
        int[] freq = StandardBondGenerator.RingBondOffsetComparator.countLightElements((IAtomContainer)TestMoleculeFactory.makeAdenine());
        MatcherAssert.assertThat((Object)freq[6], (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)freq[7], (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void benzeneComparedToPyrrole() {
        IAtomContainer benzene = TestMoleculeFactory.makeBenzene();
        IAtomContainer pyrrole = TestMoleculeFactory.makePyrrole();
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(benzene, pyrrole), (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(pyrrole, benzene), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void benzeneComparedToCycloHexane() {
        IAtomContainer benzene = TestMoleculeFactory.makeBenzene();
        IAtomContainer cyclohexane = TestMoleculeFactory.makeCyclohexane();
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(benzene, cyclohexane), (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(cyclohexane, benzene), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void benzeneComparedToCycloHexene() {
        IAtomContainer benzene = TestMoleculeFactory.makeBenzene();
        IAtomContainer cyclohexene = TestMoleculeFactory.makeCyclohexene();
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(benzene, cyclohexene), (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(cyclohexene, benzene), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void benzeneComparedToBenzene() {
        IAtomContainer benzene1 = TestMoleculeFactory.makeBenzene();
        IAtomContainer benzene2 = TestMoleculeFactory.makeBenzene();
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(benzene1, benzene2), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(benzene2, benzene1), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void benzeneComparedToPyridine() {
        IAtomContainer benzene = TestMoleculeFactory.makeBenzene();
        IAtomContainer pyridine = TestMoleculeFactory.makePyridine();
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(benzene, pyridine), (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(pyridine, benzene), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void furaneComparedToPyrrole() {
        IAtomContainer furane = TestMoleculeFactory.makePyrrole();
        IAtomContainer pyrrole = TestMoleculeFactory.makePyrrole();
        assert (furane.getAtom(1).getAtomicNumber() == 7);
        furane.getAtom(1).setAtomicNumber(Integer.valueOf(8));
        furane.getAtom(1).setSymbol("O");
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(pyrrole, furane), (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(furane, pyrrole), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void furaneComparedToThiophene() {
        IAtomContainer furane = TestMoleculeFactory.makePyrrole();
        IAtomContainer thiophene = TestMoleculeFactory.makePyrrole();
        assert (furane.getAtom(1).getAtomicNumber() == 7);
        assert (thiophene.getAtom(1).getAtomicNumber() == 7);
        furane.getAtom(1).setAtomicNumber(Integer.valueOf(8));
        furane.getAtom(1).setSymbol("O");
        thiophene.getAtom(1).setAtomicNumber(Integer.valueOf(16));
        thiophene.getAtom(1).setSymbol("S");
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(furane, thiophene), (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)new StandardBondGenerator.RingBondOffsetComparator().compare(thiophene, furane), (Matcher)CoreMatchers.is((Object)1));
    }
}

