/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.number.IsCloseTo;
import org.junit.Ignore;
import org.junit.Test;
import org.openscience.cdk.renderer.generators.standard.TextOutline;

public class TextOutlineTest {
    private final Font font = new Font("Verdana", 0, 12);

    @Test
    public void getOutline() throws Exception {
    }

    @Ignore(value="Font bounds vary between systems")
    public void untransformedBounds() throws Exception {
        TextOutline clOutline = new TextOutline("Cl", this.font);
        Rectangle2D bounds = clOutline.getBounds();
        MatcherAssert.assertThat((Object)bounds.getX(), (Matcher)IsCloseTo.closeTo((double)0.67, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getY(), (Matcher)IsCloseTo.closeTo((double)-9.12, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getWidth(), (Matcher)IsCloseTo.closeTo((double)9.9, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getHeight(), (Matcher)IsCloseTo.closeTo((double)9.28, (double)0.01));
    }

    @Test
    public void boundsTransformedWithXTranslation() throws Exception {
        TextOutline original = new TextOutline("Cl", this.font);
        TextOutline transformed = original.translate(5.0, 0.0);
        Rectangle2D oBounds = original.getBounds();
        Rectangle2D tBounds = transformed.getBounds();
        MatcherAssert.assertThat((Object)tBounds.getX(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getX() + 5.0), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getY(), (Matcher)IsCloseTo.closeTo((double)oBounds.getY(), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getWidth(), (Matcher)IsCloseTo.closeTo((double)oBounds.getWidth(), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getHeight(), (Matcher)IsCloseTo.closeTo((double)oBounds.getHeight(), (double)0.01));
    }

    @Test
    public void boundsTransformedWithYTranslation() throws Exception {
        TextOutline original = new TextOutline("Cl", this.font);
        TextOutline transformed = original.translate(0.0, -5.0);
        Rectangle2D oBounds = original.getBounds();
        Rectangle2D tBounds = transformed.getBounds();
        MatcherAssert.assertThat((Object)tBounds.getX(), (Matcher)IsCloseTo.closeTo((double)oBounds.getX(), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getY(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getY() - 5.0), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getWidth(), (Matcher)IsCloseTo.closeTo((double)oBounds.getWidth(), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getHeight(), (Matcher)IsCloseTo.closeTo((double)oBounds.getHeight(), (double)0.01));
    }

    @Ignore(value="Font bounds vary between systems")
    public void untransformedCenter() throws Exception {
        TextOutline clOutline = new TextOutline("Cl", this.font);
        Point2D center = clOutline.getCenter();
        MatcherAssert.assertThat((Object)center.getX(), (Matcher)IsCloseTo.closeTo((double)5.62, (double)0.01));
        MatcherAssert.assertThat((Object)center.getY(), (Matcher)IsCloseTo.closeTo((double)-4.47, (double)0.01));
    }

    @Test
    public void transformedCenter() throws Exception {
        TextOutline original = new TextOutline("Cl", this.font);
        TextOutline transformed = original.translate(0.0, -5.0);
        Point2D oCenter = original.getCenter();
        Point2D tCenter = transformed.getCenter();
        MatcherAssert.assertThat((Object)tCenter.getX(), (Matcher)IsCloseTo.closeTo((double)oCenter.getX(), (double)0.01));
        MatcherAssert.assertThat((Object)tCenter.getY(), (Matcher)IsCloseTo.closeTo((double)(oCenter.getY() - 5.0), (double)0.01));
    }

    @Test
    public void testGetFirstGlyphCenter() throws Exception {
        TextOutline original = new TextOutline("Cl", this.font);
        Point2D oCenter = original.getCenter();
        Point2D tCenter = original.getFirstGlyphCenter();
        MatcherAssert.assertThat((Object)tCenter.getX(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(oCenter.getX())));
    }

    @Test
    public void testGetLastGlyphCenter() throws Exception {
        TextOutline original = new TextOutline("Cl", this.font);
        Point2D oCenter = original.getCenter();
        Point2D tCenter = original.getLastGlyphCenter();
        MatcherAssert.assertThat((Object)tCenter.getX(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(oCenter.getX())));
    }

    @Test
    public void resizeModifiesBounds() throws Exception {
        TextOutline original = new TextOutline("Cl", this.font);
        TextOutline transformed = original.resize(2.0, 2.0);
        Rectangle2D oBounds = original.getBounds();
        Rectangle2D tBounds = transformed.getBounds();
        MatcherAssert.assertThat((Object)tBounds.getX(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getX() - oBounds.getWidth() / 2.0), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getY(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getY() - oBounds.getHeight() / 2.0), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getWidth(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getWidth() * 2.0), (double)0.01));
        MatcherAssert.assertThat((Object)tBounds.getHeight(), (Matcher)IsCloseTo.closeTo((double)(oBounds.getHeight() * 2.0), (double)0.01));
    }

    @Test
    public void resizeMaintainsCenter() throws Exception {
        TextOutline clOutline = new TextOutline("Cl", this.font);
        Point2D orgCenter = clOutline.getCenter();
        Point2D newCenter = clOutline.resize(21.0, 5.0).getCenter();
        MatcherAssert.assertThat((Object)orgCenter.getX(), (Matcher)IsCloseTo.closeTo((double)newCenter.getX(), (double)0.01));
        MatcherAssert.assertThat((Object)orgCenter.getY(), (Matcher)IsCloseTo.closeTo((double)newCenter.getY(), (double)0.01));
    }

    @Test
    public void firstAndLastCenterIsTheSameForSingleLetterOutline() throws Exception {
        TextOutline oOutline = new TextOutline("O", this.font);
        Point2D firstCenter = oOutline.getFirstGlyphCenter();
        Point2D lastCenter = oOutline.getLastGlyphCenter();
        MatcherAssert.assertThat((Object)firstCenter.getX(), (Matcher)IsCloseTo.closeTo((double)lastCenter.getX(), (double)0.01));
        MatcherAssert.assertThat((Object)firstCenter.getY(), (Matcher)IsCloseTo.closeTo((double)lastCenter.getY(), (double)0.01));
    }

    @Test
    public void testToString() throws Exception {
        TextOutline outline = new TextOutline("Cl", this.font);
        Rectangle2D bounds = outline.getBounds();
        MatcherAssert.assertThat((Object)outline.toString(), (Matcher)CoreMatchers.is((Object)("Cl [x=" + TextOutlineTest.toString(bounds.getX()) + ", y=" + TextOutlineTest.toString(bounds.getY()) + ", w=" + TextOutlineTest.toString(bounds.getWidth()) + ", h=" + TextOutlineTest.toString(bounds.getHeight()) + "]")));
    }

    static String toString(double x) {
        return String.format("%.2f", x);
    }
}

