/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.IsCloseTo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.generators.standard.VecmathUtil;

public class VecmathUtilTest {
    @Test
    public void testToAwtPoint() throws Exception {
        Point2D p = VecmathUtil.toAwtPoint((Point2d)new Point2d(4.0, 2.0));
        MatcherAssert.assertThat((Object)p.getX(), (Matcher)IsCloseTo.closeTo((double)4.0, (double)0.01));
        MatcherAssert.assertThat((Object)p.getY(), (Matcher)IsCloseTo.closeTo((double)2.0, (double)0.01));
    }

    @Test
    public void testToVecmathPoint() throws Exception {
        Point2d p = VecmathUtil.toVecmathPoint((Point2D)new Point2D.Double(4.0, 2.0));
        MatcherAssert.assertThat((Object)p.x, (Matcher)IsCloseTo.closeTo((double)4.0, (double)0.01));
        MatcherAssert.assertThat((Object)p.y, (Matcher)IsCloseTo.closeTo((double)2.0, (double)0.01));
    }

    @Test
    public void testNewUnitVector() throws Exception {
        Vector2d unit = VecmathUtil.newUnitVector((Tuple2d)new Point2d(4.0, 2.0), (Tuple2d)new Point2d(6.0, 7.0));
        MatcherAssert.assertThat((Object)unit.x, (Matcher)IsCloseTo.closeTo((double)0.371, (double)0.01));
        MatcherAssert.assertThat((Object)unit.y, (Matcher)IsCloseTo.closeTo((double)0.928, (double)0.01));
        MatcherAssert.assertThat((Object)unit.length(), (Matcher)IsCloseTo.closeTo((double)1.0, (double)0.01));
    }

    @Test
    public void testNewUnitVectorFromBond() throws Exception {
        IAtom a1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom a2 = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)a1.getPoint2d()).thenReturn((Object)new Point2d(0.0, 1.0));
        Mockito.when((Object)a2.getPoint2d()).thenReturn((Object)new Point2d(1.0, 0.0));
        IBond bond = (IBond)Mockito.mock(IBond.class);
        Mockito.when((Object)bond.getOther(a1)).thenReturn((Object)a2);
        Mockito.when((Object)bond.getOther(a2)).thenReturn((Object)a1);
        Vector2d unit = VecmathUtil.newUnitVector((IAtom)a1, (IBond)bond);
        MatcherAssert.assertThat((Object)unit.x, (Matcher)IsCloseTo.closeTo((double)0.707, (double)0.01));
        MatcherAssert.assertThat((Object)unit.y, (Matcher)IsCloseTo.closeTo((double)-0.707, (double)0.01));
        MatcherAssert.assertThat((Object)unit.length(), (Matcher)IsCloseTo.closeTo((double)1.0, (double)0.01));
    }

    @Test
    public void testNewUnitVectors() throws Exception {
        IAtom fromAtom = (IAtom)Mockito.mock(IAtom.class);
        IAtom toAtom1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom toAtom2 = (IAtom)Mockito.mock(IAtom.class);
        IAtom toAtom3 = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)fromAtom.getPoint2d()).thenReturn((Object)new Point2d(4.0, 2.0));
        Mockito.when((Object)toAtom1.getPoint2d()).thenReturn((Object)new Point2d(-5.0, 3.0));
        Mockito.when((Object)toAtom2.getPoint2d()).thenReturn((Object)new Point2d(6.0, -4.0));
        Mockito.when((Object)toAtom3.getPoint2d()).thenReturn((Object)new Point2d(7.0, 5.0));
        List vectors = VecmathUtil.newUnitVectors((IAtom)fromAtom, Arrays.asList(toAtom1, toAtom2, toAtom3));
        MatcherAssert.assertThat((Object)vectors.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((Vector2d)vectors.get((int)0)).x, (Matcher)IsCloseTo.closeTo((double)-0.993, (double)0.01));
        MatcherAssert.assertThat((Object)((Vector2d)vectors.get((int)0)).y, (Matcher)IsCloseTo.closeTo((double)0.11, (double)0.01));
        MatcherAssert.assertThat((Object)((Vector2d)vectors.get((int)1)).x, (Matcher)IsCloseTo.closeTo((double)0.316, (double)0.01));
        MatcherAssert.assertThat((Object)((Vector2d)vectors.get((int)1)).y, (Matcher)IsCloseTo.closeTo((double)-0.948, (double)0.01));
        MatcherAssert.assertThat((Object)((Vector2d)vectors.get((int)2)).x, (Matcher)IsCloseTo.closeTo((double)0.707, (double)0.01));
        MatcherAssert.assertThat((Object)((Vector2d)vectors.get((int)2)).y, (Matcher)IsCloseTo.closeTo((double)0.707, (double)0.01));
    }

    @Test
    public void testNewPerpendicularVector() throws Exception {
        Vector2d perpendicular = VecmathUtil.newPerpendicularVector((Vector2d)new Vector2d(5.0, 2.0));
        MatcherAssert.assertThat((Object)perpendicular.x, (Matcher)IsCloseTo.closeTo((double)-2.0, (double)0.01));
        MatcherAssert.assertThat((Object)perpendicular.y, (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
    }

    @Test
    public void testScale() throws Exception {
        Vector2d vector = VecmathUtil.scale((Tuple2d)new Vector2d(4.0, 2.0), (double)2.5);
        MatcherAssert.assertThat((Object)vector.x, (Matcher)IsCloseTo.closeTo((double)10.0, (double)0.01));
        MatcherAssert.assertThat((Object)vector.y, (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
    }

    @Test
    public void testSum() throws Exception {
        Vector2d vector = VecmathUtil.sum((Tuple2d)new Vector2d(4.0, 2.0), (Tuple2d)new Vector2d(2.0, 5.0));
        MatcherAssert.assertThat((Object)vector.x, (Matcher)IsCloseTo.closeTo((double)6.0, (double)0.01));
        MatcherAssert.assertThat((Object)vector.y, (Matcher)IsCloseTo.closeTo((double)7.0, (double)0.01));
    }

    @Test
    public void testNegate() throws Exception {
        Vector2d vector = VecmathUtil.negate((Tuple2d)new Vector2d(4.0, 2.0));
        MatcherAssert.assertThat((Object)vector.x, (Matcher)IsCloseTo.closeTo((double)-4.0, (double)0.01));
        MatcherAssert.assertThat((Object)vector.y, (Matcher)IsCloseTo.closeTo((double)-2.0, (double)0.01));
    }

    @Test
    public void testAdjacentLength() throws Exception {
        double length = VecmathUtil.adjacentLength((Vector2d)new Vector2d(2.0, 4.0), (Vector2d)new Vector2d(9.0, 4.0), (double)6.0);
        MatcherAssert.assertThat((Object)length, (Matcher)IsCloseTo.closeTo((double)4.94, (double)0.01));
    }

    @Test
    public void testAverage() throws Exception {
        Vector2d mean = VecmathUtil.average(Arrays.asList(new Vector2d(0.5, 0.5), new Vector2d(0.5, -0.5)));
        MatcherAssert.assertThat((Object)mean.x, (Matcher)IsCloseTo.closeTo((double)0.5, (double)0.01));
        MatcherAssert.assertThat((Object)mean.y, (Matcher)IsCloseTo.closeTo((double)0.0, (double)0.01));
    }

    @Test
    public void testGetNearestVector1() throws Exception {
        Vector2d nearest = VecmathUtil.getNearestVector((Vector2d)new Vector2d(0.0, 1.0), Arrays.asList(new Vector2d(0.5, 0.5), new Vector2d(0.5, -0.5)));
        MatcherAssert.assertThat((Object)nearest.x, (Matcher)IsCloseTo.closeTo((double)0.5, (double)0.01));
        MatcherAssert.assertThat((Object)nearest.y, (Matcher)IsCloseTo.closeTo((double)0.5, (double)0.01));
    }

    @Test
    public void testGetNearestVector2() throws Exception {
        Vector2d nearest = VecmathUtil.getNearestVector((Vector2d)new Vector2d(0.0, -1.0), Arrays.asList(new Vector2d(0.5, 0.5), new Vector2d(0.5, -0.5)));
        MatcherAssert.assertThat((Object)nearest.x, (Matcher)IsCloseTo.closeTo((double)0.5, (double)0.01));
        MatcherAssert.assertThat((Object)nearest.y, (Matcher)IsCloseTo.closeTo((double)-0.5, (double)0.01));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNearestVectorComplainsWhenNoVectorsProvided() throws Exception {
        VecmathUtil.getNearestVector((Vector2d)new Vector2d(1.0, 0.0), Collections.emptyList());
    }

    @Test
    public void testGetNearestVectorFromBonds() throws Exception {
        IAtom a1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom a2 = (IAtom)Mockito.mock(IAtom.class);
        IAtom a3 = (IAtom)Mockito.mock(IAtom.class);
        IAtom a4 = (IAtom)Mockito.mock(IAtom.class);
        IBond b1 = (IBond)Mockito.mock(IBond.class);
        IBond b2 = (IBond)Mockito.mock(IBond.class);
        IBond b3 = (IBond)Mockito.mock(IBond.class);
        Mockito.when((Object)b1.getOther(a1)).thenReturn((Object)a2);
        Mockito.when((Object)b2.getOther(a1)).thenReturn((Object)a3);
        Mockito.when((Object)b3.getOther(a1)).thenReturn((Object)a4);
        Mockito.when((Object)a1.getPoint2d()).thenReturn((Object)new Point2d(0.0, 0.0));
        Mockito.when((Object)a2.getPoint2d()).thenReturn((Object)new Point2d(0.0, 1.0));
        Mockito.when((Object)a3.getPoint2d()).thenReturn((Object)new Point2d(1.0, 0.0));
        Mockito.when((Object)a4.getPoint2d()).thenReturn((Object)new Point2d(1.0, 1.0));
        Vector2d nearest = VecmathUtil.getNearestVector((Vector2d)new Vector2d(0.5, 0.5), (IAtom)a1, Arrays.asList(b1, b2, b3));
        MatcherAssert.assertThat((Object)nearest.x, (Matcher)IsCloseTo.closeTo((double)0.707, (double)0.01));
        MatcherAssert.assertThat((Object)nearest.y, (Matcher)IsCloseTo.closeTo((double)0.707, (double)0.01));
    }

    @Test
    public void intersection1() {
        Point2d intersect = VecmathUtil.intersection((Tuple2d)new Point2d(1.0, 1.0), (Tuple2d)new Vector2d(0.0, 1.0), (Tuple2d)new Point2d(1.0, 0.0), (Tuple2d)new Vector2d(1.0, 0.0));
        MatcherAssert.assertThat((Object)intersect.x, (Matcher)IsCloseTo.closeTo((double)1.0, (double)0.01));
        MatcherAssert.assertThat((Object)intersect.y, (Matcher)IsCloseTo.closeTo((double)0.0, (double)0.01));
    }

    @Test
    public void intersection2() {
        Point2d intersect = VecmathUtil.intersection((Tuple2d)new Point2d(6.0, 1.0), (Tuple2d)new Vector2d(-4.0, -2.0), (Tuple2d)new Point2d(1.0, 6.0), (Tuple2d)new Vector2d(2.0, 4.0));
        MatcherAssert.assertThat((Object)intersect.x, (Matcher)IsCloseTo.closeTo((double)-4.0, (double)0.01));
        MatcherAssert.assertThat((Object)intersect.y, (Matcher)IsCloseTo.closeTo((double)-4.0, (double)0.01));
    }

    @Test
    public void parallelLines() {
        Point2d intersect = VecmathUtil.intersection((Tuple2d)new Point2d(0.0, 1.0), (Tuple2d)new Vector2d(0.0, 1.0), (Tuple2d)new Point2d(0.0, -1.0), (Tuple2d)new Vector2d(0.0, 1.0));
        Assert.assertTrue((boolean)Double.isNaN(intersect.x));
        Assert.assertTrue((boolean)Double.isNaN(intersect.y));
    }

    @Test
    public void sweepEast() {
        MatcherAssert.assertThat((Object)VecmathUtil.extent((Vector2d)new Vector2d(1.0, 0.0)), (Matcher)CoreMatchers.is((Matcher)IsCloseTo.closeTo((double)Math.toRadians(0.0), (double)0.01)));
    }

    @Test
    public void sweepNorth() {
        MatcherAssert.assertThat((Object)VecmathUtil.extent((Vector2d)new Vector2d(0.0, 1.0)), (Matcher)CoreMatchers.is((Matcher)IsCloseTo.closeTo((double)Math.toRadians(90.0), (double)0.01)));
    }

    @Test
    public void sweepWest() {
        MatcherAssert.assertThat((Object)VecmathUtil.extent((Vector2d)new Vector2d(-1.0, 0.0)), (Matcher)CoreMatchers.is((Matcher)IsCloseTo.closeTo((double)Math.toRadians(180.0), (double)0.01)));
    }

    @Test
    public void sweepSouth() {
        MatcherAssert.assertThat((Object)VecmathUtil.extent((Vector2d)new Vector2d(0.0, -1.0)), (Matcher)CoreMatchers.is((Matcher)IsCloseTo.closeTo((double)Math.toRadians(270.0), (double)0.01)));
    }

    @Test
    public void largestGapSouthWest() {
        Vector2d vector = VecmathUtil.newVectorInLargestGap(Arrays.asList(new Vector2d(0.0, 1.0), new Vector2d(1.0, 0.0)));
        MatcherAssert.assertThat((Object)vector.x, (Matcher)IsCloseTo.closeTo((double)-0.707, (double)0.01));
        MatcherAssert.assertThat((Object)vector.y, (Matcher)IsCloseTo.closeTo((double)-0.707, (double)0.01));
        MatcherAssert.assertThat((Object)vector.length(), (Matcher)IsCloseTo.closeTo((double)1.0, (double)0.01));
    }

    @Test
    public void largestGapEast() {
        Vector2d vector = VecmathUtil.newVectorInLargestGap(Arrays.asList(new Vector2d(1.0, 1.0), new Vector2d(1.0, -1.0), new Vector2d(-1.0, -1.0), new Vector2d(-1.0, 1.0), new Vector2d(-1.0, 0.0), new Vector2d(0.0, 1.0), new Vector2d(0.0, -1.0)));
        MatcherAssert.assertThat((Object)vector.x, (Matcher)IsCloseTo.closeTo((double)1.0, (double)0.01));
        MatcherAssert.assertThat((Object)vector.y, (Matcher)IsCloseTo.closeTo((double)0.0, (double)0.01));
        MatcherAssert.assertThat((Object)vector.length(), (Matcher)IsCloseTo.closeTo((double)1.0, (double)0.01));
    }
}

