/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.SymbolVisibility;

public final class SelectionVisibility
extends SymbolVisibility {
    private final SymbolVisibility delegate;
    private final boolean showAll;

    private SelectionVisibility(SymbolVisibility delegate, boolean showAll) {
        this.delegate = delegate;
        this.showAll = showAll;
    }

    public static SymbolVisibility disconnected(SymbolVisibility visibility) {
        return new SelectionVisibility(visibility, false);
    }

    public static SymbolVisibility all(SymbolVisibility visibility) {
        return new SelectionVisibility(visibility, true);
    }

    public boolean visible(IAtom atom, List<IBond> neighbors, RendererModel model) {
        if (SelectionVisibility.isSelected((IChemObject)atom, model) && (this.showAll || !SelectionVisibility.hasSelectedBond(neighbors, model))) {
            return true;
        }
        return this.delegate.visible(atom, neighbors, model);
    }

    static boolean isSelected(IChemObject object, RendererModel model) {
        if (object.getProperty((Object)"stdgen.highlight.color") != null) {
            return true;
        }
        if (model.getSelection() != null) {
            return model.getSelection().contains(object);
        }
        return false;
    }

    static boolean hasSelectedBond(List<IBond> bonds, RendererModel model) {
        for (IBond bond : bonds) {
            if (!SelectionVisibility.isSelected((IChemObject)bond, model)) continue;
            return true;
        }
        return false;
    }
}

