/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.appsensor.analysis;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.owasp.appsensor.core.AppSensorServer;
import org.owasp.appsensor.core.Attack;
import org.owasp.appsensor.core.DetectionPoint;
import org.owasp.appsensor.core.Interval;
import org.owasp.appsensor.core.Response;
import org.owasp.appsensor.core.analysis.AttackAnalysisEngine;
import org.owasp.appsensor.core.criteria.SearchCriteria;
import org.owasp.appsensor.core.logging.Loggable;
import org.slf4j.Logger;

@Named
@Loggable
public class ReferenceAttackAnalysisEngine
extends AttackAnalysisEngine {
    private Logger logger;
    @Inject
    private AppSensorServer appSensorServer;

    public void analyze(Attack attack) {
        Response response;
        if (attack != null && attack.getDetectionPoint() != null && (response = this.findAppropriateResponse(attack)) != null) {
            this.logger.info("Response set for user <" + attack.getUser().getUsername() + "> - storing response action " + response.getAction());
            this.appSensorServer.getResponseStore().addResponse(response);
        }
    }

    protected Response findAppropriateResponse(Attack attack) {
        Object response;
        DetectionPoint triggeringDetectionPoint = attack.getDetectionPoint();
        SearchCriteria criteria = new SearchCriteria().setUser(attack.getUser()).setDetectionPoint(triggeringDetectionPoint).setDetectionSystemIds(this.appSensorServer.getConfiguration().getRelatedDetectionSystems(attack.getDetectionSystem()));
        Collection existingResponses = this.appSensorServer.getResponseStore().findResponses(criteria);
        String responseAction = null;
        Interval interval = null;
        Collection<Response> possibleResponses = this.findPossibleResponses(triggeringDetectionPoint);
        if (existingResponses == null || existingResponses.size() == 0) {
            response = possibleResponses.iterator().next();
            responseAction = response.getAction();
            interval = response.getInterval();
        } else {
            for (Response configuredResponse : possibleResponses) {
                responseAction = configuredResponse.getAction();
                interval = configuredResponse.getInterval();
                if (this.isPreviousResponse(configuredResponse, existingResponses)) continue;
                break;
            }
        }
        if (responseAction == null) {
            throw new IllegalArgumentException("No appropriate response was configured for this detection point: " + triggeringDetectionPoint.getLabel());
        }
        response = new Response();
        response.setUser(attack.getUser());
        response.setTimestamp(attack.getTimestamp());
        response.setAction(responseAction);
        response.setInterval(interval);
        response.setDetectionSystem(attack.getDetectionSystem());
        return response;
    }

    protected Collection<Response> findPossibleResponses(DetectionPoint triggeringDetectionPoint) {
        Collection<Object> possibleResponses = new ArrayList<Response>();
        for (DetectionPoint configuredDetectionPoint : this.appSensorServer.getConfiguration().getDetectionPoints()) {
            if (!configuredDetectionPoint.typeAndThresholdMatches(triggeringDetectionPoint)) continue;
            possibleResponses = configuredDetectionPoint.getResponses();
            break;
        }
        return possibleResponses;
    }

    protected boolean isPreviousResponse(Response response, Collection<Response> existingResponses) {
        boolean previousResponse = false;
        for (Response existingResponse : existingResponses) {
            if (!response.getAction().equals(existingResponse.getAction())) continue;
            previousResponse = true;
        }
        return previousResponse;
    }
}

