/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.appsensor.analysis;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.owasp.appsensor.core.AppSensorServer;
import org.owasp.appsensor.core.Attack;
import org.owasp.appsensor.core.DetectionPoint;
import org.owasp.appsensor.core.Event;
import org.owasp.appsensor.core.analysis.EventAnalysisEngine;
import org.owasp.appsensor.core.criteria.SearchCriteria;
import org.owasp.appsensor.core.logging.Loggable;
import org.owasp.appsensor.core.util.DateUtils;
import org.slf4j.Logger;

@Named
@Loggable
public class ReferenceEventAnalysisEngine
extends EventAnalysisEngine {
    private Logger logger;
    @Inject
    private AppSensorServer appSensorServer;

    public void analyze(Event event) {
        SearchCriteria criteria = new SearchCriteria().setUser(event.getUser()).setDetectionPoint(event.getDetectionPoint()).setDetectionSystemIds(this.appSensorServer.getConfiguration().getRelatedDetectionSystems(event.getDetectionSystem()));
        Collection existingEvents = this.appSensorServer.getEventStore().findEvents(criteria);
        Collection configuredDetectionPoints = this.appSensorServer.getConfiguration().findDetectionPoints(event.getDetectionPoint(), event.getDetectionSystem().getDetectionSystemId());
        if (configuredDetectionPoints.size() > 0) {
            for (DetectionPoint configuredDetectionPoint : configuredDetectionPoints) {
                int thresholdCount;
                int eventCount = this.countEvents(existingEvents, event, configuredDetectionPoint);
                if (eventCount == 0) {
                    eventCount = 1;
                }
                if (eventCount % (thresholdCount = configuredDetectionPoint.getThreshold().getCount()) != 0) continue;
                this.logger.info("Violation Observed for user <" + event.getUser().getUsername() + "> - storing attack");
                Attack attack = new Attack(event.getUser(), configuredDetectionPoint, event.getTimestamp(), event.getDetectionSystem(), event.getResource());
                this.appSensorServer.getAttackStore().addAttack(attack);
            }
        } else {
            this.logger.error("Could not find detection point configured for this type: " + event.getDetectionPoint().getLabel());
        }
    }

    protected int countEvents(Collection<Event> existingEvents, Event triggeringEvent, DetectionPoint configuredDetectionPoint) {
        int count = 0;
        long intervalInMillis = configuredDetectionPoint.getThreshold().getInterval().toMillis();
        DateTime startTime = DateUtils.getCurrentTimestamp().minusMillis((int)intervalInMillis);
        DateTime mostRecentAttackTime = this.findMostRecentAttackTime(triggeringEvent, configuredDetectionPoint);
        for (Event event : existingEvents) {
            DateTime eventTimestamp = DateUtils.fromString((String)event.getTimestamp());
            if (!eventTimestamp.isAfter((ReadableInstant)mostRecentAttackTime)) continue;
            if (intervalInMillis > 0L) {
                if (!DateUtils.fromString((String)event.getTimestamp()).isAfter((ReadableInstant)startTime)) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    protected DateTime findMostRecentAttackTime(Event event, DetectionPoint configuredDetectionPoint) {
        DateTime newest = DateUtils.epoch();
        SearchCriteria criteria = new SearchCriteria().setUser(event.getUser()).setDetectionPoint(configuredDetectionPoint).setDetectionSystemIds(this.appSensorServer.getConfiguration().getRelatedDetectionSystems(event.getDetectionSystem()));
        Collection attacks = this.appSensorServer.getAttackStore().findAttacks(criteria);
        for (Attack attack : attacks) {
            if (!DateUtils.fromString((String)attack.getTimestamp()).isAfter((ReadableInstant)newest)) continue;
            newest = DateUtils.fromString((String)attack.getTimestamp());
        }
        return newest;
    }
}

