/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import org.qstd.dbtype.DatabaseType;

class ColumnValueFormatter {
    static final ColumnValueFormatter INSTANCE = new ColumnValueFormatter();

    private ColumnValueFormatter() {
    }

    String formatColumnValue(Object columnValue, DatabaseType dbType) {
        if (columnValue == null) {
            return "NULL";
        }
        if (DatabaseType.ORACLE.equals((Object)dbType) && columnValue instanceof Timestamp) {
            Timestamp timeStamp = (Timestamp)columnValue;
            return this.buildOracleToDateFunctionFor(timeStamp);
        }
        if (DatabaseType.ORACLE.equals((Object)dbType) && this.isOracleSqlTimestamp(columnValue)) {
            return this.buildOracleToTimeStampFunctionFor(columnValue);
        }
        if (DatabaseType.HSQLDB.equals((Object)dbType) && columnValue instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)columnValue;
            return this.formatForHsqlDBOffsetDateTime(offsetDateTime);
        }
        if (columnValue instanceof String || columnValue instanceof Date || columnValue instanceof Timestamp || columnValue instanceof Time || columnValue instanceof OffsetTime || this.isTimestampWithTimeZoneH2Type(columnValue) || this.isMicrosoftDateTimeOffset(columnValue)) {
            String stringColumnValue = columnValue.toString();
            return "'" + stringColumnValue + "'";
        }
        return columnValue.toString();
    }

    private boolean isMicrosoftDateTimeOffset(Object columnValue) {
        Class<?> columnValueClass = columnValue.getClass();
        String classCanonicalName = columnValueClass.getCanonicalName();
        return "microsoft.sql.DateTimeOffset".equals(classCanonicalName);
    }

    private String formatForHsqlDBOffsetDateTime(OffsetDateTime offsetDateTime) {
        DateTimeFormatter fmt = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").parseLenient().appendOffset("+HH:MM", "Z").toFormatter();
        return "'" + fmt.format(offsetDateTime) + "'";
    }

    private String buildOracleToDateFunctionFor(Timestamp timeStamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timeStamp);
        int monthNumber = calendar.get(2) + 1;
        int secondNumber = calendar.get(13);
        String toDateString = calendar.get(1) + "-" + (monthNumber < 10 ? "0" : "") + monthNumber + "-" + calendar.get(5) + "-" + calendar.get(11) + "-" + calendar.get(12) + "-" + (secondNumber < 10 ? "0" : "") + secondNumber;
        return "TO_DATE('" + toDateString + "', 'yyyy-mm-dd-HH24-mi-ss')";
    }

    private boolean isOracleSqlTimestamp(Object columnValue) {
        Class<?> columnValueClass = columnValue.getClass();
        String classCanonicalName = columnValueClass.getCanonicalName();
        return classCanonicalName.equals("oracle.sql.TIMESTAMP");
    }

    private String buildOracleToTimeStampFunctionFor(Object columnValue) {
        String oracleTimeStampAsString = columnValue.toString();
        String aDateWithMsLessThan100 = "2012-09-17 19:56:47.10";
        boolean dateHasMsLessThan100 = oracleTimeStampAsString.length() == aDateWithMsLessThan100.length();
        String dateForTimeStampCreation = dateHasMsLessThan100 ? oracleTimeStampAsString + "0" : oracleTimeStampAsString;
        return "TO_TIMESTAMP('" + dateForTimeStampCreation + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    private boolean isTimestampWithTimeZoneH2Type(Object columnValue) {
        Class<?> columnValueClass = columnValue.getClass();
        String classCanonicalName = columnValueClass.getCanonicalName();
        return classCanonicalName.equals("org.h2.api.TimestampWithTimeZone");
    }
}

