/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qstd.ColumnMappingPart;
import org.qstd.ColumnNamesComparator;
import org.qstd.ColumnsMappingGroup;

public class DatasetRow {
    private String tableName;
    private TreeMap<String, Object> columnValueByColumnName = new TreeMap();

    private DatasetRow(String tableName) {
        this.tableName = tableName;
    }

    public static DatasetRow ofTable(String tableName) {
        return new DatasetRow(tableName);
    }

    protected void addColumnValues(Map<String, Object> columnValues) {
        this.columnValueByColumnName.putAll(columnValues);
    }

    Set<String> getColumnNames() {
        return this.columnValueByColumnName.keySet();
    }

    Collection<Object> getColumnValues() {
        return this.columnValueByColumnName.values();
    }

    Map<String, Object> getColumnValueByColumnName() {
        return new HashMap<String, Object>(this.columnValueByColumnName);
    }

    boolean hasNotNullValueForColumn(String columnName) {
        return this.columnValueByColumnName.get(columnName) != null;
    }

    void sortColumnsFollowing(List<String> databaseColumnOrders) {
        if (!databaseColumnOrders.isEmpty()) {
            ColumnNamesComparator columnNamesComparator = ColumnNamesComparator.from(databaseColumnOrders);
            TreeMap<String, Object> columnValueByColumnName = new TreeMap<String, Object>(columnNamesComparator);
            columnValueByColumnName.putAll(this.columnValueByColumnName);
            this.columnValueByColumnName = columnValueByColumnName;
        }
    }

    boolean mergeWithARowOf(Collection<DatasetRow> datasetRows) {
        Optional<DatasetRow> optionalRowToMergeWith = this.searchARowToMergeIn(datasetRows);
        if (optionalRowToMergeWith.isPresent()) {
            DatasetRow rowToMergeWith = optionalRowToMergeWith.get();
            rowToMergeWith.addValuesOf(this);
            return true;
        }
        return false;
    }

    private Optional<DatasetRow> searchARowToMergeIn(Collection<DatasetRow> datasetRows) {
        return datasetRows.stream().filter(this::isMergeableWith).findFirst();
    }

    void addValuesOf(DatasetRow datasetRow) {
        TreeMap<String, Object> columnValueByColumnName = datasetRow.columnValueByColumnName;
        for (Map.Entry<String, Object> columnValueOfColumnName : columnValueByColumnName.entrySet()) {
            Object value = columnValueOfColumnName.getValue();
            if (value == null) continue;
            String columnName = columnValueOfColumnName.getKey();
            this.columnValueByColumnName.put(columnName, value);
        }
    }

    boolean isMergeableWith(DatasetRow otherDatasetRow) {
        if (!this.tableName.equals(otherDatasetRow.getTableName())) {
            return false;
        }
        return this.sameNotNullColumns(otherDatasetRow);
    }

    String getTableName() {
        return this.tableName;
    }

    private boolean sameNotNullColumns(DatasetRow otherDatasetRow) {
        TreeMap<String, Object> columnValueByColumnName = otherDatasetRow.columnValueByColumnName;
        for (Map.Entry<String, Object> columnValueOfColumnName : columnValueByColumnName.entrySet()) {
            String column;
            Object value;
            Object mergeableValue = columnValueOfColumnName.getValue();
            if (mergeableValue == null || mergeableValue.equals(value = this.columnValueByColumnName.get(column = columnValueOfColumnName.getKey())) || value == null) continue;
            return false;
        }
        return true;
    }

    Collection<DatasetRow> extractJoinedRowsFrom(ColumnsMappingGroup columnsMappingGroup) {
        return this.columnValueByColumnName.entrySet().stream().map(valueForColumn -> {
            String column = (String)valueForColumn.getKey();
            Optional<ColumnMappingPart> optionalMappingForColumn = columnsMappingGroup.findMappingForColumn(column);
            return this.buildOptionalRowFrom((Map.Entry<String, Object>)valueForColumn, optionalMappingForColumn);
        }).flatMap(DatasetRow::streamOf).collect(Collectors.toList());
    }

    private Optional<DatasetRow> buildOptionalRowFrom(Map.Entry<String, Object> valueForColumn, Optional<ColumnMappingPart> optionalMappingForColumn) {
        return optionalMappingForColumn.map(columnMappingPart -> {
            Object value = valueForColumn.getValue();
            DatasetRow joinedRow = new DatasetRow(columnMappingPart.tableName);
            joinedRow.addColumnValue(columnMappingPart.tableColumn, value);
            return joinedRow;
        });
    }

    private static <T> Stream<T> streamOf(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public DatasetRow addColumnValue(String columnName, Object value) {
        this.columnValueByColumnName.put(columnName, value);
        return this;
    }

    Object getValueOf(String columnName) {
        return this.columnValueByColumnName.get(columnName);
    }

    void updateTableNameWith(Function<String, String> tableNameFunction) {
        String newTableName;
        this.tableName = newTableName = tableNameFunction.apply(this.tableName);
    }
}

