/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.qstd.DatasetRow;
import org.qstd.PreparedStatementBuilder;
import org.qstd.SelectTransformer;
import org.qstd.SelectTransformerFactory;
import org.qstd.SqlQuery;

class DatasetRowsFinder {
    private final DataSource dataSource;

    DatasetRowsFinder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    Collection<DatasetRow> findDatasetRowsOf(SqlQuery sqlQuery) {
        SelectTransformer selectTransformer = SelectTransformerFactory.createSelectTransformer(sqlQuery);
        Optional<SqlQuery> optionalSelectQuery = selectTransformer.toSelect(sqlQuery);
        if (optionalSelectQuery.isPresent()) {
            SqlQuery selectQuery = optionalSelectQuery.get();
            return this.execute(selectQuery);
        }
        return Collections.emptyList();
    }

    private Collection<DatasetRow> execute(SqlQuery sqlQuery) {
        ArrayList<DatasetRow> datasetRowsToReturn = new ArrayList<DatasetRow>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement selectStatement = PreparedStatementBuilder.buildFrom(sqlQuery, connection);){
            ResultSet resultSet = selectStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                Collection<DatasetRow> datasetRows = this.buildDatasetRowsFrom(resultSet, resultSetMetaData, columnCount, sqlQuery);
                datasetRowsToReturn.addAll(datasetRows);
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return datasetRowsToReturn;
    }

    private Collection<DatasetRow> buildDatasetRowsFrom(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int columnCount, SqlQuery sqlQuery) throws SQLException {
        HashMap<String, DatasetRow> rowsByTableName = new HashMap<String, DatasetRow>();
        for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
            String tableName = this.findTableName(resultSetMetaData, colIndex, sqlQuery);
            DatasetRow datasetRow = rowsByTableName.computeIfAbsent(tableName, t -> DatasetRow.ofTable(tableName));
            String column = resultSetMetaData.getColumnName(colIndex);
            Object value = resultSet.getObject(colIndex);
            datasetRow.addColumnValue(column, value);
        }
        return rowsByTableName.values();
    }

    private String findTableName(ResultSetMetaData resultSetMetaData, int colIndex, SqlQuery sqlQuery) throws SQLException {
        String tableName = resultSetMetaData.getTableName(colIndex);
        if (!tableName.isEmpty()) {
            return tableName;
        }
        String queryAsString = sqlQuery.getQueryAsString();
        return this.extractTableNameFrom(queryAsString);
    }

    private String extractTableNameFrom(String sqlQueryAsString) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sqlQueryAsString);
            Select select = (Select)statement;
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
            List tableList = tablesNamesFinder.getTableList((Statement)select);
            if (tableList.size() == 1) {
                return (String)tableList.get(0);
            }
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
        }
        return "";
    }
}

