/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.qstd.DatasetRow;
import org.qstd.PreparedStatementBuilder;
import org.qstd.SqlQuery;
import org.qstd.dbtype.DatabaseType;

class RowFinder {
    private final DataSource dataSource;
    private final DatabaseType dbType;

    RowFinder(DataSource dataSource, DatabaseType dbType) {
        this.dataSource = dataSource;
        this.dbType = dbType;
    }

    DatasetRow findOneRowFrom(String tableName, Collection<String> columnNamesToSearch, DatasetRow rowToSearch) {
        SqlQuery missingColumnValuesQuery = SqlQuery.buildFromRow(columnNamesToSearch, rowToSearch, this.dbType);
        DatasetRow missingColumnValues = DatasetRow.ofTable(tableName);
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement missingColumnStatement = PreparedStatementBuilder.buildFrom(missingColumnValuesQuery, connection);){
            ResultSet queryResult = missingColumnStatement.executeQuery();
            queryResult.next();
            for (String missingColumnName : columnNamesToSearch) {
                Object columnValue = queryResult.getObject(missingColumnName);
                missingColumnValues.addColumnValue(missingColumnName, columnValue);
            }
        }
        catch (SQLException sqlException) {
            System.err.println("Unable to execute " + missingColumnValuesQuery);
            sqlException.printStackTrace();
        }
        return missingColumnValues;
    }
}

