/*
 * Decompiled with CFR 0.152.
 */
package org.qstd.dbtype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.qstd.ColumnOrdersFinder;
import org.qstd.PreparedStatementBuilder;
import org.qstd.SqlQuery;

class BaseColumnOrdersFinder
implements ColumnOrdersFinder {
    private final DataSource dataSource;
    private final SqlQuery notNullColumnsQuery;

    BaseColumnOrdersFinder(DataSource dataSource, SqlQuery notNullColumnsQuery) {
        this.dataSource = dataSource;
        this.notNullColumnsQuery = notNullColumnsQuery;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> findDatabaseColumnOrdersOf(String tableName) {
        try (Connection connection = this.dataSource.getConnection();){
            List<String> list;
            block14: {
                PreparedStatement columnOrderStatement = PreparedStatementBuilder.buildFrom(this.notNullColumnsQuery, connection);
                try {
                    columnOrderStatement.setString(1, tableName);
                    ResultSet queryResult = columnOrderStatement.executeQuery();
                    list = this.findColumnOrderFrom(queryResult);
                    if (columnOrderStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (columnOrderStatement != null) {
                        try {
                            columnOrderStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columnOrderStatement.close();
            }
            return list;
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return Collections.emptyList();
        }
    }

    private List<String> findColumnOrderFrom(ResultSet queryResult) throws SQLException {
        ArrayList<String> columnOrder = new ArrayList<String>();
        while (queryResult.next()) {
            String columnName = queryResult.getString(3);
            columnOrder.add(columnName);
        }
        return columnOrder;
    }
}

