/*
 * Decompiled with CFR 0.152.
 */
package org.qstd.dbtype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.qstd.NotNullColumnsFinder;
import org.qstd.PreparedStatementBuilder;
import org.qstd.SqlQuery;

public class BaseNotNullColumnsFinder
implements NotNullColumnsFinder {
    private final DataSource dataSource;
    private final SqlQuery notNullColumnsQuery;

    BaseNotNullColumnsFinder(DataSource dataSource, SqlQuery notNullColumnsQuery) {
        this.dataSource = dataSource;
        this.notNullColumnsQuery = notNullColumnsQuery;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> findNotNullColumnsOf(String tableName) {
        try (Connection connection = this.dataSource.getConnection();){
            List<String> list;
            block14: {
                PreparedStatement columnOrderStatement = PreparedStatementBuilder.buildFrom(this.notNullColumnsQuery, connection);
                try {
                    columnOrderStatement.setString(1, tableName);
                    ResultSet queryResult = columnOrderStatement.executeQuery();
                    list = this.findNotNullColumnsFrom(queryResult);
                    if (columnOrderStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (columnOrderStatement != null) {
                        try {
                            columnOrderStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                columnOrderStatement.close();
            }
            return list;
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return Collections.emptyList();
        }
    }

    private List<String> findNotNullColumnsFrom(ResultSet resultSet) throws SQLException {
        ArrayList<String> notNullColumns = new ArrayList<String>();
        while (resultSet.next()) {
            String columnName = resultSet.getString(3);
            notNullColumns.add(columnName);
        }
        return notNullColumns;
    }
}

