/*
 * Decompiled with CFR 0.152.
 */
package org.qstd.dbtype;

import javax.sql.DataSource;
import org.qstd.DatabaseMetadataFinder;
import org.qstd.dbtype.DatabaseType;
import org.qstd.dbtype.DefaultDatabaseMetadataFinder;
import org.qstd.dbtype.H2MetadataFinder;
import org.qstd.dbtype.HsqlDbMetadataFinder;
import org.qstd.dbtype.MSSQLServerMetadataFinder;
import org.qstd.dbtype.MariaDBMySQLMetadataFinder;
import org.qstd.dbtype.OracleMetadataFinder;
import org.qstd.dbtype.PostgreSqlMetadataFinder;

public class DatabaseMetadataFinderFactory {
    private DatabaseMetadataFinderFactory() {
    }

    public static DatabaseMetadataFinder createDatabaseMetadataFinderFrom(DataSource dataSource, DatabaseType dbType) {
        if (dbType.equals((Object)DatabaseType.H2)) {
            return new H2MetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.HSQLDB)) {
            return new HsqlDbMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.POSTGRE_SQL)) {
            return new PostgreSqlMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.MARIA_DB) || dbType.equals((Object)DatabaseType.MY_SQL)) {
            return new MariaDBMySQLMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.MICROSOFT_SQL_SERVER)) {
            return new MSSQLServerMetadataFinder(dataSource);
        }
        if (dbType.equals((Object)DatabaseType.ORACLE)) {
            return new OracleMetadataFinder(dataSource);
        }
        return new DefaultDatabaseMetadataFinder(dataSource);
    }
}

