/*
 * Decompiled with CFR 0.152.
 */
package org.qstd.dbtype;

import java.util.Arrays;

public enum DatabaseType {
    H2("jdbc:h2"),
    HSQLDB("jdbc:hsqldb"),
    MARIA_DB("jdbc:mariadb"),
    MICROSOFT_SQL_SERVER("jdbc:sqlserver"),
    MY_SQL("jdbc:mysql"),
    ORACLE("jdbc:oracle"),
    POSTGRE_SQL("jdbc:postgresql"),
    OTHER("jdbc:");

    private final String jdbcUrlStart;

    private DatabaseType(String jdbcUrlStart) {
        this.jdbcUrlStart = jdbcUrlStart;
    }

    public static DatabaseType findFromDbUrl(String jdbcUrl) {
        DatabaseType[] databaseTypes = DatabaseType.values();
        return Arrays.stream(databaseTypes).filter(dbType -> dbType.accept(jdbcUrl)).findFirst().get();
    }

    private boolean accept(String jdbcUrl) {
        return jdbcUrl.startsWith(this.jdbcUrlStart);
    }
}

