/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import elemental2.core.JsObject;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import jsinterop.annotations.JsConstructor;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import jsinterop.base.JsPropertyMapOfAny;
import react4j.core.ComponentConstructorFunction;
import react4j.core.NativeAdapterComponent;
import react4j.core.ReactConfig;
import react4j.core.util.JsUtil;
import react4j.processor.ComponentDescriptor;
import react4j.processor.EventHandlerDescriptor;
import react4j.processor.MethodDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.ReactProcessor;

final class Generator {
    private Generator() {
    }

    @Nonnull
    static TypeSpec buildConstructorFactory(@Nonnull ComponentDescriptor descriptor) {
        TypeElement element = descriptor.getElement();
        String name = descriptor.getNestedClassPrefix() + descriptor.getConstructorFactoryName();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)name);
        ProcessorUtil.copyAccessModifiers(element, builder);
        builder.addModifiers(new Modifier[]{Modifier.FINAL});
        builder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{ReactProcessor.class.getName()}).build());
        FieldSpec.Builder field = FieldSpec.builder((TypeName)Generator.getJsConstructorFnType(descriptor), (String)"TYPE", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC}).initializer("getConstructorFunction()", new Object[0]);
        builder.addField(field.build());
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            builder.addMethod(Generator.buildRawLifecycleMethod(descriptor, lifecycleMethod).build());
        }
        builder.addMethod(Generator.buildConstructorFnMethod(descriptor).build());
        for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
            builder.addMethod(Generator.buildEventHandlerMethod(descriptor, eventHandler).build());
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildRawLifecycleMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull MethodDescriptor lifecycleMethod) {
        String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)(methodName + "_function")).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.NATIVE}).returns((TypeName)ClassName.get(JsObject.class));
        String classname = descriptor.getNativeComponentClassName().toString();
        CodeBlock.Builder code = CodeBlock.builder();
        String innerCode = "return this.@" + classname + "::" + methodName + "(*)(arguments);";
        code.add("/*-{ return function() { " + innerCode + " } }-*/", new Object[0]);
        method.addCode(code.build());
        return method;
    }

    @Nonnull
    private static ParameterizedTypeName getJsConstructorFnType(@Nonnull ComponentDescriptor descriptor) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ComponentConstructorFunction.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)descriptor.getPropsType().asType()), TypeName.get((TypeMirror)descriptor.getStateType().asType()), descriptor.getNativeComponentClassName()});
    }

    @Nonnull
    private static MethodSpec.Builder buildEventHandlerMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull EventHandlerDescriptor eventHandler) {
        int paramCount;
        String args;
        TypeName handlerType = TypeName.get((TypeMirror)eventHandler.getEventHandlerType().asType());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)("_" + eventHandler.getMethod().getSimpleName())).addAnnotation(Nonnull.class).returns(handlerType);
        method.addModifiers(new Modifier[]{Modifier.STATIC});
        ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)descriptor.getElement().asType()), (String)"component", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class);
        method.addParameter(parameter.build());
        ExecutableElement target = eventHandler.getEventHandlerMethod();
        int targetParameterCount = target.getParameters().size();
        String string = args = 0 == targetParameterCount ? "()" : IntStream.range(0, targetParameterCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        if (1 < targetParameterCount) {
            args = "(" + args + ")";
        }
        String params = 0 == (paramCount = eventHandler.getMethod().getParameters().size()) ? "" : IntStream.range(0, paramCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        method.addStatement("final $T handler = " + args + " -> component.$N(" + params + ")", new Object[]{handlerType, eventHandler.getMethod().getSimpleName()});
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if( $T.enableComponentNames() )", new Object[]{ReactConfig.class});
        String code = "$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( JsPropertyMap.of( \"value\", $S ) ) )";
        block.addStatement("$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( JsPropertyMap.of( \"value\", $S ) ) )", new Object[]{JsObject.class, Js.class, Js.class, descriptor.getName() + "." + eventHandler.getName()});
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("return handler", new Object[0]);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructorFnMethod(@Nonnull ComponentDescriptor descriptor) {
        ParameterizedTypeName constructorType = Generator.getJsConstructorFnType(descriptor);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"getConstructorFunction").addAnnotation(Nonnull.class).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PRIVATE}).returns((TypeName)constructorType);
        method.addStatement("final $T prototype = $T.getPrototypeForClass( $T.class )", new Object[]{JsPropertyMapOfAny.class, JsUtil.class, descriptor.getNativeComponentClassName()});
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            method.addStatement("prototype.set( $S, $N() )", new Object[]{methodName, methodName + "_function"});
        }
        method.addStatement("final $T componentConstructor = $T::new", new Object[]{constructorType, descriptor.getNativeComponentClassName()});
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( $T.enableComponentNames() )", new Object[]{ReactConfig.class});
        codeBlock.addStatement("$T.of( componentConstructor ).set( \"displayName\", $S )", new Object[]{JsPropertyMap.class, descriptor.getName()});
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        method.addStatement("return componentConstructor", new Object[0]);
        return method;
    }

    @Nonnull
    static TypeSpec buildNativeComponent(@Nonnull ComponentDescriptor descriptor) {
        ClassName target;
        TypeElement element = descriptor.getElement();
        String name = descriptor.getNestedClassPrefix() + descriptor.getNativeComponentName();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)name);
        builder.addModifiers(new Modifier[]{Modifier.FINAL});
        builder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{ReactProcessor.class.getName()}).build());
        ParameterizedTypeName superType = ParameterizedTypeName.get((ClassName)ClassName.get(NativeAdapterComponent.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)descriptor.getPropsType().asType()), ClassName.get((TypeMirror)descriptor.getStateType().asType()), ClassName.get((TypeElement)descriptor.getElement())});
        builder.superclass((TypeName)superType);
        ParameterSpec.Builder props = ParameterSpec.builder((TypeName)ClassName.get((TypeElement)descriptor.getPropsType()), (String)"props", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class);
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addAnnotation(JsConstructor.class).addParameter(props.build());
        method.addStatement("super( props )", new Object[0]);
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"createComponent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ClassName.get((TypeElement)descriptor.getElement()));
        ClassName className = ClassName.get((TypeElement)descriptor.getElement());
        ArrayList<String> names = new ArrayList<String>(className.simpleNames());
        String cname = (descriptor.isArezComponent() ? "Arez_" : "") + element.getSimpleName();
        if (names.size() > 1) {
            names.remove(names.size() - 1);
            names.add(cname);
            target = ClassName.get((String)className.packageName(), (String)((String)names.get(0)), (String[])names.subList(1, names.size()).toArray(new String[0]));
        } else {
            target = ClassName.get((String)className.packageName(), (String)cname, (String[])new String[0]);
        }
        method2.addStatement("return new $T()", new Object[]{target});
        builder.addMethod(method2.build());
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            MethodSpec.Builder method3 = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ClassName.get((TypeMirror)lifecycleMethod.getMethodType().getReturnType()));
            ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method3);
            StringJoiner params = new StringJoiner(",");
            List<? extends VariableElement> sourceParameters = lifecycleMethod.getMethod().getParameters();
            List<? extends TypeMirror> sourceParameterTypes = lifecycleMethod.getMethodType().getParameterTypes();
            int parameterCount = sourceParameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                VariableElement parameter = sourceParameters.get(i);
                TypeMirror parameterType = sourceParameterTypes.get(i);
                String parameterName = parameter.getSimpleName().toString();
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameterType), (String)parameterName, (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class);
                method3.addParameter(parameterSpec.build());
                params.add(parameterName);
            }
            StringBuilder sb = new StringBuilder();
            if (TypeKind.VOID != lifecycleMethod.getMethodType().getReturnType().getKind()) {
                sb.append("return ");
            }
            sb.append("perform");
            sb.append(Character.toUpperCase(methodName.charAt(0)));
            sb.append(methodName.substring(1));
            sb.append("(");
            sb.append(params.toString());
            sb.append(")");
            method3.addStatement(sb.toString(), new Object[0]);
            builder.addMethod(method3.build());
        }
        return builder.build();
    }
}

