/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import react4j.processor.MethodDescriptor;
import react4j.processor.PropComparator;
import react4j.processor.PropDescriptor;
import react4j.processor.ReactProcessorException;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;

final class ComponentDescriptor {
    @Nonnull
    private final Elements _elements;
    @Nonnull
    private final SourceVersion _sourceVersion;
    @Nonnull
    private final String _name;
    @Nonnull
    private final PackageElement _packageElement;
    @Nonnull
    private final TypeElement _element;
    private boolean _arezComponent;
    private boolean _needsInjection;
    private boolean _needsDaggerIntegration;
    private boolean _runArezScheduler;
    @Nullable
    private List<MethodDescriptor> _lifecycleMethods;
    @Nullable
    private List<PropDescriptor> _props;
    @Nullable
    private List<MethodDescriptor> _memoizeMethods;
    private Boolean _hasObservableProps;
    private Boolean _hasValidatedProps;
    private Boolean _hasOnPropChangedProps;

    ComponentDescriptor(@Nonnull Elements elements, @Nonnull SourceVersion sourceVersion, @Nonnull String name, @Nonnull PackageElement packageElement, @Nonnull TypeElement element) {
        this._elements = Objects.requireNonNull(elements);
        this._sourceVersion = Objects.requireNonNull(sourceVersion);
        this._name = Objects.requireNonNull(name);
        this._packageElement = Objects.requireNonNull(packageElement);
        this._element = Objects.requireNonNull(element);
        if (ElementKind.CLASS != element.getKind()) {
            throw new ReactProcessorException("@ReactComponent target must be a class", element);
        }
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ReactProcessorException("@ReactComponent target must not be final", element);
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ReactProcessorException("@ReactComponent target must be abstract", element);
        }
        if (NestingKind.TOP_LEVEL != element.getNestingKind() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ReactProcessorException("@ReactComponent target must not be a non-static nested class", element);
        }
        List constructors = element.getEnclosedElements().stream().filter(m -> m.getKind() == ElementKind.CONSTRUCTOR).map(m -> (ExecutableElement)m).collect(Collectors.toList());
        if (1 != constructors.size() || !((ExecutableElement)constructors.get(0)).getParameters().isEmpty() || ((ExecutableElement)constructors.get(0)).getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ReactProcessorException("@ReactComponent target must have a single non-private, no-argument constructor or the default constructor", element);
        }
    }

    @Nonnull
    Elements getElements() {
        return this._elements;
    }

    @Nonnull
    SourceVersion getSourceVersion() {
        return this._sourceVersion;
    }

    @Nonnull
    String getPackageName() {
        return this._packageElement.getQualifiedName().toString();
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    ClassName getClassName() {
        return ClassName.get(this.getElement());
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    DeclaredType getDeclaredType() {
        return (DeclaredType)this._element.asType();
    }

    @Nonnull
    ClassName getEnhancedClassName() {
        return ClassName.get(this.getPackageName(), this.getNestedClassPrefix() + "React4j_" + this._element.getSimpleName(), new String[0]);
    }

    @Nonnull
    ClassName getBuilderClassName() {
        return ClassName.get(this.getPackageName(), this.getNestedClassPrefix() + this._element.getSimpleName() + "Builder", new String[0]);
    }

    @Nonnull
    ClassName getDaggerFactoryClassName() {
        return ClassName.get(this.getPackageName(), this.getNestedClassPrefix() + this._element.getSimpleName() + "DaggerFactory", new String[0]);
    }

    @Nonnull
    ClassName getClassNameToConstruct() {
        String simpleName = (this.isArezComponent() ? "Arez_" : "") + this.getNestedClassPrefix() + "React4j_" + this._element.getSimpleName();
        return ClassName.get(this.getPackageName(), simpleName, new String[0]);
    }

    @Nonnull
    TypeName getComponentType() {
        List<TypeName> typeNames = this.getDeclaredType().getTypeArguments().stream().map(TypeName::get).collect(Collectors.toList());
        if (!typeNames.isEmpty()) {
            return ParameterizedTypeName.get(ClassName.get(this.getElement()), typeNames.toArray(new TypeName[0]));
        }
        return ClassName.get(this.getElement());
    }

    boolean needsInjection() {
        return this._needsInjection;
    }

    void setNeedsInjection(boolean needsInjection) {
        this._needsInjection = needsInjection;
    }

    boolean needsDaggerIntegration() {
        return this._needsDaggerIntegration;
    }

    void setNeedsDaggerIntegration(boolean needsDaggerIntegration) {
        this._needsDaggerIntegration = needsDaggerIntegration;
    }

    boolean isArezComponent() {
        return this._arezComponent;
    }

    void setArezComponent(boolean arezComponent) {
        this._arezComponent = arezComponent;
    }

    boolean shouldRunArezScheduler() {
        return this._runArezScheduler;
    }

    void setRunArezScheduler(boolean runArezScheduler) {
        this._runArezScheduler = runArezScheduler;
    }

    @Nonnull
    private String getNestedClassPrefix() {
        StringBuilder name = new StringBuilder();
        TypeElement t = this.getElement();
        while (NestingKind.TOP_LEVEL != t.getNestingKind()) {
            t = (TypeElement)t.getEnclosingElement();
            name.insert(0, t.getSimpleName() + "_");
        }
        return name.toString();
    }

    @Nonnull
    List<MethodDescriptor> getLifecycleMethods() {
        assert (null != this._lifecycleMethods);
        return this._lifecycleMethods;
    }

    void setLifecycleMethods(@Nonnull List<MethodDescriptor> lifecycleMethods) {
        this._lifecycleMethods = Objects.requireNonNull(lifecycleMethods);
    }

    @Nonnull
    List<MethodDescriptor> getLiteLifecycleMethods() {
        assert (null != this._lifecycleMethods);
        return this._lifecycleMethods.stream().filter(m -> !this.canOmitFromLiteLifecycle((MethodDescriptor)m)).collect(Collectors.toList());
    }

    boolean shouldGenerateLiteLifecycle() {
        assert (null != this._lifecycleMethods);
        return this._lifecycleMethods.stream().anyMatch(this::canOmitFromLiteLifecycle);
    }

    private boolean canOmitFromLiteLifecycle(@Nonnull MethodDescriptor method) {
        String methodName = method.getMethod().getSimpleName().toString();
        String classname = this.getClassNameForMethod(method);
        return "shouldComponentUpdate".equals(methodName) && !this.generateShouldComponentUpdate() || "react4j.Component".equals(classname) && "componentDidMount".equals(methodName) || "react4j.Component".equals(classname) && "componentDidUpdate".equals(methodName) && !this.generateComponentDidUpdate();
    }

    @Nonnull
    private String getClassNameForMethod(@Nonnull MethodDescriptor method) {
        return ((TypeElement)method.getMethod().getEnclosingElement()).getQualifiedName().toString();
    }

    @Nonnull
    List<MethodDescriptor> getMemoizeMethods() {
        assert (null != this._memoizeMethods);
        return this._memoizeMethods;
    }

    void setMemoizeMethods(@Nonnull List<MethodDescriptor> memoizeMethods) {
        assert (this.isArezComponent());
        this._memoizeMethods = Objects.requireNonNull(memoizeMethods);
    }

    @Nonnull
    List<PropDescriptor> getProps() {
        assert (null != this._props);
        return this._props;
    }

    @Nullable
    PropDescriptor findPropNamed(@Nonnull String name) {
        return this.getProps().stream().filter(p -> p.getName().equals(name)).findAny().orElse(null);
    }

    void setProps(@Nonnull List<PropDescriptor> events) {
        this._props = Objects.requireNonNull(events);
    }

    void sortProps() {
        assert (null != this._props);
        this._props.sort(PropComparator.COMPARATOR);
    }

    boolean hasObservableProps() {
        if (null == this._hasObservableProps) {
            this._hasObservableProps = this.getProps().stream().anyMatch(PropDescriptor::isObservable);
        }
        return this._hasObservableProps;
    }

    boolean generateShouldComponentUpdate() {
        return this.hasObservableProps() || this.hasValidatedProps();
    }

    boolean generateComponentDidUpdate() {
        return this.hasObservableProps() || this.hasOnPropChangedProps();
    }

    boolean hasOnPropChangedProps() {
        if (null == this._hasOnPropChangedProps) {
            this._hasOnPropChangedProps = this.getProps().stream().anyMatch(PropDescriptor::hasOnPropChangedMethod);
        }
        return this._hasOnPropChangedProps;
    }

    boolean hasValidatedProps() {
        if (null == this._hasValidatedProps) {
            this._hasValidatedProps = this.getProps().stream().anyMatch(PropDescriptor::hasValidateMethod);
        }
        return this._hasValidatedProps;
    }
}

