/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import react4j.processor.BuilderDescriptor;
import react4j.processor.ComponentDescriptor;
import react4j.processor.MethodDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.PropDescriptor;
import react4j.processor.ReactProcessor;
import react4j.processor.ReactProcessorException;
import react4j.processor.Step;
import react4j.processor.StepMethod;
import react4j.processor.StepMethodType;
import react4j.processor.vendor.google.auto.common.GeneratedAnnotationSpecs;
import react4j.processor.vendor.javapoet.AnnotationSpec;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.CodeBlock;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.TypeVariableName;
import react4j.processor.vendor.javapoet.WildcardTypeName;

final class Generator {
    private static final ClassName INJECT_CLASSNAME = ClassName.get("javax.inject", "Inject", new String[0]);
    private static final ClassName PROVIDER_CLASSNAME = ClassName.get("javax.inject", "Provider", new String[0]);
    private static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    private static final ClassName NULLABLE_CLASSNAME = ClassName.get("javax.annotation", "Nullable", new String[0]);
    private static final ClassName GUARDS_CLASSNAME = ClassName.get("org.realityforge.braincheck", "Guards", new String[0]);
    private static final ClassName OBSERVABLE_CLASSNAME = ClassName.get("arez", "ObservableValue", new String[0]);
    private static final ClassName DISPOSABLE_CLASSNAME = ClassName.get("arez", "Disposable", new String[0]);
    private static final ClassName AREZ_FEATURE_CLASSNAME = ClassName.get("arez.annotations", "Feature", new String[0]);
    private static final ClassName ACTION_CLASSNAME = ClassName.get("arez.annotations", "Action", new String[0]);
    private static final ClassName DEP_TYPE_CLASSNAME = ClassName.get("arez.annotations", "DepType", new String[0]);
    private static final ClassName MEMOIZE_CLASSNAME = ClassName.get("arez.annotations", "Memoize", new String[0]);
    private static final ClassName PRIORITY_CLASSNAME = ClassName.get("arez.annotations", "Priority", new String[0]);
    private static final ClassName OBSERVABLE_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "Observable", new String[0]);
    private static final ClassName OBSERVABLE_VALUE_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ObservableValueRef", new String[0]);
    private static final ClassName AREZ_COMPONENT_CLASSNAME = ClassName.get("arez.annotations", "ArezComponent", new String[0]);
    private static final ClassName JS_ARRAY_CLASSNAME = ClassName.get("elemental2.core", "JsArray", new String[0]);
    private static final ClassName JS_ERROR_CLASSNAME = ClassName.get("elemental2.core", "JsError", new String[0]);
    private static final ClassName JS_TYPE_CLASSNAME = ClassName.get("jsinterop.annotations", "JsType", new String[0]);
    private static final ClassName JS_CONSTRUCTOR_CLASSNAME = ClassName.get("jsinterop.annotations", "JsConstructor", new String[0]);
    private static final ClassName JS_PACKAGE_CLASSNAME = ClassName.get("jsinterop.annotations", "JsPackage", new String[0]);
    private static final ClassName JS_CLASSNAME = ClassName.get("jsinterop.base", "Js", new String[0]);
    private static final ClassName JS_PROPERTY_MAP_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMap", new String[0]);
    private static final ParameterizedTypeName JS_PROPERTY_MAP_T_OBJECT_CLASSNAME = ParameterizedTypeName.get(JS_PROPERTY_MAP_CLASSNAME, TypeName.OBJECT);
    private static final ClassName COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME = ClassName.get("react4j", "ComponentConstructorFunction", new String[0]);
    private static final ClassName REACT_NODE_CLASSNAME = ClassName.get("react4j", "ReactNode", new String[0]);
    private static final ClassName REACT_ELEMENT_CLASSNAME = ClassName.get("react4j", "ReactElement", new String[0]);
    private static final ClassName REACT_ERROR_INFO_CLASSNAME = ClassName.get("react4j", "ReactErrorInfo", new String[0]);
    private static final ClassName REACT_NATIVE_ADAPTER_COMPONENT_CLASSNAME = ClassName.get("react4j", "NativeAdapterComponent", new String[0]);
    private static final ClassName REACT_CONFIG_CLASSNAME = ClassName.get("react4j", "ReactConfig", new String[0]);
    private static final ClassName COMPONENT_CLASSNAME = ClassName.get("react4j", "Component", new String[0]);

    private Generator() {
    }

    @Nonnull
    static TypeSpec buildComponentBuilder(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getBuilderClassName());
        Generator.addGeneratedAnnotation(descriptor, builder);
        ProcessorUtil.copyAccessModifiers(descriptor.getElement(), builder);
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        BuilderDescriptor builderDescriptor = Generator.buildBuilderDescriptor(descriptor);
        ArrayList<Step> steps = builderDescriptor.getSteps();
        for (Step step : steps) {
            builder.addType(Generator.buildBuilderStepInterface(descriptor, step));
        }
        Generator.buildStaticStepMethodMethods(descriptor, builder, steps.get(0));
        Generator.buildStaticStepMethodMethods(descriptor, builder, steps.get(1));
        builder.addType(Generator.buildBuilder(descriptor, builderDescriptor));
        return builder.build();
    }

    private static void buildStaticStepMethodMethods(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeSpec.Builder builder, @Nonnull Step step) {
        ArrayList<StepMethod> methods = step.getMethods();
        for (StepMethod method : methods) {
            builder.addMethod(Generator.buildStaticStepMethodMethod(descriptor, step, method));
        }
    }

    @Nonnull
    private static MethodSpec buildStaticStepMethodMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        ExecutableType propMethodType;
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName()).addAnnotation(NONNULL_CLASSNAME);
        method.addModifiers(Modifier.STATIC);
        if (descriptor.getDeclaredType().asElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            method.addModifiers(Modifier.PUBLIC);
        }
        if (null != (propMethodType = stepMethod.getPropMethodType())) {
            ProcessorUtil.copyTypeParameters(propMethodType, method);
        }
        ProcessorUtil.copyTypeParameters(descriptor.getElement(), method);
        if (stepMethod.isBuildIntrinsic()) {
            String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method.addStatement("return new $T" + infix + "().build()", ClassName.bestGuess("Builder"));
        } else {
            ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
            ExecutableElement propMethod = stepMethod.getPropMethod();
            if (null != propMethod) {
                ProcessorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)propMethod, parameter);
            } else if (stepMethod.isChildrenStreamIntrinsic()) {
                parameter.addAnnotation(NONNULL_CLASSNAME);
            } else if (stepMethod.isKeyIntrinsic() && !stepMethod.getKey().equals("*key_int*")) {
                parameter.addAnnotation(NONNULL_CLASSNAME);
            }
            method.addParameter(parameter.build());
            String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method.addStatement("return new $T" + infix + "().$N( $N )", ClassName.bestGuess("Builder"), stepMethod.getName(), stepMethod.getName());
        }
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildStepInterfaceMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull String name, @Nonnull Step step, @Nonnull StepMethodType stepMethodType, @Nonnull Consumer<MethodSpec.Builder> action) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(name);
        method.addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
        method.addAnnotation(NONNULL_CLASSNAME);
        action.accept(method);
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethodType);
        return method;
    }

    private static void configureStepMethodReturns(@Nonnull ComponentDescriptor descriptor, @Nonnull MethodSpec.Builder method, @Nonnull Step step, @Nonnull StepMethodType stepMethodType) {
        if (StepMethodType.TERMINATE == stepMethodType) {
            method.returns(REACT_NODE_CLASSNAME);
        } else {
            int returnIndex = step.getIndex() + (StepMethodType.STAY == stepMethodType ? 0 : 1);
            ClassName className = ClassName.bestGuess("Builder" + returnIndex);
            List<TypeVariableName> variableNames = ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType());
            if (variableNames.isEmpty()) {
                method.returns(className);
            } else {
                method.returns(ParameterizedTypeName.get(className, variableNames.toArray(new TypeName[0])));
            }
        }
    }

    @Nonnull
    private static TypeSpec buildBuilderStepInterface(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step) {
        int stepIndex = step.getIndex();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Builder" + stepIndex);
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.addTypeVariables(ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (!descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            builder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "unused").build());
        }
        for (StepMethod stepMethod : step.getMethods()) {
            StepMethodType stepMethodType = stepMethod.getStepMethodType();
            if (stepMethod.isBuildIntrinsic()) {
                builder.addMethod(Generator.buildStepInterfaceMethod(descriptor, "build", step, stepMethodType, m -> {}).build());
                continue;
            }
            builder.addMethod(Generator.buildStepInterfaceMethod(descriptor, stepMethod.getName(), step, stepMethodType, m -> {
                ExecutableType propMethodType = stepMethod.getPropMethodType();
                if (null != propMethodType) {
                    ProcessorUtil.copyTypeParameters(propMethodType, m);
                }
                if (stepMethod.isChildrenIntrinsic()) {
                    m.varargs();
                }
                ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), new Modifier[0]);
                ExecutableElement propMethod = stepMethod.getPropMethod();
                if (null != propMethod) {
                    ProcessorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)propMethod, parameter);
                } else if (stepMethod.isKeyIntrinsic() || stepMethod.isChildrenStreamIntrinsic()) {
                    parameter.addAnnotation(NONNULL_CLASSNAME);
                }
                m.addParameter(parameter.build());
            }).build());
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec buildBuilderStepImpl(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName());
        method.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        method.addAnnotation(Override.class);
        method.addAnnotation(NONNULL_CLASSNAME);
        ExecutableType propMethodType = stepMethod.getPropMethodType();
        if (null != propMethodType) {
            ProcessorUtil.copyTypeParameters(propMethodType, method);
        }
        ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
        ExecutableElement propMethod = stepMethod.getPropMethod();
        if (null != propMethod) {
            ProcessorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)propMethod, parameter);
        } else if (stepMethod.isKeyIntrinsic() || stepMethod.isChildrenStreamIntrinsic()) {
            parameter.addAnnotation(NONNULL_CLASSNAME);
        }
        method.addParameter(parameter.build());
        boolean returnHandled = false;
        if (stepMethod.isChildrenIntrinsic()) {
            method.varargs();
            PropDescriptor prop = stepMethod.getProp();
            assert (null != prop);
            method.addStatement("_element.props().set( $T.Props.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            method.addStatement("children( $N.toArray( $T[]::new ) )", stepMethod.getName(), REACT_NODE_CLASSNAME);
        } else if (stepMethod.isChildIntrinsic()) {
            assert (null != propMethod);
            PropDescriptor prop = stepMethod.getProp();
            assert (null != prop);
            if (null != Generator.isNonnull(propMethod)) {
                method.addStatement("_element.props().set( $T.Props.$N, $T.of( $T.requireNonNull( $N ) ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, Objects.class, stepMethod.getName());
            } else {
                method.addStatement("_element.props().set( $T.Props.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
            }
        } else if (stepMethod.getKey().equals("*key_int*")) {
            returnHandled = true;
            method.addStatement("return key( $T.valueOf( $N ) )", TypeName.get(String.class), stepMethod.getName());
        } else if (stepMethod.isKeyIntrinsic()) {
            method.addStatement("_element.setKey( $T.requireNonNull( $N ) )", TypeName.get(Objects.class), stepMethod.getName());
        } else {
            PropDescriptor prop;
            if (null != propMethod && null != Generator.isNonnull(propMethod) && !stepMethod.getType().isPrimitive()) {
                method.addStatement("$T.requireNonNull( $N )", Objects.class, stepMethod.getName());
            }
            if (null != (prop = stepMethod.getProp())) {
                if (prop.isSpecialChildrenProp()) {
                    method.addStatement("_element.props().set( $T.Props.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
                } else {
                    method.addStatement("_element.props().set( $T.Props.$N, $N )", descriptor.getEnhancedClassName(), prop.getConstantName(), stepMethod.getName());
                }
            } else {
                method.addStatement("_element.props().set( $S, $N )", stepMethod.getName(), stepMethod.getName());
            }
        }
        if (!returnHandled) {
            if (StepMethodType.TERMINATE == stepMethod.getStepMethodType()) {
                method.addStatement("return build()", new Object[0]);
            } else {
                method.addStatement("return this", new Object[0]);
            }
        }
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    private static AnnotationMirror isNonnull(@Nonnull ExecutableElement method) {
        return ProcessorUtil.findAnnotationByType(method, "javax.annotation.Nonnull");
    }

    @Nonnull
    private static MethodSpec buildBuildStepImpl() {
        return MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).addStatement("_element.complete()", new Object[0]).addStatement("return _element", new Object[0]).returns(REACT_NODE_CLASSNAME).build();
    }

    @Nonnull
    private static TypeSpec buildBuilder(@Nonnull ComponentDescriptor descriptor, @Nonnull BuilderDescriptor builderDescriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Builder");
        ProcessorUtil.copyTypeParameters(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC);
        ArrayList<Step> steps = builderDescriptor.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            builder.addSuperinterface(Generator.getParameterizedTypeName(descriptor, ClassName.bestGuess("Builder" + (i + 1))));
        }
        List propsWithDefaults = descriptor.getProps().stream().filter(p -> p.hasDefaultField() || p.hasDefaultMethod()).collect(Collectors.toList());
        if (!propsWithDefaults.isEmpty()) {
            MethodSpec.Builder method = MethodSpec.constructorBuilder();
            method.addStatement("_element = $T.createComponentElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
            for (PropDescriptor prop : propsWithDefaults) {
                method.addStatement("_element.props().set( $T.Props.$N, $T.$N" + (prop.hasDefaultField() ? "" : "()") + " )", descriptor.getEnhancedClassName(), prop.getConstantName(), descriptor.getClassName(), prop.hasDefaultField() ? prop.getDefaultField().getSimpleName() : prop.getDefaultMethod().getSimpleName());
            }
            builder.addMethod(method.build());
        }
        HashSet<String> stepMethodsAdded = new HashSet<String>();
        for (Step step : steps) {
            for (StepMethod stepMethod : step.getMethods()) {
                if (!stepMethodsAdded.add(stepMethod.getName() + stepMethod.getType().toString()) || stepMethod.isBuildIntrinsic()) continue;
                builder.addMethod(Generator.buildBuilderStepImpl(descriptor, step, stepMethod));
            }
        }
        FieldSpec.Builder field = FieldSpec.builder(REACT_ELEMENT_CLASSNAME, "_element", Modifier.PRIVATE, Modifier.FINAL);
        if (propsWithDefaults.isEmpty()) {
            field.initializer("$T.createComponentElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
        }
        builder.addField(field.build());
        builder.addMethod(Generator.buildBuildStepImpl());
        return builder.build();
    }

    @Nonnull
    private static TypeName getParameterizedTypeName(@Nonnull ComponentDescriptor descriptor, @Nonnull ClassName baseName) {
        List<? extends TypeMirror> arguments = descriptor.getDeclaredType().getTypeArguments();
        if (arguments.isEmpty()) {
            return baseName;
        }
        return ParameterizedTypeName.get(baseName, (TypeName[])arguments.stream().map(TypeName::get).toArray(TypeName[]::new));
    }

    @Nonnull
    static TypeSpec buildEnhancedComponent(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method;
        Object disposableProps;
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getEnhancedClassName());
        builder.addTypeVariables(ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        builder.superclass(descriptor.getComponentType());
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(AREZ_COMPONENT_CLASSNAME).addMember("name", "$S", descriptor.getName());
            if (descriptor.shouldRunArezScheduler()) {
                annotation.addMember("deferSchedule", "true", new Object[0]);
            }
            if (descriptor.needsInjection()) {
                annotation.addMember("inject", "$T.ENABLE", AREZ_FEATURE_CLASSNAME);
            }
            builder.addAnnotation(annotation.build());
            builder.addModifiers(Modifier.ABSTRACT);
        }
        Generator.addGeneratedAnnotation(descriptor, builder);
        Generator.addOriginatingTypes(descriptor.getElement(), builder);
        builder.addType(Generator.buildFactory());
        if (descriptor.needsInjection()) {
            builder.addType(Generator.buildInjectSupport(descriptor));
        }
        builder.addType(Generator.buildPropsType(descriptor));
        builder.addMethod(Generator.buildConstructorFnMethod(descriptor).build());
        List<PropDescriptor> props = descriptor.getProps();
        if (descriptor.isArezComponent() && !(disposableProps = props.stream().filter(PropDescriptor::isDisposable).collect(Collectors.toList())).isEmpty()) {
            builder.addMethod(Generator.buildAnyPropsDisposedMethod((List<PropDescriptor>)disposableProps).build());
        }
        for (PropDescriptor prop : props) {
            builder.addMethod(Generator.buildPropMethod(descriptor, prop).build());
            if (!descriptor.isArezComponent() || !prop.isObservable()) continue;
            builder.addMethod(Generator.buildPropObservableValueRefMethod(prop).build());
        }
        if (descriptor.hasValidatedProps()) {
            builder.addMethod(Generator.buildPropValidatorMethod(descriptor).build());
        }
        if (descriptor.hasObservableProps() || descriptor.hasOnPropChangedProps()) {
            builder.addMethod(Generator.buildReportPropChangesMethod(descriptor).build());
        }
        if (descriptor.isArezComponent() && null != (method = Generator.buildShouldComponentUpdateMethod(descriptor))) {
            builder.addMethod(method.build());
        }
        if (descriptor.needsInjection() && !descriptor.isArezComponent()) {
            builder.addMethod(MethodSpec.constructorBuilder().addAnnotation(INJECT_CLASSNAME).build());
        }
        if (descriptor.shouldRunArezScheduler() && descriptor.isArezComponent()) {
            builder.addMethod(MethodSpec.methodBuilder("triggerScheduler").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED, Modifier.FINAL).addStatement("getContext().triggerScheduler()", new Object[0]).build());
        }
        if (descriptor.isArezComponent()) {
            for (MethodDescriptor method2 : descriptor.getMemoizeMethods()) {
                builder.addMethod(Generator.buildMemoizeWrapperMethod(method2).build());
            }
        }
        if (!descriptor.getLifecycleMethods().isEmpty()) {
            if (descriptor.shouldGenerateLiteLifecycle() && !descriptor.getLiteLifecycleMethods().isEmpty()) {
                builder.addType(Generator.buildNativeLiteLifecycleInterface(descriptor));
            }
            builder.addType(Generator.buildNativeLifecycleInterface(descriptor));
        }
        if (descriptor.shouldGenerateLiteLifecycle()) {
            builder.addType(Generator.buildNativeComponent(descriptor, true));
        }
        builder.addType(Generator.buildNativeComponent(descriptor, false));
        return builder.build();
    }

    private static FieldSpec.Builder buildPropKeyConstantField(@Nonnull PropDescriptor descriptor, int index) {
        String name = descriptor.getName();
        FieldSpec.Builder field = FieldSpec.builder(TypeName.get(String.class), descriptor.getConstantName(), Modifier.STATIC, Modifier.FINAL);
        if (descriptor.isSpecialChildrenProp()) {
            return field.initializer("$S", "children");
        }
        return field.initializer("$T.shouldMinimizePropKeys() ? $S : $S", REACT_CONFIG_CLASSNAME, Character.toString((char)(97 + index)), name);
    }

    @Nonnull
    private static MethodSpec.Builder buildMemoizeWrapperMethod(@Nonnull MethodDescriptor descriptor) {
        return Generator.generateOverrideMethod(descriptor).addAnnotation(Generator.buildMemoizeAnnotation(descriptor).build());
    }

    @Nonnull
    private static MethodSpec.Builder generateOverrideMethod(@Nonnull MethodDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(descriptor.getMethod().getSimpleName().toString()).addAnnotation(Override.class).returns(TypeName.get(descriptor.getMethodType().getReturnType()));
        ProcessorUtil.copyTypeParameters(descriptor.getMethodType(), method);
        ProcessorUtil.copyAccessModifiers(descriptor.getMethod(), method);
        ProcessorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)descriptor.getMethod(), method);
        int paramCount = descriptor.getMethod().getParameters().size();
        for (int i2 = 0; i2 < paramCount; ++i2) {
            TypeMirror paramType = descriptor.getMethodType().getParameterTypes().get(i2);
            VariableElement param = descriptor.getMethod().getParameters().get(i2);
            ParameterSpec.Builder parameter = ParameterSpec.builder(TypeName.get(paramType), param.getSimpleName().toString(), Modifier.FINAL);
            ProcessorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)param, parameter);
            method.addParameter(parameter.build());
        }
        String params = 0 == paramCount ? "" : IntStream.range(0, paramCount).mapToObj(i -> descriptor.getMethod().getParameters().get(i).getSimpleName().toString()).collect(Collectors.joining(","));
        boolean isVoid = descriptor.getMethodType().getReturnType().getKind() == TypeKind.VOID;
        method.addStatement((isVoid ? "" : "return ") + "super.$N(" + params + ")", descriptor.getMethod().getSimpleName());
        return method;
    }

    @Nonnull
    private static AnnotationSpec.Builder buildMemoizeAnnotation(@Nonnull MethodDescriptor descriptor) {
        AnnotationValue observeLowerPriorityDependenciesValue;
        AnnotationValue depTypeValue;
        AnnotationValue requireEnvironmentValue;
        AnnotationValue reportResultValue;
        AnnotationValue keepAliveValue;
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(MEMOIZE_CLASSNAME).addMember("priority", "$T.LOWEST", PRIORITY_CLASSNAME);
        AnnotationValue nameValue = ProcessorUtil.findDeclaredAnnotationValue(descriptor.getMethod(), "arez.annotations.Memoize", "name");
        if (null != nameValue) {
            annotation.addMember("name", "$S", nameValue.getValue().toString());
        }
        if (null != (keepAliveValue = ProcessorUtil.findDeclaredAnnotationValue(descriptor.getMethod(), "arez.annotations.Memoize", "keepAlive"))) {
            annotation.addMember("keepAlive", "$N", keepAliveValue.getValue().toString());
        }
        if (null != (reportResultValue = ProcessorUtil.findDeclaredAnnotationValue(descriptor.getMethod(), "arez.annotations.Memoize", "reportResult"))) {
            annotation.addMember("reportResult", "$N", reportResultValue.getValue().toString());
        }
        if (null != (requireEnvironmentValue = ProcessorUtil.findDeclaredAnnotationValue(descriptor.getMethod(), "arez.annotations.Memoize", "requireEnvironment"))) {
            annotation.addMember("requireEnvironment", "$N", requireEnvironmentValue.getValue().toString());
        }
        if (null != (depTypeValue = ProcessorUtil.findDeclaredAnnotationValue(descriptor.getMethod(), "arez.annotations.Memoize", "depType"))) {
            annotation.addMember("depType", "$T.$N", DEP_TYPE_CLASSNAME, depTypeValue.getValue().toString());
        }
        if (null != (observeLowerPriorityDependenciesValue = ProcessorUtil.findDeclaredAnnotationValue(descriptor.getMethod(), "arez.annotations.Memoize", "observeLowerPriorityDependencies"))) {
            annotation.addMember("observeLowerPriorityDependencies", "$N", observeLowerPriorityDependenciesValue.getValue().toString());
        }
        return annotation;
    }

    @Nonnull
    private static MethodSpec.Builder buildAnyPropsDisposedMethod(@Nonnull List<PropDescriptor> props) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("anyPropsDisposed").addModifiers(Modifier.PROTECTED, Modifier.FINAL).addAnnotation(Override.class).returns(TypeName.BOOLEAN);
        for (PropDescriptor prop : props) {
            String varName = "$$react4jv$$_" + prop.getMethod().getSimpleName();
            method.addStatement("final $T $N = $N()", prop.getMethodType().getReturnType(), varName, prop.getMethod().getSimpleName().toString());
            CodeBlock.Builder block = CodeBlock.builder();
            if (prop.isOptional()) {
                block.beginControlFlow("if ( null != $N && $T.isDisposed( $N ) )", varName, DISPOSABLE_CLASSNAME, varName);
            } else {
                block.beginControlFlow("if ( $T.isDisposed( $N ) )", DISPOSABLE_CLASSNAME, varName);
            }
            block.addStatement("return true", new Object[0]);
            block.endControlFlow();
            method.addCode(block.build());
        }
        method.addStatement("return false", new Object[0]);
        return method;
    }

    private static MethodSpec.Builder buildPropMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull PropDescriptor prop) {
        ExecutableElement methodElement = prop.getMethod();
        ExecutableType methodType = prop.getMethodType();
        TypeMirror returnType = methodType.getReturnType();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodElement.getSimpleName().toString()).returns(TypeName.get(returnType));
        ProcessorUtil.copyTypeParameters(methodType, method);
        ProcessorUtil.copyAccessModifiers(methodElement, method);
        ProcessorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)methodElement, method);
        method.addAnnotation(Override.class);
        if (descriptor.isArezComponent() && prop.isObservable()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(OBSERVABLE_ANNOTATION_CLASSNAME).addMember("name", "$S", prop.getName()).addMember("expectSetter", "false", new Object[0]).addMember("readOutsideTransaction", "true", new Object[0]);
            method.addAnnotation(annotation.build());
        }
        String convertMethodName = Generator.getConverter(returnType, methodElement);
        TypeKind resultKind = methodElement.getReturnType().getKind();
        if (!resultKind.isPrimitive() && null == Generator.isNonnull(methodElement)) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CONFIG_CLASSNAME);
            block.addStatement("return null != props().getAny( Props.$N ) ? props().getAny( Props.$N ).$N() : null", prop.getConstantName(), prop.getConstantName(), convertMethodName);
            block.nextControlFlow("else", new Object[0]);
            block.addStatement("return $T.uncheckedCast( props().getAny( Props.$N ) )", JS_CLASSNAME, prop.getConstantName());
            block.endControlFlow();
            method.addCode(block.build());
        } else {
            method.addStatement("return props().getAny( Props.$N ).$N()", prop.getConstantName(), convertMethodName);
        }
        return method;
    }

    @Nonnull
    private static String getConverter(@Nonnull TypeMirror type, @Nonnull Element element) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "asBoolean";
            }
            case BYTE: {
                return "asByte";
            }
            case CHAR: {
                return "asChar";
            }
            case DOUBLE: {
                return "asDouble";
            }
            case FLOAT: {
                return "asFloat";
            }
            case INT: {
                return "asInt";
            }
            case LONG: {
                return "asLong";
            }
            case SHORT: {
                return "asShort";
            }
            case TYPEVAR: {
                return "cast";
            }
            case DECLARED: {
                if (type.toString().equals("java.lang.String")) {
                    return "asString";
                }
                return "cast";
            }
            case ARRAY: {
                return "cast";
            }
        }
        throw new ReactProcessorException("Return type of @Prop method is not yet handled. Type: " + (Object)((Object)type.getKind()), element);
    }

    @Nonnull
    private static MethodSpec.Builder buildPropObservableValueRefMethod(@Nonnull PropDescriptor prop) {
        return MethodSpec.methodBuilder(Generator.toObservableValueRefMethodName(prop)).addModifiers(Modifier.PROTECTED, Modifier.ABSTRACT).addAnnotation(NONNULL_CLASSNAME).addAnnotation(OBSERVABLE_VALUE_REF_ANNOTATION_CLASSNAME).returns(OBSERVABLE_CLASSNAME);
    }

    @Nonnull
    private static String toObservableValueRefMethodName(@Nonnull PropDescriptor prop) {
        String name = prop.getName();
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "ObservableValue";
    }

    @Nonnull
    private static MethodSpec.Builder buildReportPropChangesMethod(@Nonnull ComponentDescriptor descriptor) {
        List props = descriptor.getProps().stream().filter(p -> p.isObservable() || p.hasOnPropChangedMethod()).collect(Collectors.toList());
        assert (!props.isEmpty());
        MethodSpec.Builder method = MethodSpec.methodBuilder("reportPropChanges").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "props", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextProps", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).addParameter(ParameterSpec.builder(TypeName.BOOLEAN, "inComponentDidUpdate", Modifier.FINAL).build()).returns(TypeName.BOOLEAN);
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(ACTION_CLASSNAME).addMember("verifyRequired", "false", new Object[0]);
            method.addAnnotation(annotation.build());
        }
        method.addStatement("boolean modified = false", new Object[0]);
        if (props.stream().anyMatch(PropDescriptor::isObservable)) {
            method.addStatement("final boolean reportChanges = shouldReportPropChanges( inComponentDidUpdate )", new Object[0]);
        }
        for (PropDescriptor prop : props) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( !$T.isTripleEqual( props.get( Props.$N ), nextProps.get( Props.$N ) ) )", JS_CLASSNAME, prop.getConstantName(), prop.getConstantName());
            if (prop.isObservable()) {
                CodeBlock.Builder reportBlock = CodeBlock.builder();
                reportBlock.beginControlFlow("if ( reportChanges )", new Object[0]);
                reportBlock.addStatement("$N().reportChanged()", Generator.toObservableValueRefMethodName(prop));
                reportBlock.endControlFlow();
                block.add(reportBlock.build());
            }
            if (prop.hasOnPropChangedMethod()) {
                CodeBlock.Builder onChangeBlock = CodeBlock.builder();
                onChangeBlock.beginControlFlow("if ( inComponentDidUpdate )", new Object[0]);
                ExecutableElement onPropChangedMethod = prop.getPropChangedMethod();
                if (onPropChangedMethod.getParameters().isEmpty()) {
                    onChangeBlock.addStatement("$N()", onPropChangedMethod.getSimpleName().toString());
                } else {
                    String convertMethodName = Generator.getConverter(prop.getMethod().getReturnType(), prop.getMethod());
                    TypeKind resultKind = prop.getMethod().getReturnType().getKind();
                    if (!resultKind.isPrimitive() && null == Generator.isNonnull(prop.getMethod())) {
                        onChangeBlock.addStatement("$N( $T.uncheckedCast( props.getAny( Props.$N ) ) )", onPropChangedMethod.getSimpleName().toString(), JS_CLASSNAME, prop.getConstantName());
                    } else {
                        onChangeBlock.addStatement("$N( props.getAny( Props.$N ).$N() )", onPropChangedMethod.getSimpleName().toString(), prop.getConstantName(), convertMethodName);
                    }
                }
                onChangeBlock.endControlFlow();
                block.add(onChangeBlock.build());
            }
            if (prop.shouldUpdateOnChange()) {
                block.addStatement("modified = true", new Object[0]);
            }
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (descriptor.isArezComponent()) {
            method.addStatement("return modified || hasRenderDepsChanged()", new Object[0]);
        } else {
            method.addStatement("return modified", new Object[0]);
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildPropValidatorMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("validatePropValues").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED, Modifier.FINAL).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "props", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        for (PropDescriptor prop : descriptor.getProps()) {
            CodeBlock.Builder block;
            boolean isNonNull;
            String name = prop.getName();
            String rawName = "raw$" + name;
            String typedName = "typed$" + name;
            method.addStatement("final $T $N = props.get( Props.$N )", Object.class, rawName, prop.getConstantName());
            boolean bl = isNonNull = null != Generator.isNonnull(prop.getMethod());
            if (!prop.isOptional() && isNonNull) {
                block = CodeBlock.builder();
                block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CONFIG_CLASSNAME);
                block.addStatement("$T.apiInvariant( () -> null != $N, () -> \"Required prop named '$N' is missing from component named '$N' so it was either incorrectly omitted or a null value has been incorrectly specified.\" ) ", GUARDS_CLASSNAME, rawName, prop.getName(), descriptor.getName());
                block.endControlFlow();
                method.addCode(block.build());
            }
            block = CodeBlock.builder();
            block.beginControlFlow("if ( null != $N )", rawName);
            TypeMirror returnType = prop.getMethodType().getReturnType();
            block.addStatement("final $T $N = $T.$N( $N )", returnType, typedName, JS_CLASSNAME, Generator.getConverter(returnType, prop.getMethod()), rawName);
            if (prop.hasValidateMethod()) {
                block.addStatement("$N( $N )", prop.getValidateMethod().getSimpleName().toString(), typedName);
            }
            block.endControlFlow();
            method.addCode(block.build());
        }
        return method;
    }

    @Nullable
    private static MethodSpec.Builder buildShouldComponentUpdateMethod(@Nonnull ComponentDescriptor descriptor) {
        List props = descriptor.getProps().stream().filter(PropDescriptor::shouldUpdateOnChange).filter(p -> !p.isObservable()).collect(Collectors.toList());
        if (props.isEmpty()) {
            return null;
        }
        MethodSpec.Builder method = MethodSpec.methodBuilder("shouldUpdateOnPropChanges").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextProps", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).returns(TypeName.BOOLEAN);
        for (PropDescriptor prop : descriptor.getProps()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( !$T.isTripleEqual( props().get( Props.$N ), nextProps.get( Props.$N ) ) )", JS_CLASSNAME, prop.getConstantName(), prop.getConstantName());
            block.addStatement("return true", new Object[0]);
            block.endControlFlow();
            method.addCode(block.build());
        }
        method.addStatement("return false", new Object[0]);
        return method;
    }

    private static FieldSpec.Builder buildProviderField(@Nonnull ComponentDescriptor descriptor) {
        return FieldSpec.builder(ParameterizedTypeName.get(PROVIDER_CLASSNAME, TypeName.get(descriptor.getDeclaredType())), "c_provider", Modifier.STATIC, Modifier.PRIVATE);
    }

    @Nonnull
    private static MethodSpec.Builder buildSetProviderMethod(@Nonnull ComponentDescriptor descriptor) {
        return MethodSpec.methodBuilder("setProvider").addModifiers(Modifier.STATIC).addParameter(ParameterizedTypeName.get(PROVIDER_CLASSNAME, TypeName.get(descriptor.getDeclaredType())), "provider", Modifier.FINAL).addStatement("c_provider = provider", new Object[0]);
    }

    @Nonnull
    private static MethodSpec.Builder buildGetProviderMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("getProvider").addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns(ParameterizedTypeName.get(PROVIDER_CLASSNAME, TypeName.get(descriptor.getDeclaredType())));
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CONFIG_CLASSNAME);
        block.addStatement("$T.invariant( () -> null != c_provider, () -> \"Attempted to create an instance of the React4j component named '$N' before the dependency injection provider has been initialized. Please see the documentation at https://react4j.github.io/dependency_injection for directions how to configure dependency injection.\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        return method.addStatement("return c_provider", new Object[0]);
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructorFnMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("getConstructorFunction").addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.STATIC, Modifier.PRIVATE).returns(COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME);
        boolean shouldGenerateLiteLifecycle = descriptor.shouldGenerateLiteLifecycle();
        if (shouldGenerateLiteLifecycle) {
            method.addStatement("final $T componentConstructor = ( $T.shouldStoreDebugDataAsState() || $T.shouldValidatePropValues() ) ? $T::new : $T::new", COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, REACT_CONFIG_CLASSNAME, REACT_CONFIG_CLASSNAME, ClassName.bestGuess("NativeReactComponent"), ClassName.bestGuess("LiteNativeReactComponent"));
        } else {
            method.addStatement("final $T componentConstructor = $T::new", COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, ClassName.bestGuess("NativeReactComponent"));
        }
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( $T.enableComponentNames() )", REACT_CONFIG_CLASSNAME);
        codeBlock.addStatement("$T.asPropertyMap( componentConstructor ).set( \"displayName\", $S )", JS_CLASSNAME, descriptor.getName());
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        method.addStatement("return componentConstructor", new Object[0]);
        return method;
    }

    @Nonnull
    private static TypeSpec buildPropsType(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Props");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        List<PropDescriptor> props = descriptor.getProps();
        int propCount = props.size();
        for (int i = 0; i < propCount; ++i) {
            builder.addField(Generator.buildPropKeyConstantField(props.get(i), i).build());
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildFactory() {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Factory");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        FieldSpec.Builder field = FieldSpec.builder(COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, "TYPE", Modifier.STATIC, Modifier.FINAL).initializer("getConstructorFunction()", new Object[0]);
        builder.addField(field.build());
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildInjectSupport(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.needsInjection());
        TypeSpec.Builder builder = TypeSpec.classBuilder("InjectSupport");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        builder.addField(Generator.buildProviderField(descriptor).build());
        builder.addMethod(Generator.buildSetProviderMethod(descriptor).build());
        builder.addMethod(Generator.buildGetProviderMethod(descriptor).build());
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildNativeComponent(@Nonnull ComponentDescriptor descriptor, boolean lite) {
        List<MethodDescriptor> lifecycleMethods;
        TypeSpec.Builder builder = TypeSpec.classBuilder((lite ? "Lite" : "") + "NativeReactComponent");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        builder.addModifiers(Modifier.PRIVATE);
        ParameterizedTypeName superType = ParameterizedTypeName.get(REACT_NATIVE_ADAPTER_COMPONENT_CLASSNAME, descriptor.getComponentType());
        builder.superclass(superType);
        builder.addTypeVariables(ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        List<MethodDescriptor> list = lifecycleMethods = lite ? descriptor.getLiteLifecycleMethods() : descriptor.getLifecycleMethods();
        if (!lifecycleMethods.isEmpty()) {
            builder.addSuperinterface(ClassName.bestGuess((lite ? "Lite" : "") + "Lifecycle"));
        }
        ParameterSpec.Builder props = ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "props", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addParameter(props.build());
        method.addAnnotation(JS_CONSTRUCTOR_CLASSNAME);
        method.addStatement("super( props )", new Object[0]);
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder("createComponent").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(descriptor.getComponentType());
        if (descriptor.needsInjection()) {
            method2.addStatement("return InjectSupport.getProvider().get()", new Object[0]);
        } else {
            String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method2.addStatement("return new $T" + infix + "()", descriptor.getClassNameToConstruct());
        }
        builder.addMethod(method2.build());
        for (MethodDescriptor lifecycleMethod : lifecycleMethods) {
            builder.addMethod(Generator.buildLifecycleMethod(lifecycleMethod).build());
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildLifecycleMethod(@Nonnull MethodDescriptor descriptor) {
        String methodName = descriptor.getMethod().getSimpleName().toString();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(ClassName.get(descriptor.getMethodType().getReturnType()));
        ProcessorUtil.copyTypeParameters(descriptor.getMethodType(), method);
        if ("componentDidUpdate".equals(methodName)) {
            method.addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevProps", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
            method.addStatement("performComponentDidUpdate( prevProps )", new Object[0]);
        } else if ("componentDidMount".equals(methodName)) {
            method.addStatement("performComponentDidMount()", new Object[0]);
        } else if ("componentWillUnmount".equals(methodName)) {
            method.addStatement("performComponentWillUnmount()", new Object[0]);
        } else if ("shouldComponentUpdate".equals(methodName)) {
            method.addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextProps", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
            method.addStatement("return performShouldComponentUpdate( nextProps )", new Object[0]);
        } else {
            assert ("componentDidCatch".equals(methodName));
            method.addParameter(ParameterSpec.builder(JS_ERROR_CLASSNAME, "error", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
            method.addParameter(ParameterSpec.builder(REACT_ERROR_INFO_CLASSNAME, "info", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
            method.addStatement("performComponentDidCatch( error, info )", new Object[0]);
        }
        return method;
    }

    private static String asTypeArgumentsInfix(DeclaredType declaredType) {
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.isEmpty() ? "" : "<" + typeArguments.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")) + ">";
    }

    @Nonnull
    private static TypeSpec buildNativeLiteLifecycleInterface(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("LiteLifecycle");
        builder.addAnnotation(AnnotationSpec.builder(JS_TYPE_CLASSNAME).addMember("isNative", "true", new Object[0]).addMember("namespace", "$T.GLOBAL", JS_PACKAGE_CLASSNAME).addMember("name", "$S", "?").build());
        builder.addModifiers(Modifier.STATIC);
        for (MethodDescriptor method : descriptor.getLiteLifecycleMethods()) {
            Generator.buildLfecycleMethod(builder, method);
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildNativeLifecycleInterface(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Lifecycle");
        builder.addAnnotation(AnnotationSpec.builder(JS_TYPE_CLASSNAME).addMember("isNative", "true", new Object[0]).addMember("namespace", "$T.GLOBAL", JS_PACKAGE_CLASSNAME).addMember("name", "$S", "?").build());
        builder.addModifiers(Modifier.STATIC);
        descriptor.getLifecycleMethods().forEach(method -> Generator.buildLfecycleMethod(builder, method));
        return builder.build();
    }

    private static void buildLfecycleMethod(@Nonnull TypeSpec.Builder builder, @Nonnull MethodDescriptor lifecycleMethod) {
        String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).returns(ClassName.get(lifecycleMethod.getMethodType().getReturnType()));
        ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method);
        if ("componentDidUpdate".equals(methodName)) {
            method.addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevProps", new Modifier[0]).addAnnotation(NONNULL_CLASSNAME).build());
        } else if ("shouldComponentUpdate".equals(methodName)) {
            method.addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextProps", new Modifier[0]).addAnnotation(NONNULL_CLASSNAME).build());
        } else if ("componentDidCatch".equals(methodName)) {
            method.addParameter(ParameterSpec.builder(JS_ERROR_CLASSNAME, "error", new Modifier[0]).addAnnotation(NONNULL_CLASSNAME).build());
            method.addParameter(ParameterSpec.builder(REACT_ERROR_INFO_CLASSNAME, "info", new Modifier[0]).addAnnotation(NONNULL_CLASSNAME).build());
        }
        builder.addMethod(method.build());
    }

    @Nonnull
    static TypeSpec buildDaggerFactory(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder(descriptor.getDaggerFactoryClassName());
        Generator.addGeneratedAnnotation(descriptor, builder);
        Generator.addOriginatingTypes(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PUBLIC);
        MethodSpec.Builder method = MethodSpec.methodBuilder("get" + descriptor.getName() + "DaggerSubcomponent").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ClassName.bestGuess("DaggerSubcomponent"));
        builder.addMethod(method.build());
        method = MethodSpec.methodBuilder("bind" + descriptor.getName()).addModifiers(Modifier.PUBLIC, Modifier.DEFAULT);
        if (descriptor.getElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            method.addStatement("$T.InjectSupport.setProvider( $N().createProvider() )", descriptor.getEnhancedClassName(), "get" + descriptor.getName() + "DaggerSubcomponent");
        } else {
            method.addStatement("$T.InjectSupport.setProvider( () -> ($T) $N().createProvider().get() )", descriptor.getEnhancedClassName(), descriptor.getClassName(), "get" + descriptor.getName() + "DaggerSubcomponent");
        }
        builder.addMethod(method.build());
        if (descriptor.needsDaggerIntegration()) {
            builder.addType(Generator.buildDaggerModule(descriptor));
            builder.addType(Generator.buildDaggerComponent(descriptor));
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildDaggerComponent(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("DaggerSubcomponent");
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        AnnotationSpec.Builder subcomponent = AnnotationSpec.builder(ClassName.bestGuess("dagger.Subcomponent"));
        subcomponent.addMember("modules", "DaggerModule.class", new Object[0]);
        builder.addAnnotation(subcomponent.build());
        if (descriptor.getElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            MethodSpec.Builder method = MethodSpec.methodBuilder("createProvider").addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).returns(ParameterizedTypeName.get(PROVIDER_CLASSNAME, descriptor.getClassName()));
            builder.addMethod(method.build());
        } else {
            MethodSpec.Builder method = MethodSpec.methodBuilder("createProvider").addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).returns(ParameterizedTypeName.get(PROVIDER_CLASSNAME, COMPONENT_CLASSNAME));
            builder.addMethod(method.build());
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildDaggerModule(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("DaggerModule");
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.addAnnotation(ClassName.bestGuess("dagger.Module"));
        MethodSpec.Builder method = MethodSpec.methodBuilder("bindComponent").addAnnotation(ClassName.bestGuess("dagger.Binds")).addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).addParameter(descriptor.getClassNameToConstruct(), "component", new Modifier[0]).returns(descriptor.getClassName());
        if (descriptor.getElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            method.returns(descriptor.getClassName());
        } else {
            method.returns(COMPONENT_CLASSNAME);
        }
        builder.addMethod(method.build());
        return builder.build();
    }

    @Nonnull
    private static BuilderDescriptor buildBuilderDescriptor(@Nonnull ComponentDescriptor descriptor) {
        BuilderDescriptor builder = new BuilderDescriptor();
        Step optionalPropStep = null;
        List<PropDescriptor> props = descriptor.getProps();
        int propsSize = props.size();
        Step keyStep = builder.addStep();
        StepMethodType keyStepMethodType = 0 == propsSize ? StepMethodType.TERMINATE : StepMethodType.ADVANCE;
        keyStep.addMethod("key", "key", TypeName.get(String.class), keyStepMethodType);
        keyStep.addMethod("key", "*key_int*", TypeName.INT, keyStepMethodType);
        boolean hasSingleOptional = props.stream().filter(PropDescriptor::isOptional).count() == 1L;
        boolean hasRequiredAfterOptional = false;
        for (int i = 0; i < propsSize; ++i) {
            boolean isLast;
            PropDescriptor prop = props.get(i);
            boolean bl = isLast = i == propsSize - 1;
            if (prop.isOptional()) {
                if (null == optionalPropStep) {
                    optionalPropStep = builder.addStep();
                }
                if (prop.getName().equals("children")) {
                    Generator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                Generator.addPropStepMethod(optionalPropStep, prop, hasSingleOptional ? StepMethodType.TERMINATE : StepMethodType.STAY);
                continue;
            }
            if (null != optionalPropStep) {
                Generator.addPropStepMethod(optionalPropStep, prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
                if (prop.getName().equals("children")) {
                    Generator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                hasRequiredAfterOptional = true;
            }
            Step step = builder.addStep();
            Generator.addPropStepMethod(step, prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
            if (!prop.getName().equals("children")) continue;
            Generator.addChildrenStreamPropStepMethod(step);
            Generator.addBuildStep(step);
        }
        if (null != optionalPropStep && !hasRequiredAfterOptional) {
            Generator.addBuildStep(optionalPropStep);
        }
        if (props.isEmpty()) {
            Generator.addBuildStep(builder.addStep());
        }
        return builder;
    }

    private static void addBuildStep(@Nonnull Step step) {
        step.addMethod("build", "build", REACT_NODE_CLASSNAME, StepMethodType.TERMINATE);
    }

    private static void addChildrenStreamPropStepMethod(@Nonnull Step step) {
        ParameterizedTypeName typeName = ParameterizedTypeName.get(ClassName.get(Stream.class), WildcardTypeName.subtypeOf(REACT_NODE_CLASSNAME));
        step.addMethod("children", "*children_stream*", typeName, StepMethodType.TERMINATE);
    }

    private static void addPropStepMethod(@Nonnull Step step, @Nonnull PropDescriptor prop, @Nonnull StepMethodType stepMethodType) {
        step.addMethod(prop, stepMethodType);
    }

    private static void addOriginatingTypes(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        builder.addOriginatingElement(element);
        ProcessorUtil.getSuperTypes(element).forEach(builder::addOriginatingElement);
    }

    private static void addGeneratedAnnotation(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeSpec.Builder builder) {
        GeneratedAnnotationSpecs.generatedAnnotationSpec(descriptor.getElements(), descriptor.getSourceVersion(), ReactProcessor.class).ifPresent(builder::addAnnotation);
    }
}

