/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.lang.annotation.Documented;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import react4j.processor.ReactProcessorException;
import react4j.processor.vendor.javapoet.AnnotationSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.TypeVariableName;

final class ProcessorUtil {
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set([A-Z].*)$");
    private static final Pattern GETTER_PATTERN = Pattern.compile("^get([A-Z].*)$");
    static final Pattern DEFAULT_GETTER_PATTERN = Pattern.compile("^get([A-Z].*)Default$");
    private static final Pattern ISSER_PATTERN = Pattern.compile("^is([A-Z].*)$");
    static final String SENTINEL_NAME = "<default>";

    private ProcessorUtil() {
    }

    @Nonnull
    static List<TypeElement> getSuperTypes(@Nonnull TypeElement element) {
        ArrayList<TypeElement> superTypes = new ArrayList<TypeElement>();
        ProcessorUtil.enumerateSuperTypes(element, superTypes);
        return superTypes;
    }

    private static void enumerateSuperTypes(@Nonnull TypeElement element, @Nonnull List<TypeElement> superTypes) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            superTypes.add(superclassElement);
            ProcessorUtil.enumerateSuperTypes(superclassElement, superTypes);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ProcessorUtil.enumerateSuperTypes(interfaceElement, superTypes);
        }
    }

    @Nonnull
    static List<TypeVariableName> getTypeArgumentsAsNames(@Nonnull DeclaredType declaredType) {
        return declaredType.getTypeArguments().stream().map(argument -> TypeVariableName.get((TypeVariable)argument)).collect(Collectors.toList());
    }

    @Nonnull
    static List<ExecutableElement> getMethods(@Nonnull TypeElement element, @Nonnull Types typeUtils) {
        LinkedHashMap<String, ExecutableElement> methodMap = new LinkedHashMap<String, ExecutableElement>();
        ProcessorUtil.enumerateMethods(element, typeUtils, element, methodMap);
        return new ArrayList<ExecutableElement>(methodMap.values());
    }

    private static void enumerateMethods(@Nonnull TypeElement scope, @Nonnull Types typeUtils, @Nonnull TypeElement element, @Nonnull Map<String, ExecutableElement> methods) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ProcessorUtil.enumerateMethods(scope, typeUtils, (TypeElement)((DeclaredType)superclass).asElement(), methods);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ProcessorUtil.enumerateMethods(scope, typeUtils, interfaceElement, methods);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD) continue;
            ExecutableType methodType = (ExecutableType)typeUtils.asMemberOf((DeclaredType)scope.asType(), element2);
            methods.put(element2.getSimpleName() + methodType.toString(), (ExecutableElement)element2);
        }
    }

    @Nonnull
    static List<VariableElement> getFieldElements(@Nonnull TypeElement element) {
        LinkedHashMap<String, VariableElement> methodMap = new LinkedHashMap<String, VariableElement>();
        ProcessorUtil.enumerateFieldElements(element, methodMap);
        return new ArrayList<VariableElement>(methodMap.values());
    }

    private static void enumerateFieldElements(@Nonnull TypeElement element, @Nonnull Map<String, VariableElement> fields) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ProcessorUtil.enumerateFieldElements((TypeElement)((DeclaredType)superclass).asElement(), fields);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.FIELD) continue;
            fields.put(element2.getSimpleName().toString(), (VariableElement)element2);
        }
    }

    static void copyAccessModifiers(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        }
    }

    static void copyAccessModifiers(@Nonnull ExecutableElement element, @Nonnull MethodSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        } else if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            builder.addModifiers(Modifier.PROTECTED);
        }
    }

    static void copyDocumentedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull MethodSpec.Builder builder) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!ProcessorUtil.shouldCopyAnnotation(annotationMirror)) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    static void copyDocumentedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull ParameterSpec.Builder builder) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!ProcessorUtil.shouldCopyAnnotation(annotationMirror)) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    private static boolean shouldCopyAnnotation(@Nonnull AnnotationMirror annotation) {
        return !annotation.getAnnotationType().toString().startsWith("react4j.annotations.") && null != annotation.getAnnotationType().asElement().getAnnotation(Documented.class);
    }

    static void copyTypeParameters(@Nonnull ExecutableType action, @Nonnull MethodSpec.Builder builder) {
        for (TypeVariable typeVariable : action.getTypeVariables()) {
            builder.addTypeVariable(TypeVariableName.get(typeVariable));
        }
    }

    static void copyTypeParameters(@Nonnull TypeElement element, @Nonnull MethodSpec.Builder builder) {
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(typeParameterElement));
        }
    }

    static void copyTypeParameters(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(typeParameterElement));
        }
    }

    @Nonnull
    static String getPropertyAccessorName(@Nonnull ExecutableElement method, @Nonnull String specifiedName) throws ReactProcessorException {
        String name = ProcessorUtil.deriveName(method, GETTER_PATTERN, specifiedName);
        if (null != name) {
            return name;
        }
        if (method.getReturnType().getKind() == TypeKind.BOOLEAN && null != (name = ProcessorUtil.deriveName(method, ISSER_PATTERN, specifiedName))) {
            return name;
        }
        return method.getSimpleName().toString();
    }

    @Nonnull
    static String getPropertyMutatorName(@Nonnull ExecutableElement method, @Nonnull String specifiedName) throws ReactProcessorException {
        String name = ProcessorUtil.deriveName(method, SETTER_PATTERN, specifiedName);
        if (null != name) {
            return name;
        }
        return method.getSimpleName().toString();
    }

    @Nullable
    static String deriveName(@Nonnull Element method, @Nonnull Pattern pattern, @Nonnull String name) throws ReactProcessorException {
        if (ProcessorUtil.isSentinelName(name)) {
            String methodName = method.getSimpleName().toString();
            Matcher matcher = pattern.matcher(methodName);
            if (matcher.find()) {
                String candidate = matcher.group(1);
                return Character.toLowerCase(candidate.charAt(0)) + candidate.substring(1);
            }
            return null;
        }
        return name;
    }

    static boolean isSentinelName(@Nonnull String name) {
        return SENTINEL_NAME.equals(name);
    }

    @Nullable
    static DeclaredType getTypeMirrorAnnotationParameter(@Nonnull Elements elements, @Nonnull Element typeElement, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationValue annotationValue = ProcessorUtil.findAnnotationValue(elements, typeElement, annotationClassName, parameterName);
        return null == annotationValue ? null : (DeclaredType)annotationValue.getValue();
    }

    @Nonnull
    static AnnotationValue getAnnotationValue(@Nonnull Elements elements, @Nonnull Element typeElement, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationValue value = ProcessorUtil.findAnnotationValue(elements, typeElement, annotationClassName, parameterName);
        assert (null != value);
        return value;
    }

    @Nullable
    static AnnotationValue findAnnotationValue(@Nonnull Elements elements, @Nonnull Element typeElement, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationMirror mirror = ProcessorUtil.findAnnotationByType(typeElement, annotationClassName);
        if (null == mirror) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = elements.getElementValuesWithDefaults(mirror);
        ExecutableElement annotationKey = values.keySet().stream().filter(k -> parameterName.equals(k.getSimpleName().toString())).findFirst().orElse(null);
        return values.get(annotationKey);
    }

    @Nullable
    static AnnotationMirror findAnnotationByType(@Nonnull Element typeElement, @Nonnull String annotationClassName) {
        return typeElement.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(annotationClassName)).findFirst().orElse(null);
    }

    @Nonnull
    static String toSimpleName(@Nonnull String annotationName) {
        return annotationName.replaceAll(".*\\.", "");
    }
}

