/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.refcodes.cli.ArrayOperand;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Flag;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.Syntaxable;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public final class CliUtility {
    private CliUtility() {
    }

    public static boolean contains(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        return arrayList.contains(string);
    }

    public static boolean isOptionArgument(String string) {
        for (int i = 0; i < CommandArgPrefix.toPrefixes().length; ++i) {
            if (!string.startsWith(CommandArgPrefix.toPrefixes()[i])) continue;
            return true;
        }
        return false;
    }

    public static Relation<String, String> getOptionArgument(Option<?> option, String[] stringArray, String[] stringArray2) {
        if (stringArray.length < 2) {
            return null;
        }
        Relation<String, String> relation = CliUtility.getOptionArgument(stringArray, option.getShortOption(), stringArray2);
        if (relation != null) {
            return relation;
        }
        relation = CliUtility.getOptionArgument(stringArray, option.getLongOption(), stringArray2);
        if (relation != null) {
            return relation;
        }
        return null;
    }

    @SafeVarargs
    public static String[] toArgs(List<? extends Operand<?>> ... listArray) {
        if (listArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (List<Operand<?>> list : listArray) {
                if (list == null) continue;
                for (Operand<?> operand : list) {
                    if (operand.getArgs() == null) continue;
                    arrayList.addAll(Arrays.asList(operand.getArgs()));
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    public static String[] toDiff(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = 0;
        block0: for (String string : stringArray2) {
            String string2;
            int n2;
            for (n2 = n; n2 < arrayList.size(); ++n2) {
                string2 = (String)arrayList.get(n2);
                if (!string.equals(string2)) continue;
                arrayList.remove(n2);
                n = n2;
                continue block0;
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                string2 = (String)arrayList.get(n2);
                if (!string.equals(string2)) continue;
                arrayList.remove(n2);
                n = n2;
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] toDiff(String[] stringArray, List<? extends Operand<?>> list) {
        String[] stringArray2 = CliUtility.toArgs(list);
        return CliUtility.toDiff(stringArray, stringArray2);
    }

    public static String toParameterSpec(Operand<?> operand) {
        if (operand instanceof ArrayOperand) {
            ArrayOperand arrayOperand = (ArrayOperand)operand;
            return CliUtility.toParameterSpec(operand, arrayOperand.getMinLength(), arrayOperand.getMaxLength());
        }
        return CliUtility.toParameterSpec(operand, -1, -1);
    }

    public static String toParameterSpec(Operand<?> operand, int n, int n2) {
        if (operand.getAlias() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!(operand instanceof Flag) && operand.getAlias() != null) {
            if (operand instanceof Option) {
                stringBuilder.append('<');
            }
            stringBuilder.append(operand.getAlias());
            if (operand.getType().isArray()) {
                stringBuilder.append("[");
            } else if (n != -1 || n2 != -1) {
                stringBuilder.append("{");
            }
            if (n != -1 && n == n2) {
                stringBuilder.append(n);
            } else {
                if (n != -1) {
                    stringBuilder.append(n);
                }
                if (operand.getType().isArray() || n != -1 || n2 != -1) {
                    stringBuilder.append("...");
                }
                if (n2 != -1) {
                    stringBuilder.append(n2);
                }
            }
            if (operand.getType().isArray()) {
                stringBuilder.append("]");
            } else if (n != -1 || n2 != -1) {
                stringBuilder.append("}");
            }
            if (operand instanceof Option) {
                stringBuilder.append('>');
            }
        }
        return stringBuilder.toString();
    }

    public static String toOptionsSpec(Operand<?> operand) {
        StringBuilder stringBuilder = new StringBuilder();
        if (operand instanceof Option) {
            Option option = (Option)operand;
            if (option.getShortOption() != null) {
                stringBuilder.append(option.getShortOption());
            }
            if (option.getLongOption() != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(option.getLongOption());
            }
        }
        return stringBuilder.toString();
    }

    public static String toSpec(Operand<?> operand) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CliUtility.toOptionsSpec(operand));
        String string = CliUtility.toParameterSpec(operand);
        if (string != null && string.length() != 0 && stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    static String[] toOptions(Syntaxable syntaxable) {
        Syntaxable syntaxable2;
        HashSet<String> hashSet = new HashSet<String>();
        if (syntaxable instanceof Condition) {
            syntaxable2 = (Condition)syntaxable;
            for (Operand<?> operand : syntaxable2.toOperands()) {
                String[] stringArray = CliUtility.toOptions(operand);
                if (stringArray == null || stringArray.length == 0) continue;
                hashSet.addAll(Arrays.asList(stringArray));
            }
        }
        if (syntaxable instanceof Option) {
            syntaxable2 = (Option)syntaxable;
            if (syntaxable2.getShortOption() != null && syntaxable2.getShortOption().length() != 0) {
                hashSet.add(syntaxable2.getShortOption());
            }
            if (syntaxable2.getLongOption() != null && syntaxable2.getLongOption().length() != 0) {
                hashSet.add(syntaxable2.getLongOption());
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static Relation<String, String> getOptionArgument(String[] stringArray, String string, String[] stringArray2) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            String string3 = stringArray[i + 1];
            for (String string4 : stringArray2) {
                if (!string3.equalsIgnoreCase(string4)) continue;
                return null;
            }
            return new RelationImpl((Object)string, (Object)string3);
        }
        return null;
    }
}

