/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class OrCondition
extends AbstractCondition
implements Condition {
    private static final String GNU_POSIX_OR = " ? ";
    private static final String LOGICAL_OR = " | ";

    public OrCondition(Syntaxable ... syntaxableArray) {
        super(syntaxableArray);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] stringArray, String[] stringArray2) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        ArrayList arrayList = null;
        for (Syntaxable syntaxable : this.getChildren()) {
            try {
                List<? extends Operand<?>> list = syntaxable.parseArgs(stringArray, stringArray2);
                if (list != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.addAll(list);
                }
                stringArray = CliUtility.toDiff(stringArray, list);
            }
            catch (AmbiguousArgsException | UnknownArgsException argsMismatchException) {}
        }
        if (arrayList != null) {
            return arrayList;
        }
        throw new UnknownArgsException(stringArray, "Not any operand (option) matched the provided command line arguments; though at least one must match.");
    }

    @Override
    public String toUsage(SyntaxNotation syntaxNotation, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() != 0) {
                if (syntaxNotation == SyntaxNotation.REFCODES) {
                    stringBuilder.append(LOGICAL_OR);
                } else {
                    stringBuilder.append(GNU_POSIX_OR);
                }
            }
            stringBuilder.append(syntaxable.toSyntax(syntaxNotation, string, string2));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append("( ");
            } else {
                stringBuilder.append(LOGICAL_OR);
            }
            stringBuilder.append(syntaxable.toState());
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(" )");
        }
        return stringBuilder.toString();
    }
}

