/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AllCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Operation;
import org.refcodes.cli.Option;
import org.refcodes.cli.OrCondition;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static String[][] ARGS = new String[][]{{"--name", "FILE", "--boolean", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static String[][] PROPERTIES = new String[][]{{"name=FILE", "boolean=true", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testParser1() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption});
        String[] stringArray = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser2() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AnyCondition anyCondition = new AnyCondition(new Syntaxable[]{xorCondition});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{anyCondition, stringOption});
        String[] stringArray = new String[]{"-f", "someFile", "-d"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        if (IS_LOG_TESTS) {
            System.out.println(andCondition.toUsage());
        }
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser3() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser4() throws AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser5() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            Assertions.assertEquals((int)1, (int)superfluousArgsException.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)superfluousArgsException.getArgs()[0]);
        }
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser6() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser7() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser8() {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag2, flag});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{stringOperand, xorCondition, stringOption, stringOption2});
        List list = andCondition.toOperands();
        Collections.sort(list);
        this.doLogOperands(list);
    }

    @Test
    public void testParser9() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-c", null, null, "Creates the specified file");
        OrCondition orCondition = new OrCondition(new Syntaxable[]{flag, flag2});
        Flag flag3 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{orCondition, flag3});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testAliasSyntaxTreeLookup() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption stringOption = new StringOption("-f", "--from", "from", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption stringOption2 = new StringOption("-t", "--to", "to", "The destination file to be processed");
        Flag flag = new Flag("-a", "--add", "add", "Add the specified file");
        Flag flag2 = new Flag("-c", "--create", "create", "Creates the specified file");
        OrCondition orCondition = new OrCondition(new Syntaxable[]{flag, flag2});
        Flag flag3 = new Flag("-d", "--delete", "delete", "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{orCondition, flag3});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        if (IS_LOG_TESTS) {
            System.out.println(andCondition.toUsage());
        }
        argsParserImpl.evalArgs(stringArray);
        String string = (String)andCondition.toValue("from");
        String string2 = (String)andCondition.toValue("to");
        boolean bl = (Boolean)andCondition.toValue("add");
        boolean bl2 = (Boolean)andCondition.toValue("create");
        boolean bl3 = (Boolean)andCondition.toValue("delete");
        if (IS_LOG_TESTS) {
            System.out.println("From := " + string);
        }
        if (IS_LOG_TESTS) {
            System.out.println("To := " + string2);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Add := " + bl);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Create := " + bl2);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Delete := " + bl3);
        }
        Assertions.assertEquals((Object)"fromFile", (Object)string);
        Assertions.assertEquals((Object)"toFile", (Object)string2);
        Assertions.assertTrue((boolean)bl);
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertFalse((boolean)bl3);
    }

    @Test
    public void testArgsProperties() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        for (int i = 0; i < ARGS.length; ++i) {
            this.testArgs(i);
        }
    }

    @Test
    public void testProductionError() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{"-l", "1", "-s", "100", "-f", "1"};
        DoubleOption doubleOption = CliSugar.doubleOption((String)"-f", (String)"--frequency", (String)"FREQUENCY_HZ", (String)"The frequency (Hz) to use when generating the values.");
        IntOption intOption = CliSugar.intOption((String)"-s", (String)"--sampling-rate", (String)"SAMPLING_RATE", (String)"The sample rate (per second) for the generated values (defaults to DEFAULT_SAMPLING_RATE_PER_SEC samples/second).");
        DoubleOption doubleOption2 = CliSugar.doubleOption((String)"-l", (String)"--length", (String)"LENGTH_SEC", (String)"The length (in seconds) for the generated values (defaults to DFAULT_LENGTH_SEC seconds).");
        ArgsSyntax argsSyntax = CliSugar.and((Syntaxable[])new Syntaxable[]{doubleOption, CliSugar.any((Syntaxable[])new Syntaxable[]{doubleOption2, intOption})});
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.withName("Waves").withTitle("~waves~").withCopyrightNote("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicenseNote("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        argsParserImpl.withBannerFont((Font)new FontImpl(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        argsParserImpl.withDescription("Generate (sound) wave tables for given frequencies and amplitudes. Export them as CSV for further processing. Makes heavy use of the  REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        argsParserImpl.evalArgs(stringArray);
    }

    @Test
    public void testXorEdgeCase1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        StringOption stringOption = CliSugar.stringOption((String)"-t", (String)"--text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        Flag flag = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given message.");
        ArgsSyntax argsSyntax = CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{flag, stringOption}), new AllCondition((Syntaxable)flag)});
        String[] stringArray = new String[]{"-t", "text", "-e"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertEquals((Object)"text", (Object)stringOption.getValue());
    }

    @Test
    public void testXorEdgeCase2() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        StringOption stringOption = CliSugar.stringOption((String)"-t", (String)"--text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        Flag flag = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given message.");
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{flag, stringOption}), flag});
        String[] stringArray = new String[]{"-t", "text", "-e"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertEquals((Object)"text", (Object)stringOption.getValue());
    }

    @Test
    public void testArrayOption1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toUsage());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption2() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toUsage());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption3() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3", "-t", "text4"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toUsage());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <SuperfluousArgsException>!");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption4() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toUsage());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption5() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toUsage());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)new AnyCondition(new Syntaxable[]{arrayOption}));
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        Assertions.assertFalse((boolean)arrayOption.hasValue());
        Assertions.assertNull((Object)arrayOption.getValue());
    }

    @Test
    public void testArrayOption6() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{"-t", "text1"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toUsage());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption7() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toUsage());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)new AnyCondition(new Syntaxable[]{arrayOption}));
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
        Assertions.assertEquals((int)(stringArray.length / 2), (int)((String[])arrayOption.getValue()).length);
    }

    @Test
    public void testOperation1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{new AndCondition(new Syntaxable[]{operation, verboseFlag}), operation2});
        String[] stringArray = new String[]{"ls", "--verbose"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)xorCondition);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)operation.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        xorCondition.reset();
        stringArray = new String[]{"cd"};
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)operation2.isEnabled());
    }

    @Test
    public void testNone1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        NoneOperand noneOperand = new NoneOperand("none", "No arguments at all");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{noneOperand, new AndCondition(new Syntaxable[]{operation, verboseFlag}), operation2});
        String[] stringArray = new String[]{"ls", "--verbose"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)xorCondition);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)operation.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        xorCondition.reset();
        stringArray = new String[]{"cd"};
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)operation2.isEnabled());
        Assertions.assertFalse((boolean)noneOperand.isEnabled());
    }

    @Test
    public void testNone2() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        NoneOperand noneOperand = new NoneOperand("none", "No arguments at all");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{noneOperand, new AndCondition(new Syntaxable[]{operation, verboseFlag}), operation2});
        String[] stringArray = new String[]{};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)xorCondition);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        Assertions.assertTrue((boolean)noneOperand.isEnabled());
    }

    private void testArgs(int n) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        ArgsParserImpl argsParserImpl = new ArgsParserImpl();
        HashMap<String, CallSite> hashMap = new HashMap<String, CallSite>();
        List list = argsParserImpl.evalArgs(ARGS[n]);
        for (Object object : list) {
            hashMap.put(object.getAlias(), (CallSite)((Object)("" + object.getValue())));
        }
        if (IS_LOG_TESTS) {
            System.out.println("Line <" + n + ">:");
        }
        for (Object object : hashMap.keySet()) {
            if (!IS_LOG_TESTS) continue;
            System.out.println((String)object + " := " + (String)hashMap.get(object));
        }
        Iterator<Object> iterator = PROPERTIES[n];
        for (int i = 0; i < ((Iterator<Object>)iterator).length; ++i) {
            PropertyImpl propertyImpl = new PropertyImpl(iterator[i]);
            if (((String)propertyImpl.getKey()).equals("null")) {
                propertyImpl = new PropertyImpl(null, (String)propertyImpl.getValue());
            }
            Assertions.assertEquals((Object)propertyImpl.getValue(), hashMap.get(propertyImpl.getKey()), (String)("Line <" + n + "> (" + propertyImpl.toString() + ")"));
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogArgs(ArgsParser argsParser, String[] stringArray) {
        ArgsSyntax argsSyntax = argsParser.getRootArgsSyntax();
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        argsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX).printHelp();
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.REFCODES + " SYNTAX NOTATION]  " + argsSyntax.toUsage(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.GNU_POSIX + " SYNTAX NOTATION] " + argsSyntax.toUsage(SyntaxNotation.GNU_POSIX));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[COMMAND LINE ARGS]         " + new VerboseTextBuilder().withElements((Object[])stringArray).toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("[INTERNAL STATUS]           " + argsSyntax.toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogOperands(List<? extends Operand<?>> list) {
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        for (Operand<?> operand : list) {
            if (!IS_LOG_TESTS) continue;
            System.out.println("[OPERAND] " + operand.toSyntax(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    static enum TrigonometricFunction {
        SINE,
        COSINE;

    }
}

