/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.cli.AbstractSyntaxable;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SyntaxUsage;
import org.refcodes.cli.Syntaxable;

public abstract class AbstractCondition
extends AbstractSyntaxable
implements Condition {
    private List<Syntaxable> _children = new ArrayList<Syntaxable>();

    public AbstractCondition(Syntaxable ... syntaxableArray) {
        this._children.addAll(Arrays.asList(syntaxableArray));
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(this.toUsage(syntaxNotation, string, string2));
        if (stringBuilder.length() > 0 && this.getChildren() != null && this.getChildren().size() > 1) {
            stringBuilder.insert(0, "( ");
            stringBuilder.append(" )");
        }
        return stringBuilder.toString();
    }

    public void reset() {
        for (Syntaxable syntaxable : this._children) {
            syntaxable.reset();
        }
    }

    public String toString() {
        String string = this.toState();
        if (string != null && string.length() >= 4 && string.startsWith("( ") && string.endsWith(" )")) {
            string = string.substring(2).substring(0, string.length() - 4);
        }
        return string;
    }

    public List<Operand<?>> toOperands() {
        ArrayList arrayList = new ArrayList();
        for (SyntaxUsage syntaxUsage : this.getChildren()) {
            if (syntaxUsage instanceof Operand) {
                arrayList.add((Operand)syntaxUsage);
            }
            if (!(syntaxUsage instanceof ArgsSyntax)) continue;
            arrayList.addAll(((ArgsSyntax)syntaxUsage).toOperands());
        }
        return arrayList;
    }

    protected List<Syntaxable> getChildren() {
        return this._children;
    }

    protected Syntaxable getFirst() {
        return this._children.get(0);
    }

    protected void addChild(Syntaxable syntaxable) {
        this._children.add(syntaxable);
    }

    @Override
    public <V> V toValue(String string) {
        for (Syntaxable syntaxable : this._children) {
            Object v = syntaxable.toValue(string);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public <T extends Operand<?>> T toOperand(String string, Class<T> clazz) {
        for (Syntaxable syntaxable : this.getChildren()) {
            ArgsSyntax argsSyntax;
            Operand operand;
            if (syntaxable instanceof Operand) {
                operand = (Operand)syntaxable;
                boolean bl = true;
                boolean bl2 = true;
                if (string != null && string.length() != 0) {
                    bl2 = string.equals(operand.getAlias());
                }
                if (clazz != null) {
                    bl = clazz.isAssignableFrom(operand.getClass());
                }
                if (!bl || !bl2) continue;
                return (T)operand;
            }
            if (!(syntaxable instanceof ArgsSyntax) || (operand = (argsSyntax = (ArgsSyntax)syntaxable).toOperand(string, clazz)) == null) continue;
            return (T)operand;
        }
        return null;
    }
}

