/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.textual.VerboseTextBuilder;

public class XorCondition
extends AbstractCondition
implements Condition {
    private static final String OTHER_RIGHT_TAG = " }";
    private static final String OTHER_LEFT_TAG = "{ ";
    private static final String RIGHT_TAG = " )";
    private static final String LEFT_TAG = "( ";
    private static final String GUN_POSIX_XOR = " | ";
    private static final String LOGICAL_XOR = " ^ ";

    public XorCondition(Syntaxable ... syntaxableArray) {
        super(syntaxableArray);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] stringArray, String[] stringArray2) throws ArgsSyntaxException {
        ArrayList<ArgsSyntax> arrayList = new ArrayList<ArgsSyntax>();
        List<Operand<?>> list = null;
        Syntaxable syntaxable = null;
        List<Operand<?>> list2 = null;
        int n = this.getChildren().size();
        for (Syntaxable syntaxable2 : this.getChildren()) {
            if (syntaxable2 instanceof AnyCondition) {
                arrayList.add((AnyCondition)syntaxable2);
            }
            try {
                list2 = list != null && syntaxable2 instanceof Operand && syntaxable instanceof Option ? syntaxable2.parseArgs(CliUtility.toDiff(stringArray, list), stringArray2) : syntaxable2.parseArgs(stringArray, stringArray2);
                if (list2 != null && list2.isEmpty()) {
                    list2 = null;
                }
            }
            catch (ArgsSyntaxException argsSyntaxException) {
                --n;
            }
            list = XorCondition.removeDuplicates(list, list2);
            if (list != null && list2 != null) {
                throw new AmbiguousArgsException(stringArray, "More than one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match: " + new VerboseTextBuilder().withElements((Object[])CliUtility.toArgs(list, list2)).toString());
            }
            if (list2 != null && !list2.isEmpty() && list == null) {
                list = list2;
                syntaxable = syntaxable2;
            }
            list2 = null;
        }
        if (n == 0) {
            throw new UnknownArgsException(stringArray, "Not one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match!");
        }
        if (n > 1) {
            if (arrayList.size() > 1 && stringArray != null && stringArray.length > 0) {
                throw new AmbiguousArgsException(stringArray, "More than one exclusive optional syntax matched the provided command line arguments, causing exclusive contextual ambiguity: " + new VerboseTextBuilder().withElements(XorCondition.toSpec(arrayList)).toString());
            }
            if ((n -= arrayList.size()) > 1) {
                throw new AmbiguousArgsException(stringArray, "More than one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match:");
            }
        }
        if (list != null) {
            return list;
        }
        if (arrayList.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        throw new UnknownArgsException(stringArray, "Not one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match!");
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.toSynopsis(syntaxNotation, string, string2, string3));
        if (stringBuilder.length() > 0 && this.getChildren() != null && this.getChildren().size() > 1) {
            if (syntaxNotation == SyntaxNotation.REFCODES) {
                stringBuilder.insert(0, LEFT_TAG);
            } else {
                stringBuilder.insert(0, OTHER_LEFT_TAG);
            }
            if (syntaxNotation == SyntaxNotation.REFCODES) {
                stringBuilder.append(RIGHT_TAG);
            } else {
                stringBuilder.append(OTHER_RIGHT_TAG);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String toSynopsis(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() != 0) {
                if (syntaxNotation == SyntaxNotation.REFCODES) {
                    stringBuilder.append(LOGICAL_XOR);
                } else {
                    stringBuilder.append(GUN_POSIX_XOR);
                }
            }
            stringBuilder.append(syntaxable.toSyntax(syntaxNotation, string, string2, string3));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(LEFT_TAG);
            } else {
                stringBuilder.append(LOGICAL_XOR);
            }
            stringBuilder.append(syntaxable.toState());
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(RIGHT_TAG);
        }
        return stringBuilder.toString();
    }

    private static List<String> toSpec(List<ArgsSyntax> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ArgsSyntax argsSyntax : list) {
            for (Operand<?> operand : argsSyntax.toOperands()) {
                arrayList.add(CliUtility.toSpec(operand));
            }
        }
        return arrayList;
    }

    private static List<Operand<?>> removeDuplicates(List<Operand<?>> list, List<Operand<?>> list2) {
        if (list != null && list2 != null) {
            for (Operand<?> operand : list2) {
                if (!list.contains(operand)) continue;
                list.remove(operand);
            }
            if (list.isEmpty()) {
                list = null;
            }
        }
        return list;
    }
}

